/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipFolder {
    private boolean isZipFileOpen = false;
    private File file = null;
    private Path folder = null;

    public static boolean zip(Path folder, File zipFile) {
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(zipFile);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        ZipOutputStream zos = new ZipOutputStream(fos);
        boolean result = ZipFolder.zipToZipStream(folder, "", zos);
        try {
            zos.close();
        }
        catch (IOException e) {
            return false;
        }
        try {
            fos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private static boolean zipToZipStream(Path folder, String prefix, ZipOutputStream zos) {
        boolean result = true;
        File[] files = folder.toFile().listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                ZipEntry e = new ZipEntry(String.valueOf(prefix) + files[i].getName() + "/");
                try {
                    zos.putNextEntry(e);
                }
                catch (IOException e1) {
                    result = false;
                }
                try {
                    zos.closeEntry();
                }
                catch (IOException e1) {
                    // empty catch block
                }
                result &= ZipFolder.zipToZipStream(files[i].toPath(), String.valueOf(prefix) + files[i].getName() + "/", zos);
            } else {
                byte[] buffer = new byte[1024];
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(files[i]);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                if (fis != null) {
                    try {
                        zos.putNextEntry(new ZipEntry(String.valueOf(prefix) + files[i].getName()));
                    }
                    catch (IOException e) {
                        result = false;
                    }
                    if (result) {
                        try {
                            int length;
                            while ((length = fis.read(buffer)) > 0) {
                                zos.write(buffer, 0, length);
                            }
                        }
                        catch (IOException e) {
                            result = false;
                        }
                    }
                    try {
                        zos.closeEntry();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            if (!result) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean zipHasEntry(File _zipFile, String fileName) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(_zipFile.getAbsolutePath());
        }
        catch (Throwable t) {
            return false;
        }
        return zipFile.getEntry(fileName) != null;
    }

    public static boolean unzip(File _zipFile, Path folder) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(_zipFile.getAbsolutePath());
        }
        catch (Throwable t) {
            return false;
        }
        folder.toFile().mkdirs();
        assert (zipFile != null);
        boolean result = true;
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (result && enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            BufferedInputStream bis = null;
            try {
                bis = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            }
            catch (Throwable t) {
                result = false;
            }
            if (!result) continue;
            File fEntry = new File(String.valueOf(folder.toAbsolutePath().toString()) + File.separator + zipEntry.getName());
            if (zipEntry.isDirectory()) {
                fEntry.mkdirs();
                continue;
            }
            fEntry.getParentFile().mkdirs();
            try {
                fEntry.createNewFile();
            }
            catch (IOException e) {
                result = false;
            }
            if (result) {
                byte[] buffer = new byte[2048];
                BufferedOutputStream bos = null;
                try {
                    bos = new BufferedOutputStream(new FileOutputStream(fEntry), buffer.length);
                }
                catch (FileNotFoundException e) {
                    result = false;
                }
                if (result) {
                    try {
                        int size;
                        while ((size = bis.read(buffer, 0, buffer.length)) != -1) {
                            bos.write(buffer, 0, size);
                        }
                        bos.flush();
                    }
                    catch (IOException e) {
                        result = false;
                    }
                    try {
                        bos.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            try {
                bis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            zipFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static boolean deleteFolder(Path folder) {
        try {
            Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return !folder.toFile().exists();
    }

    public boolean createNew() {
        if (this.isZipFileOpen) {
            return false;
        }
        try {
            this.folder = Files.createTempDirectory("tda2_temporary_", new FileAttribute[0]);
        }
        catch (IOException e) {
            return false;
        }
        this.file = null;
        this.isZipFileOpen = true;
        return true;
    }

    public boolean createFromTemplate(File zipFile) {
        boolean retVal = this.open(zipFile);
        this.file = null;
        return retVal;
    }

    public boolean open(File zipFile) {
        if (this.isZipFileOpen) {
            return false;
        }
        try {
            this.folder = Files.createTempDirectory("tda2_temporary_", new FileAttribute[0]);
        }
        catch (IOException e) {
            return false;
        }
        if (!ZipFolder.unzip(zipFile, this.folder)) {
            ZipFolder.deleteFolder(this.folder);
            this.folder = null;
            return false;
        }
        this.file = zipFile;
        this.isZipFileOpen = true;
        return true;
    }

    public boolean isOpen() {
        return this.isZipFileOpen;
    }

    public File getFile() {
        return this.file;
    }

    public Path getFolder() {
        return this.folder;
    }

    public boolean save() {
        return this.saveAs(this.file);
    }

    public boolean saveAs(File otherZipFile) {
        return this.saveAs(otherZipFile, true);
    }

    public boolean saveAs(File otherZipFile, boolean updateFileName) {
        if (otherZipFile == null) {
            return false;
        }
        boolean result = ZipFolder.zip(this.folder, otherZipFile);
        if (result && updateFileName) {
            this.file = otherZipFile;
        }
        return result;
    }

    public boolean setFile(File f) {
        if (f == null) {
            return false;
        }
        if (!f.exists()) {
            try {
                if (f.createNewFile()) {
                    this.file = f;
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
        this.file = f;
        return true;
    }

    public void close() {
        if (!this.isZipFileOpen) {
            return;
        }
        ZipFolder.deleteFolder(this.folder);
        this.file = null;
        this.folder = null;
        this.isZipFileOpen = false;
    }
}

