/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.util;

import java.util.HashMap;
import java.util.Map;
import lv.lumii.tda.util.ObjectsIndexer;

public class ReverseObjectsIndexer<T>
extends ObjectsIndexer<T> {
    private Map<T, Long> objectToIndex = new HashMap<T, Long>();

    public ReverseObjectsIndexer() {
        this.objectToIndex.put(null, 0L);
    }

    public ReverseObjectsIndexer(int numberOfBits) {
        super(numberOfBits);
        this.objectToIndex.put(null, 0L);
    }

    @Override
    public void freeIndex(long index) {
        if (index == 0L) {
            return;
        }
        Object obj = this.get(index);
        super.freeIndex(index);
        this.objectToIndex.remove(obj);
    }

    public T getObject(long index) {
        return super.get(index);
    }

    public long getIndex(T obj) {
        Long l = this.objectToIndex.get(obj);
        if (l == null) {
            long retVal = super.acquireIndex(obj);
            this.objectToIndex.put(obj, retVal);
            return retVal;
        }
        return l;
    }

    public long findIndex(T obj) {
        Long l = this.objectToIndex.get(obj);
        if (l == null) {
            return 0L;
        }
        return l;
    }

    @Override
    public void set(long index, T object) {
        Object oldObject = this.indexToObject.remove(index);
        if (oldObject != null) {
            this.objectToIndex.remove(oldObject);
        }
        super.set(index, object);
        this.objectToIndex.put(object, index);
    }
}

