/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.util;

import java.util.Timer;
import java.util.TimerTask;

public class ReschedulableTimer
extends Timer {
    private Runnable task = null;
    private TimerTask timerTask = null;

    public synchronized void schedule(Runnable runnable, long delay) {
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        this.task = runnable;
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                ReschedulableTimer.this.task.run();
            }
        };
        this.schedule(this.timerTask, delay);
    }

    public synchronized void reschedule(long delay) {
        if (this.task == null) {
            return;
        }
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                ReschedulableTimer.this.task.run();
            }
        };
        this.schedule(this.timerTask, delay);
    }

    @Override
    public synchronized void cancel() {
        if (this.timerTask == null) {
            return;
        }
        this.timerTask.cancel();
        this.timerTask = null;
    }
}

