/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class ObjectsIndexer<T> {
    private static long[] bitMasks = new long[65];
    private long bitMask = bitMasks[63];
    protected Map<Long, T> indexToObject = new HashMap<Long, T>();

    static {
        long mask = 0L;
        ObjectsIndexer.bitMasks[0] = 0L;
        int i = 1;
        while (i <= 64) {
            mask <<= 1;
            ObjectsIndexer.bitMasks[i] = mask |= 1L;
            i = (byte)(i + 1);
        }
    }

    public Map<Long, T> getMap() {
        return this.indexToObject;
    }

    public ObjectsIndexer() {
        this.indexToObject.put(0L, null);
    }

    public ObjectsIndexer(int numberOfBits) {
        this.setNumberOfBits(numberOfBits);
        this.indexToObject.put(0L, null);
    }

    public void setNumberOfBits(int numberOfBits) {
        if (numberOfBits >= 1 && numberOfBits <= 64) {
            this.bitMask = bitMasks[numberOfBits];
        }
    }

    public long acquireIndex() {
        return this.acquireIndex(null);
    }

    public long acquireIndex(T object) {
        Random rnd = new Random();
        long result = rnd.nextLong() & this.bitMask;
        if (result != 0L && !this.indexToObject.containsKey(result)) {
            this.indexToObject.put(result, object);
            return result;
        }
        int tries = 1;
        int MAX_TRIES = 20;
        do {
            if ((result = rnd.nextLong() & this.bitMask) == 0L || this.indexToObject.containsKey(result)) continue;
            this.indexToObject.put(result, object);
            return result;
        } while (++tries < 20);
        return 0L;
    }

    public void freeIndex(long index) {
        this.indexToObject.remove(index);
    }

    public T get(long index) {
        return this.indexToObject.get(index);
    }

    public void set(long index, T object) {
        this.indexToObject.remove(index);
        this.indexToObject.put(index, object);
    }
}

