/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class Indexer<T> {
    private static long[] bitMasks = new long[65];
    private long MAX_INDEX = bitMasks[31];
    private long largestIndex = 0L;
    private long indexesUsed = 0L;
    private Map<Long, T> indexToObject = new HashMap<Long, T>();
    private Map<T, Long> objectToIndex = new HashMap<T, Long>();

    static {
        long mask = 0L;
        Indexer.bitMasks[0] = 0L;
        int i = 1;
        while (i <= 64) {
            mask <<= 1;
            Indexer.bitMasks[i] = mask |= 1L;
            i = (byte)(i + 1);
        }
    }

    public Indexer() {
        this.indexToObject.put(0L, null);
        this.objectToIndex.put(null, 0L);
    }

    public boolean setMaximumNumberOfBits(int maxNumberOfBits) {
        if (maxNumberOfBits >= 1 && maxNumberOfBits <= 64) {
            this.MAX_INDEX = bitMasks[maxNumberOfBits];
            return true;
        }
        return false;
    }

    public long acquireIndex(T object) {
        long result;
        if (this.largestIndex < this.MAX_INDEX) {
            ++this.largestIndex;
            ++this.indexesUsed;
            this.indexToObject.put(this.largestIndex, object);
            this.objectToIndex.put(object, this.largestIndex);
            return this.largestIndex;
        }
        assert (this.largestIndex == this.MAX_INDEX);
        if (this.indexesUsed > this.MAX_INDEX >> 1) {
            return 0L;
        }
        Random rnd = new Random();
        while ((result = rnd.nextLong() & this.MAX_INDEX) == 0L || this.indexToObject.containsKey(result)) {
        }
        ++this.indexesUsed;
        this.indexToObject.put(result, object);
        this.objectToIndex.put(object, result);
        return result;
    }

    public boolean set(long index, T object) {
        T oldObject;
        Long oldIndex;
        if (index <= 0L || index > this.MAX_INDEX || object == null) {
            return false;
        }
        if (index > this.largestIndex) {
            this.largestIndex = index;
        }
        if (object != null && (oldIndex = this.objectToIndex.remove(object)) != null) {
            this.indexToObject.remove(oldIndex);
            --this.indexesUsed;
        }
        if ((oldObject = this.indexToObject.remove(index)) != null) {
            this.objectToIndex.remove(oldObject);
        } else {
            ++this.indexesUsed;
        }
        this.indexToObject.put(index, object);
        this.objectToIndex.put(object, index);
        return true;
    }

    public void freeIndex(long index) {
        T oldObject = this.indexToObject.get(index);
        if (index != 0L) {
            this.indexToObject.remove(index);
            if (oldObject != null) {
                this.objectToIndex.remove(oldObject);
            }
            --this.indexesUsed;
            if (index == this.largestIndex) {
                --this.largestIndex;
            }
        }
    }

    public T get(long index) {
        return this.indexToObject.get(index);
    }

    public long indexOf(T object) {
        Long l = this.objectToIndex.get(object);
        if (l == null) {
            return this.acquireIndex(object);
        }
        return l;
    }

    public boolean indexUsed(long index) {
        return index != 0L && this.indexToObject.containsKey(index);
    }
}

