/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class DynamicCast {
    public static <T> T cast(Object delegate, Class<T> type) {
        if (type.isInstance(delegate)) {
            return (T)delegate;
        }
        return (T)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)new MyInvocationHandler(delegate));
    }

    private static class MyInvocationHandler
    implements InvocationHandler {
        private Object delegate;

        public MyInvocationHandler(Object _delegate) {
            this.delegate = _delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Method delegateMethod = this.delegate.getClass().getMethod(method.getName(), method.getParameterTypes());
            if (delegateMethod == null) {
                delegateMethod = this.delegate.getClass().getMethod("_" + method.getName(), method.getParameterTypes());
            }
            return delegateMethod.invoke(this.delegate, args);
        }
    }
}

