/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.kernel.mmdparser;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.LinkedList;
import lv.lumii.tda.kernel.TDACopier;
import lv.lumii.tda.kernel.TDAKernel;
import lv.lumii.tda.kernel.mmdparser.MMDParser;
import lv.lumii.tda.raapi.IRepository;
import lv.lumii.tda.raapi.RAAPI;

public class MetamodelInserter {
    public static boolean insertMetamodel(URL url, RAAPI repository) {
        return MetamodelInserter.insertMetamodel(url, repository, null);
    }

    public static boolean insertMetamodel(URL url, RAAPI repository, StringBuffer errorMessages) {
        block19: {
            IRepository ecore;
            block22: {
                block21: {
                    block20: {
                        if (url == null) {
                            if (errorMessages != null) {
                                errorMessages.append("Metamodel insert error: incorrect resource URL.\n");
                            }
                            return false;
                        }
                        if (url.toString().toLowerCase().endsWith(".mmd")) {
                            boolean result = false;
                            try (InputStream is = url.openStream();){
                                result = MetamodelInserter.insertMMD(is, repository, errorMessages);
                            }
                            return result;
                        }
                        if (!url.toString().toLowerCase().endsWith(".ecore")) break block19;
                        ecore = TDAKernel.newRepositoryAdapter("ecore", null);
                        if (ecore != null) break block20;
                        if (errorMessages != null) {
                            errorMessages.append("Could not load the ECore adapter.\n");
                        }
                        return false;
                    }
                    if (ecore.open(url.toString())) break block21;
                    errorMessages.append("Could not open ECore at ." + url + "\n");
                    return false;
                }
                LinkedList<String> list = new LinkedList<String>();
                if (TDACopier.makeCopy(ecore, repository, list, true)) break block22;
                for (String s : list) {
                    errorMessages.append(String.valueOf(s) + "\n");
                }
                return false;
            }
            ecore.close();
            return true;
        }
        try {
            if (errorMessages != null) {
                errorMessages.append("The metamodel at " + url + " is of unknown format (only .mmd and .ecore are supported).\n");
            }
            return false;
        }
        catch (FileNotFoundException e) {
            if (errorMessages != null) {
                errorMessages.append("Metamodel not found at " + url + ".\n");
            }
            return false;
        }
        catch (IOException e) {
            if (errorMessages != null) {
                errorMessages.append("Error reading metamodel at " + url + ".\n");
            }
            return false;
        }
    }

    public static boolean insertMMD(InputStream is, RAAPI repository, StringBuffer errorMessages) {
        if (is == null) {
            return false;
        }
        StringWriter writer = new StringWriter();
        try {
            int readCount;
            char[] buf = new char[65536];
            InputStreamReader reader = new InputStreamReader(is);
            while ((readCount = reader.read(buf)) != -1) {
                ((Writer)writer).write(buf, 0, readCount);
            }
        }
        catch (IOException e) {
            return false;
        }
        byte[] bytes = ((Object)writer).toString().getBytes();
        boolean result = true;
        MMDParser p = new MMDParser(new ByteArrayInputStream(bytes));
        String errors = p.checkSyntax();
        if (errors != null) {
            result = false;
            if (errorMessages != null) {
                errorMessages.append("Error parsing the metamodel.\n" + errors);
            }
        } else {
            block11: {
                p.ReInit(new ByteArrayInputStream(bytes));
                try {
                    errors = p.loadMMD(repository);
                }
                catch (Throwable t) {
                    result = false;
                    if (errorMessages == null) break block11;
                    StringWriter sw = new StringWriter();
                    t.printStackTrace(new PrintWriter(sw));
                    errorMessages.append(sw.toString());
                }
            }
            if (errors != null) {
                result = false;
                if (errorMessages != null) {
                    errorMessages.append("Error loading the metamodel.\n" + errors);
                }
            }
        }
        return result;
    }
}

