/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.kernel.mmdparser;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import lv.lumii.tda.kernel.mmdparser.MMDParserConstants;
import lv.lumii.tda.kernel.mmdparser.MMDParserTokenManager;
import lv.lumii.tda.kernel.mmdparser.ParseException;
import lv.lumii.tda.kernel.mmdparser.SimpleCharStream;
import lv.lumii.tda.kernel.mmdparser.Token;
import lv.lumii.tda.raapi.RAAPI;

public class MMDParser
implements MMDParserConstants {
    public static boolean debug = false;
    private RAAPI repository;
    private boolean onlyCheckSyntax = true;
    private StringBuffer loadErrors = null;
    public MMDParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[6];
    private static int[] jj_la1_0;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    static {
        MMDParser.jj_la1_init_0();
    }

    private String removeQuotes(String s) {
        if (s.length() >= 2 && s.codePointAt(0) == 34 && s.codePointAt(s.length() - 1) == 34) {
            return s.substring(1, s.length() - 1);
        }
        if (s.length() >= 2 && s.codePointAt(0) == 8220 && s.codePointAt(s.length() - 1) == 8221) {
            return s.substring(1, s.length() - 1);
        }
        if (s.startsWith("'") && s.endsWith("'")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public String checkSyntax() {
        this.onlyCheckSyntax = true;
        try {
            this.repository = null;
            this.Start();
            return null;
        }
        catch (ParseException e1) {
            return e1.toString();
        }
    }

    public String loadMMD(RAAPI _repository) {
        block3: {
            this.onlyCheckSyntax = false;
            this.repository = _repository;
            this.loadErrors = new StringBuffer();
            try {
                this.Start();
                if (this.loadErrors.length() != 0) break block3;
                this.loadErrors = null;
                this.repository = null;
                return null;
            }
            catch (ParseException e1) {
                this.repository = null;
                String s = this.loadErrors.toString();
                this.loadErrors.delete(0, this.loadErrors.length());
                this.loadErrors = null;
                return s;
            }
        }
        this.repository = null;
        String s = this.loadErrors.toString();
        this.loadErrors.delete(0, this.loadErrors.length());
        this.loadErrors = null;
        return s;
    }

    public final void Start() throws ParseException {
        this.jj_consume_token(6);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 9: 
                case 10: 
                case 13: 
                case 15: 
                case 16: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            this.MetamodelOperation();
            this.jj_consume_token(7);
        }
        this.jj_consume_token(8);
        this.jj_consume_token(0);
    }

    public final void MetamodelOperation() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                this.Class();
                break;
            }
            case 10: {
                this.Attr();
                break;
            }
            case 13: {
                this.Rel();
                break;
            }
            case 15: 
            case 16: {
                this.Assoc();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Class() throws ParseException {
        this.jj_consume_token(9);
        this.jj_consume_token(27);
        if (!this.onlyCheckSyntax) {
            long r;
            if (debug) {
                System.out.println(" >>adding class `" + this.token.image + "'...");
            }
            if ((r = this.repository.findClass(this.removeQuotes(this.token.image))) == 0L && (r = this.repository.createClass(this.removeQuotes(this.token.image))) == 0L) {
                this.loadErrors.append("Could not add class `" + this.token.image + ".\n");
            }
            if (r != 0L) {
                this.repository.freeReference(r);
            }
        }
    }

    public final void Attr() throws ParseException {
        this.jj_consume_token(10);
        this.jj_consume_token(27);
        String className = this.removeQuotes(this.token.image);
        this.jj_consume_token(11);
        this.jj_consume_token(27);
        String attrName = this.removeQuotes(this.token.image);
        this.jj_consume_token(12);
        this.jj_consume_token(27);
        String attrType = this.removeQuotes(this.token.image);
        if (!this.onlyCheckSyntax) {
            long c;
            if (debug) {
                System.out.println(">>adding " + attrType + " attr " + attrName + " of " + className + "...");
            }
            if ((c = this.repository.findClass(className)) == 0L) {
                c = this.repository.createClass(className);
            }
            if (c != 0L) {
                long t = this.repository.findPrimitiveDataType(attrType);
                if (t != 0L) {
                    long r = this.repository.findAttribute(c, attrName);
                    if (r == 0L) {
                        r = this.repository.createAttribute(c, attrName, t);
                        if (r == 0L) {
                            this.loadErrors.append("Could not add attribute `" + attrName + "' of type `" + attrType + "' for class `" + className + "'.\n");
                        } else {
                            this.repository.freeReference(r);
                        }
                    } else {
                        long rt = this.repository.getAttributeType(r);
                        if (rt != t) {
                            this.loadErrors.append("Attribute `" + attrName + "' of type `" + attrType + "' for class `" + className + "' already exists, but has a different type (" + this.repository.getPrimitiveDataTypeName(rt) + " instead of " + this.repository.getPrimitiveDataTypeName(t) + ").\n");
                            if (rt != 0L) {
                                this.repository.freeReference(rt);
                            }
                        }
                        this.repository.freeReference(r);
                    }
                    this.repository.freeReference(t);
                } else {
                    this.loadErrors.append("Could not add attribute `" + attrName + "' of type `" + attrType + "' for class `" + className + "' since the type was not found.\n");
                }
                this.repository.freeReference(c);
            } else {
                this.loadErrors.append("Could not add attribute `" + attrName + "' of type `" + attrType + "' for class `" + className + "' since the class was not found.\n");
            }
        }
    }

    public final void Rel() throws ParseException {
        this.jj_consume_token(13);
        this.jj_consume_token(27);
        String subClassName = this.removeQuotes(this.token.image);
        this.jj_consume_token(11);
        this.jj_consume_token(14);
        this.jj_consume_token(11);
        this.jj_consume_token(27);
        String superClassName = this.removeQuotes(this.token.image);
        if (!this.onlyCheckSyntax) {
            boolean result;
            long superRef;
            long subRef;
            if (debug) {
                System.out.println(">>generalization " + subClassName + "->" + superClassName + "...");
            }
            if ((subRef = this.repository.findClass(subClassName)) == 0L) {
                subRef = this.repository.createClass(subClassName);
            }
            if ((superRef = this.repository.findClass(superClassName)) == 0L) {
                superRef = this.repository.createClass(superClassName);
            }
            boolean found = false;
            long it = this.repository.getIteratorForDirectSuperClasses(subRef);
            if (it != 0L) {
                long r = this.repository.resolveIteratorFirst(it);
                while (r != 0L) {
                    if (r == superRef) {
                        found = true;
                    }
                    this.repository.freeReference(r);
                    if (found) break;
                    r = this.repository.resolveIteratorNext(it);
                }
                this.repository.freeIterator(it);
            }
            if (!found && !(result = this.repository.createGeneralization(subRef, superRef))) {
                this.loadErrors.append("Could not create generalization: " + subClassName + "->" + superClassName + ".\n");
            }
            this.repository.freeReference(subRef);
            this.repository.freeReference(superRef);
        }
    }

    public final void Assoc() throws ParseException {
        boolean isComposition;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                isComposition = false;
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                isComposition = true;
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(27);
        String sourceClass = this.removeQuotes(this.token.image);
        this.jj_consume_token(11);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                this.jj_consume_token(17);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        boolean sourceOrdered = this.token.image.equals("{ordered}");
        this.jj_consume_token(18);
        this.Cardinality();
        String sourceCardinality = this.token.image;
        this.jj_consume_token(19);
        this.jj_consume_token(27);
        String sourceRole = this.removeQuotes(this.token.image);
        this.jj_consume_token(20);
        this.jj_consume_token(27);
        String targetRole = this.removeQuotes(this.token.image);
        this.jj_consume_token(18);
        this.Cardinality();
        String targetCardinality = this.token.image;
        this.jj_consume_token(19);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                this.jj_consume_token(17);
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        boolean targetOrdered = this.token.image.equals("{ordered}");
        this.jj_consume_token(11);
        this.jj_consume_token(27);
        String targetClass = this.removeQuotes(this.token.image);
        if (!this.onlyCheckSyntax) {
            if (debug) {
                if (isComposition) {
                    System.out.print(">>compos ");
                } else {
                    System.out.print(">>assoc ");
                }
                System.out.println(String.valueOf(sourceClass) + " " + sourceCardinality + " " + sourceRole + " " + sourceOrdered + " <-> " + targetClass + " " + targetCardinality + " " + targetRole + " " + targetOrdered + "...");
            }
            String msg = "Could not create ";
            msg = isComposition ? String.valueOf(msg) + "composition " : String.valueOf(msg) + "association ";
            msg = String.valueOf(msg) + "between " + sourceClass + "[" + sourceCardinality + "](" + sourceRole + ") and " + targetClass + "[" + targetCardinality + "](" + targetRole + ").";
            long sourceRef = this.repository.findClass(sourceClass);
            if (sourceRef == 0L) {
                sourceRef = this.repository.createClass(sourceClass);
            }
            if (sourceRef != 0L) {
                long targetRef = this.repository.findClass(targetClass);
                if (targetRef == 0L) {
                    targetRef = this.repository.createClass(targetClass);
                }
                if (targetRef != 0L) {
                    long r1 = this.repository.findAssociationEnd(sourceRef, targetRole);
                    if (r1 != 0L) {
                        long r2 = this.repository.getInverseAssociationEnd(r1);
                        if (r2 != 0L) {
                            if (!sourceRole.equals(this.repository.getRoleName(r2))) {
                                this.loadErrors.append(String.valueOf(msg) + " The association already exists, but has another inverse role.\n");
                            }
                            this.repository.freeReference(r2);
                        } else {
                            this.loadErrors.append(String.valueOf(msg) + " The association already exists and is unidirectional.\n");
                        }
                        this.repository.freeReference(r1);
                    } else {
                        long assocRef = this.repository.createAssociation(sourceRef, targetRef, sourceRole, targetRole, isComposition);
                        if (assocRef != 0L) {
                            this.repository.freeReference(assocRef);
                        } else {
                            this.loadErrors.append(String.valueOf(msg) + "\n");
                        }
                    }
                    this.repository.freeReference(targetRef);
                } else {
                    this.loadErrors.append(String.valueOf(msg) + " The target class not found.\n");
                }
                this.repository.freeReference(sourceRef);
            } else {
                this.loadErrors.append(String.valueOf(msg) + " The source class not found.\n");
            }
        }
    }

    public final void Cardinality() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: {
                this.jj_consume_token(21);
                break;
            }
            case 22: {
                this.jj_consume_token(22);
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                break;
            }
            case 25: {
                this.jj_consume_token(25);
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{108032, 108032, 98304, 131072, 131072, 0x7E00000};
    }

    public MMDParser(InputStream stream) {
        this(stream, null);
    }

    public MMDParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new MMDParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public MMDParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new MMDParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public MMDParser(MMDParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(MMDParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[28];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int i = 0;
        while (i < 6) {
            if (this.jj_la1[i] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 28) {
            if (la1tokens[i]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i;
                this.jj_expentries.add(this.jj_expentry);
            }
            ++i;
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i2 = 0;
        while (i2 < this.jj_expentries.size()) {
            exptokseq[i2] = this.jj_expentries.get(i2);
            ++i2;
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

