/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.kernel.mmdparser;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lv.lumii.tda.kernel.mmdparser.MMD2OWLConstants;
import lv.lumii.tda.kernel.mmdparser.MMD2OWLTokenManager;
import lv.lumii.tda.kernel.mmdparser.MMDParser;
import lv.lumii.tda.kernel.mmdparser.ParseException;
import lv.lumii.tda.kernel.mmdparser.SimpleCharStream;
import lv.lumii.tda.kernel.mmdparser.Token;
import org.apache.commons.io.IOUtils;

public class MMD2OWL
implements MMD2OWLConstants {
    public static boolean debug = false;
    private PrintStream output;
    private Set<String> names = new HashSet<String>();
    private Set<String> duplicateNames = new HashSet<String>();
    private boolean onlyCheckSyntax = true;
    private StringBuffer loadErrors = null;
    public MMD2OWLTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[6];
    private static int[] jj_la1_0;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    static {
        MMD2OWL.jj_la1_init_0();
    }

    public static void main(String[] args) throws ParseException {
        ByteArrayInputStream streamCopy;
        String str;
        try {
            str = IOUtils.toString((InputStream)System.in, (String)"UTF-8");
            byte[] b = str.getBytes("UTF-8");
            streamCopy = new ByteArrayInputStream(b);
        }
        catch (Throwable t) {
            System.err.println(t.toString());
            return;
        }
        HashSet<String> dups = new HashSet<String>();
        MMD2OWL p = new MMD2OWL(streamCopy);
        String err = p.checkSyntax(dups);
        if (err != null) {
            System.err.println("Syntax check error: " + err);
            return;
        }
        if (dups.size() > 0) {
            System.err.println(String.valueOf(dups.size()) + " duplicates found:");
            for (String s : dups) {
                System.err.println("  " + s);
            }
        }
        try {
            byte[] b = str.getBytes("UTF-8");
            streamCopy = new ByteArrayInputStream(b);
        }
        catch (Throwable t) {
            System.err.println(t.toString());
            return;
        }
        MMD2OWL p2 = new MMD2OWL(streamCopy);
        p2.setDuplicates(dups);
        err = p2.mmd2owl(System.out);
        if (err != null) {
            System.err.println("Error: " + err);
        }
    }

    private String removeQuotes(String s) {
        if (s.length() >= 2 && s.codePointAt(0) == 34 && s.codePointAt(s.length() - 1) == 34) {
            return s.substring(1, s.length() - 1);
        }
        if (s.length() >= 2 && s.codePointAt(0) == 8220 && s.codePointAt(s.length() - 1) == 8221) {
            return s.substring(1, s.length() - 1);
        }
        if (s.startsWith("'") && s.endsWith("'")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public void setDuplicates(Set<String> duplicates) {
        this.duplicateNames.addAll(duplicates);
    }

    public String checkSyntax(Set<String> returnedDuplicates) {
        this.onlyCheckSyntax = true;
        this.names.clear();
        this.duplicateNames.clear();
        try {
            this.output = null;
            this.Start();
            returnedDuplicates.addAll(this.duplicateNames);
            return null;
        }
        catch (ParseException e1) {
            return e1.toString();
        }
    }

    public String mmd2owl(PrintStream _output) {
        block3: {
            this.onlyCheckSyntax = false;
            this.output = _output;
            this.loadErrors = new StringBuffer();
            try {
                this.output.println("Prefix(:=<http://tda.lumii.lv/GraphDiagramEngineMetamodel/v1.5#>)");
                this.output.println("Prefix(xsd:=<http://www.w3.org/2001/XMLSchema#>)");
                this.output.println("Ontology( <http://tda.lumii.lv/GraphDiagramEngineMetamodel/v1.5>");
                this.Start();
                this.output.println(")");
                if (this.loadErrors.length() != 0) break block3;
                this.loadErrors = null;
                this.output = null;
                return null;
            }
            catch (ParseException e1) {
                this.output = null;
                String s = this.loadErrors.toString();
                this.loadErrors.delete(0, this.loadErrors.length());
                this.loadErrors = null;
                return e1.toString();
            }
        }
        this.output = null;
        String s = this.loadErrors.toString();
        this.loadErrors.delete(0, this.loadErrors.length());
        this.loadErrors = null;
        return s;
    }

    private String makeName(String s) {
        s = this.removeQuotes(s.replaceAll("\\s+", ""));
        int i = s.indexOf(":");
        while (i >= 0) {
            s = String.valueOf(s.substring(0, i)) + s.substring(i + 1);
            i = s.indexOf(":");
        }
        return s;
    }

    public final void Start() throws ParseException {
        this.jj_consume_token(6);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 9: 
                case 10: 
                case 13: 
                case 15: 
                case 16: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            this.MetamodelOperation();
            this.jj_consume_token(7);
        }
        this.jj_consume_token(8);
        this.jj_consume_token(0);
    }

    public final void MetamodelOperation() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                this.Class();
                break;
            }
            case 10: {
                this.Attr();
                break;
            }
            case 13: {
                this.Rel();
                break;
            }
            case 15: 
            case 16: {
                this.Assoc();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Class() throws ParseException {
        this.jj_consume_token(9);
        this.jj_consume_token(27);
        if (!this.onlyCheckSyntax) {
            if (MMDParser.debug) {
                System.out.println(" >>adding class `" + this.token.image + "'...");
            }
            this.output.println("Declaration(Class(:" + this.makeName(this.token.image) + "))");
        } else {
            String name = this.makeName(this.token.image);
            if (this.names.contains(name)) {
                this.duplicateNames.add(name);
            } else {
                this.names.add(name);
            }
        }
    }

    public final void Attr() throws ParseException {
        this.jj_consume_token(10);
        this.jj_consume_token(27);
        String className = this.makeName(this.token.image);
        this.jj_consume_token(11);
        this.jj_consume_token(27);
        String attrName = this.makeName(this.token.image);
        this.jj_consume_token(12);
        this.jj_consume_token(27);
        String attrType = this.makeName(this.token.image).toLowerCase();
        if (!this.onlyCheckSyntax) {
            if (this.duplicateNames.contains(attrName)) {
                attrName = String.valueOf(attrName) + "Of" + className;
            }
            if (MMDParser.debug) {
                System.out.println(">>adding " + attrType + " attr " + attrName + " of " + className + "...");
            }
            this.output.println("Declaration(DataProperty(:" + attrName + "))");
            this.output.println("DataPropertyDomain(:" + attrName + " :" + className + ")");
            if (attrType.startsWith("int")) {
                this.output.println("DataPropertyRange( :" + attrName + " xsd:integer )");
            } else if (attrType.equals("real") || attrType.equals("float")) {
                this.output.println("DataPropertyRange( :" + attrName + " xsd:decimal )");
            } else {
                this.output.println("DataPropertyRange( :" + attrName + " xsd:string )");
            }
        } else if (this.names.contains(attrName)) {
            this.duplicateNames.add(attrName);
        } else {
            this.names.add(attrName);
        }
    }

    public final void Rel() throws ParseException {
        this.jj_consume_token(13);
        this.jj_consume_token(27);
        String subClassName = this.makeName(this.token.image);
        this.jj_consume_token(11);
        this.jj_consume_token(14);
        this.jj_consume_token(11);
        this.jj_consume_token(27);
        String superClassName = this.makeName(this.token.image);
        if (!this.onlyCheckSyntax) {
            if (MMDParser.debug) {
                System.out.println(">>generalization " + subClassName + "->" + superClassName + "...");
            }
            this.output.println("SubClassOf(:" + subClassName + " :" + superClassName + ")");
        }
    }

    public final void Assoc() throws ParseException {
        boolean isComposition;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                isComposition = false;
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                isComposition = true;
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(27);
        String sourceClass = this.makeName(this.token.image);
        this.jj_consume_token(11);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                this.jj_consume_token(17);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        boolean sourceOrdered = this.token.image.equals("{ordered}");
        this.jj_consume_token(18);
        this.Cardinality();
        String sourceCardinality = this.token.image;
        this.jj_consume_token(19);
        this.jj_consume_token(27);
        String sourceRole = this.makeName(this.token.image);
        this.jj_consume_token(20);
        this.jj_consume_token(27);
        String targetRole = this.makeName(this.token.image);
        this.jj_consume_token(18);
        this.Cardinality();
        String targetCardinality = this.token.image;
        this.jj_consume_token(19);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                this.jj_consume_token(17);
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        boolean targetOrdered = this.token.image.equals("{ordered}");
        this.jj_consume_token(11);
        this.jj_consume_token(27);
        String targetClass = this.makeName(this.token.image);
        if (!this.onlyCheckSyntax) {
            if (this.duplicateNames.contains(sourceRole)) {
                sourceRole = String.valueOf(sourceRole) + "Of" + targetClass;
            }
            if (this.duplicateNames.contains(targetRole)) {
                targetRole = String.valueOf(targetRole) + "Of" + sourceClass;
            }
            if (MMDParser.debug) {
                if (isComposition) {
                    System.out.print(">>compos ");
                } else {
                    System.out.print(">>assoc ");
                }
                System.out.println(String.valueOf(sourceClass) + " " + sourceCardinality + " " + sourceRole + " " + sourceOrdered + " <-> " + targetClass + " " + targetCardinality + " " + targetRole + " " + targetOrdered + "...");
            }
            String msg = "Could not create ";
            msg = isComposition ? String.valueOf(msg) + "composition " : String.valueOf(msg) + "association ";
            msg = String.valueOf(msg) + "between " + sourceClass + "[" + sourceCardinality + "](" + sourceRole + ") and " + targetClass + "[" + targetCardinality + "](" + targetRole + ").";
            this.output.println("Declaration(ObjectProperty(:" + sourceRole + "))");
            this.output.println("Declaration(ObjectProperty(:" + targetRole + "))");
            this.output.println("InverseObjectProperties(:" + sourceRole + " :" + targetRole + ")");
            this.output.println("ObjectPropertyDomain(:" + targetRole + " :" + sourceClass + ")");
            this.output.println("ObjectPropertyRange(:" + targetRole + " :" + targetClass + ")");
            this.output.println("ObjectPropertyDomain(:" + sourceRole + " :" + targetClass + ")");
            this.output.println("ObjectPropertyRange(:" + sourceRole + " :" + sourceClass + ")");
        } else {
            if (this.names.contains(sourceRole)) {
                this.duplicateNames.add(sourceRole);
            } else {
                this.names.add(sourceRole);
            }
            if (this.names.contains(targetRole)) {
                this.duplicateNames.add(targetRole);
            } else {
                this.names.add(targetRole);
            }
        }
    }

    public final void Cardinality() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: {
                this.jj_consume_token(21);
                break;
            }
            case 22: {
                this.jj_consume_token(22);
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                break;
            }
            case 25: {
                this.jj_consume_token(25);
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{108032, 108032, 98304, 131072, 131072, 0x7E00000};
    }

    public MMD2OWL(InputStream stream) {
        this(stream, null);
    }

    public MMD2OWL(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new MMD2OWLTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public MMD2OWL(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new MMD2OWLTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public MMD2OWL(MMD2OWLTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(MMD2OWLTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 6) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[28];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int i = 0;
        while (i < 6) {
            if (this.jj_la1[i] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 28) {
            if (la1tokens[i]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i;
                this.jj_expentries.add(this.jj_expentry);
            }
            ++i;
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i2 = 0;
        while (i2 < this.jj_expentries.size()) {
            exptokseq[i2] = this.jj_expentries.get(i2);
            ++i2;
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

