/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.kernel.mm;

import java.util.ArrayList;
import lv.lumii.tda.kernel.mm.Command;
import lv.lumii.tda.kernel.mm.RAAPIReferenceWrapper;
import lv.lumii.tda.kernel.mm.TDAKernelMetamodelFactory;
import lv.lumii.tda.raapi.RAAPI;

public class UnmountRepositoryCommand
extends Command
implements RAAPIReferenceWrapper {
    @Override
    public RAAPI getRAAPI() {
        return this.factory.raapi;
    }

    @Override
    public long getRAAPIReference() {
        return this.rObject;
    }

    @Override
    public boolean delete() {
        if (this.rObject != 0L) {
            if (!this.takeReference) {
                System.err.println("Unable to delete the object " + this.rObject + " of type TDAKernel::UnmountRepositoryCommand since the RAAPI wrapper does not take care of this reference.");
                return false;
            }
            this.factory.wrappers.remove(this.rObject);
            boolean retVal = this.factory.raapi.deleteObject(this.rObject);
            if (retVal) {
                this.rObject = 0L;
            } else {
                this.factory.wrappers.put(this.rObject, this);
            }
            return retVal;
        }
        return false;
    }

    @Override
    public void finalize() {
        if (this.rObject != 0L) {
            if (this.takeReference) {
                this.factory.wrappers.remove(this.rObject);
                this.factory.raapi.freeReference(this.rObject);
            }
            this.rObject = 0L;
        }
    }

    UnmountRepositoryCommand(TDAKernelMetamodelFactory _factory) {
        super(_factory, _factory.raapi.createObject(_factory.UNMOUNTREPOSITORYCOMMAND), true);
        this.factory = _factory;
        this.rObject = this.rObject;
        this.takeReference = true;
        this.factory.wrappers.put(this.rObject, this);
    }

    public UnmountRepositoryCommand(TDAKernelMetamodelFactory _factory, long _rObject, boolean _takeReference) {
        super(_factory, _rObject, _takeReference);
    }

    public static Iterable<? extends UnmountRepositoryCommand> allObjects() {
        return UnmountRepositoryCommand.allObjects(TDAKernelMetamodelFactory.eINSTANCE);
    }

    public static Iterable<? extends UnmountRepositoryCommand> allObjects(TDAKernelMetamodelFactory factory) {
        ArrayList<UnmountRepositoryCommand> retVal = new ArrayList<UnmountRepositoryCommand>();
        long it = factory.raapi.getIteratorForAllClassObjects(factory.UNMOUNTREPOSITORYCOMMAND);
        if (it == 0L) {
            return retVal;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        while (r != 0L) {
            UnmountRepositoryCommand o = (UnmountRepositoryCommand)factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (o == null) {
                o = (UnmountRepositoryCommand)factory.findOrCreateRAAPIReferenceWrapper(UnmountRepositoryCommand.class, r, true);
            }
            if (o != null) {
                retVal.add(o);
            }
            r = factory.raapi.resolveIteratorNext(it);
        }
        factory.raapi.freeIterator(it);
        return retVal;
    }

    public static boolean deleteAllObjects() {
        return UnmountRepositoryCommand.deleteAllObjects(TDAKernelMetamodelFactory.eINSTANCE);
    }

    public static boolean deleteAllObjects(TDAKernelMetamodelFactory factory) {
        for (UnmountRepositoryCommand unmountRepositoryCommand : UnmountRepositoryCommand.allObjects(factory)) {
            unmountRepositoryCommand.delete();
        }
        return UnmountRepositoryCommand.firstObject(factory) == null;
    }

    public static UnmountRepositoryCommand firstObject() {
        return UnmountRepositoryCommand.firstObject(TDAKernelMetamodelFactory.eINSTANCE);
    }

    public static UnmountRepositoryCommand firstObject(TDAKernelMetamodelFactory factory) {
        long it = factory.raapi.getIteratorForAllClassObjects(factory.UNMOUNTREPOSITORYCOMMAND);
        if (it == 0L) {
            return null;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        factory.raapi.freeIterator(it);
        if (r == 0L) {
            return null;
        }
        UnmountRepositoryCommand retVal = (UnmountRepositoryCommand)factory.findOrCreateRAAPIReferenceWrapper(r, true);
        if (retVal == null) {
            retVal = (UnmountRepositoryCommand)factory.findOrCreateRAAPIReferenceWrapper(UnmountRepositoryCommand.class, r, true);
        }
        return retVal;
    }

    public String getMountPoint() {
        return this.factory.raapi.getAttributeValue(this.rObject, this.factory.UNMOUNTREPOSITORYCOMMAND_MOUNTPOINT);
    }

    public boolean setMountPoint(String value) {
        if (value == null) {
            return this.factory.raapi.deleteAttributeValue(this.rObject, this.factory.UNMOUNTREPOSITORYCOMMAND_MOUNTPOINT);
        }
        return this.factory.raapi.setAttributeValue(this.rObject, this.factory.UNMOUNTREPOSITORYCOMMAND_MOUNTPOINT, value.toString());
    }
}

