/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.kernel.mm;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import lv.lumii.tda.kernel.mm.RAAPIReferenceWrapper;
import lv.lumii.tda.kernel.mm.UndoMetamodelFactory;

class UndoMetamodel_RAAPILinkedObjectsList<E extends RAAPIReferenceWrapper>
implements List<E> {
    private UndoMetamodelFactory factory;
    private long rSourceObject;
    private long rAssociationEnd;

    UndoMetamodel_RAAPILinkedObjectsList(UndoMetamodelFactory _factory, long _rSourceObject, long _rAssociationEnd) {
        this.factory = _factory;
        this.rSourceObject = _rSourceObject;
        this.rAssociationEnd = _rAssociationEnd;
    }

    private ArrayList<Long> getLinkedObjects() {
        ArrayList<Long> retVal = new ArrayList<Long>();
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rSourceObject, this.rAssociationEnd);
        if (it == 0L) {
            return retVal;
        }
        long r = this.factory.raapi.resolveIteratorFirst(it);
        while (r != 0L) {
            retVal.add(r);
            r = this.factory.raapi.resolveIteratorNext(it);
        }
        this.factory.raapi.freeIterator(it);
        return retVal;
    }

    private void freeReferences(Collection<Long> c) {
        for (Long l : c) {
            this.factory.raapi.freeReference(l);
        }
    }

    @Override
    public boolean add(E e) {
        if (e.getRAAPI() != this.factory.raapi) {
            return false;
        }
        return this.factory.raapi.createLink(this.rSourceObject, e.getRAAPIReference(), this.rAssociationEnd);
    }

    @Override
    public void add(int index, E element) {
        if (element.getRAAPI() != this.factory.raapi) {
            return;
        }
        if (index < 0) {
            this.factory.raapi.createLink(this.rSourceObject, element.getRAAPIReference(), this.rAssociationEnd);
        } else {
            this.factory.raapi.createOrderedLink(this.rSourceObject, element.getRAAPIReference(), this.rAssociationEnd, index);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean ok = true;
        for (RAAPIReferenceWrapper element : c) {
            if (this.add((E)element)) continue;
            ok = false;
        }
        return ok;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        if (index < 0) {
            return this.addAll(c);
        }
        ArrayList<Long> list = this.getLinkedObjects();
        ArrayList<Long> listToFree = new ArrayList<Long>(list);
        this.clear();
        for (RAAPIReferenceWrapper element : c) {
            list.add(index, element.getRAAPIReference());
            ++index;
        }
        boolean ok = true;
        for (Long l : list) {
            if (this.factory.raapi.createLink(this.rSourceObject, l, this.rAssociationEnd)) continue;
            ok = false;
        }
        this.freeReferences(listToFree);
        return ok;
    }

    @Override
    public void clear() {
        for (Long l : this.getLinkedObjects()) {
            this.factory.raapi.deleteLink(this.rSourceObject, l, this.rAssociationEnd);
        }
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof RAAPIReferenceWrapper)) {
            return false;
        }
        if (((RAAPIReferenceWrapper)o).getRAAPI() != this.factory.raapi) {
            return false;
        }
        ArrayList<Long> list = this.getLinkedObjects();
        boolean retVal = list.contains(((RAAPIReferenceWrapper)o).getRAAPIReference());
        this.freeReferences(list);
        return retVal;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        ArrayList<Long> list = this.getLinkedObjects();
        ArrayList<Long> c2 = new ArrayList<Long>();
        for (Object o : c) {
            if (!(o instanceof RAAPIReferenceWrapper) || ((RAAPIReferenceWrapper)o).getRAAPI() != this.factory.raapi) continue;
            c2.add(((RAAPIReferenceWrapper)o).getRAAPIReference());
        }
        boolean retVal = list.containsAll(c2);
        this.freeReferences(list);
        return retVal;
    }

    @Override
    public E get(int index) {
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rSourceObject, this.rAssociationEnd);
        if (it == 0L) {
            return null;
        }
        long r = this.factory.raapi.resolveIterator(it, index);
        this.factory.raapi.freeIterator(it);
        RAAPIReferenceWrapper retVal = this.factory.findOrCreateRAAPIReferenceWrapper(r, true);
        if (retVal == null) {
            retVal = this.factory.findOrCreateRAAPIReferenceWrapper(this.factory.findClosestType(r), r, true);
        }
        return (E)retVal;
    }

    @Override
    public int indexOf(Object o) {
        if (!(o instanceof RAAPIReferenceWrapper)) {
            return -1;
        }
        if (((RAAPIReferenceWrapper)o).getRAAPI() != this.factory.raapi) {
            return -1;
        }
        ArrayList<Long> list = this.getLinkedObjects();
        int retVal = list.indexOf(((RAAPIReferenceWrapper)o).getRAAPIReference());
        this.freeReferences(list);
        return retVal;
    }

    @Override
    public boolean isEmpty() {
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rSourceObject, this.rAssociationEnd);
        if (it == 0L) {
            return true;
        }
        long r = this.factory.raapi.resolveIteratorFirst(it);
        if (r != 0L) {
            this.factory.raapi.freeReference(r);
        }
        this.factory.raapi.freeIterator(it);
        return r == 0L;
    }

    @Override
    public Iterator<E> iterator() {
        ArrayList<RAAPIReferenceWrapper> retVal = new ArrayList<RAAPIReferenceWrapper>();
        for (Long l : this.getLinkedObjects()) {
            RAAPIReferenceWrapper obj = this.factory.findOrCreateRAAPIReferenceWrapper(l, true);
            if (obj == null) {
                obj = this.factory.findOrCreateRAAPIReferenceWrapper(this.factory.findClosestType(l), l, true);
            }
            if (obj == null) continue;
            retVal.add(obj);
        }
        return retVal.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        ArrayList<RAAPIReferenceWrapper> retVal = new ArrayList<RAAPIReferenceWrapper>();
        for (Long l : this.getLinkedObjects()) {
            RAAPIReferenceWrapper obj = this.factory.findOrCreateRAAPIReferenceWrapper(l, true);
            if (obj == null) {
                obj = this.factory.findOrCreateRAAPIReferenceWrapper(this.factory.findClosestType(l), l, true);
            }
            if (obj == null) continue;
            retVal.add(obj);
        }
        return retVal.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        ListIterator<E> retVal = this.listIterator();
        int i = 0;
        while (i < index - 1) {
            if (retVal.hasNext()) {
                retVal.next();
            }
            ++i;
        }
        return retVal;
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof RAAPIReferenceWrapper)) {
            return false;
        }
        if (((RAAPIReferenceWrapper)o).getRAAPI() != this.factory.raapi) {
            return false;
        }
        return this.factory.raapi.deleteLink(this.rSourceObject, ((RAAPIReferenceWrapper)o).getRAAPIReference(), this.rAssociationEnd);
    }

    @Override
    public E remove(int index) {
        Object o = this.get(index);
        if (o == null) {
            return null;
        }
        if (this.remove(o)) {
            return (E)o;
        }
        return null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean ok = true;
        for (Object o : c) {
            if (this.remove(o)) continue;
            ok = false;
        }
        return ok;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.clear();
        boolean ok = true;
        for (Object o : c) {
            if (o instanceof RAAPIReferenceWrapper) {
                if (this.add((E)((RAAPIReferenceWrapper)o))) continue;
                ok = false;
                continue;
            }
            ok = false;
        }
        return ok;
    }

    @Override
    public E set(int index, E element) {
        Object old = this.remove(index);
        if (old == null) {
            return null;
        }
        this.add(index, element);
        return (E)old;
    }

    @Override
    public int size() {
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rSourceObject, this.rAssociationEnd);
        if (it == 0L) {
            return 0;
        }
        int retVal = this.factory.raapi.getIteratorLength(it);
        this.factory.raapi.freeIterator(it);
        return retVal;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not implemented for RAAPI wrappers");
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        ArrayList<Long> list = this.getLinkedObjects();
        ArrayList<RAAPIReferenceWrapper> list2 = new ArrayList<RAAPIReferenceWrapper>();
        for (Long l : list) {
            RAAPIReferenceWrapper o = this.factory.findOrCreateRAAPIReferenceWrapper(l, true);
            if (o == null) {
                try {
                    o = this.factory.findOrCreateRAAPIReferenceWrapper((Class)this.getClass().getMethod("toArray", Array.class).getGenericParameterTypes()[0], l, true);
                }
                catch (Throwable t) {
                    o = null;
                }
            }
            if (o != null) {
                list2.add(o);
                continue;
            }
            this.factory.raapi.freeReference(l);
        }
        return list2.toArray(a);
    }
}

