/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.kernel.mm;

import java.util.ArrayList;
import java.util.List;
import lv.lumii.tda.kernel.mm.HistoryStream;
import lv.lumii.tda.kernel.mm.RAAPIReferenceWrapper;
import lv.lumii.tda.kernel.mm.Transaction;
import lv.lumii.tda.kernel.mm.UndoIgnoringClass;
import lv.lumii.tda.kernel.mm.UndoMetamodelFactory;
import lv.lumii.tda.kernel.mm.UndoMetamodel_RAAPILinkedObjectsList;
import lv.lumii.tda.raapi.RAAPI;

public class UndoHistory
extends UndoIgnoringClass
implements RAAPIReferenceWrapper {
    @Override
    public RAAPI getRAAPI() {
        return this.factory.raapi;
    }

    @Override
    public long getRAAPIReference() {
        return this.rObject;
    }

    @Override
    public boolean delete() {
        if (this.rObject != 0L) {
            if (!this.takeReference) {
                System.err.println("Unable to delete the object " + this.rObject + " of type TDAKernel::UndoHistory since the RAAPI wrapper does not take care of this reference.");
                return false;
            }
            this.factory.wrappers.remove(this.rObject);
            boolean retVal = this.factory.raapi.deleteObject(this.rObject);
            if (retVal) {
                this.rObject = 0L;
            } else {
                this.factory.wrappers.put(this.rObject, this);
            }
            return retVal;
        }
        return false;
    }

    @Override
    public void finalize() {
        if (this.rObject != 0L) {
            if (this.takeReference) {
                this.factory.wrappers.remove(this.rObject);
                this.factory.raapi.freeReference(this.rObject);
            }
            this.rObject = 0L;
        }
    }

    UndoHistory(UndoMetamodelFactory _factory) {
        super(_factory, _factory.raapi.createObject(_factory.UNDOHISTORY), true);
        this.factory = _factory;
        this.rObject = this.rObject;
        this.takeReference = true;
        this.factory.wrappers.put(this.rObject, this);
    }

    public UndoHistory(UndoMetamodelFactory _factory, long _rObject, boolean _takeReference) {
        super(_factory, _rObject, _takeReference);
    }

    public static Iterable<? extends UndoHistory> allObjects() {
        return UndoHistory.allObjects(UndoMetamodelFactory.eINSTANCE);
    }

    public static Iterable<? extends UndoHistory> allObjects(UndoMetamodelFactory factory) {
        ArrayList<UndoHistory> retVal = new ArrayList<UndoHistory>();
        long it = factory.raapi.getIteratorForAllClassObjects(factory.UNDOHISTORY);
        if (it == 0L) {
            return retVal;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        while (r != 0L) {
            UndoHistory o = (UndoHistory)factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (o == null) {
                o = (UndoHistory)factory.findOrCreateRAAPIReferenceWrapper(UndoHistory.class, r, true);
            }
            if (o != null) {
                retVal.add(o);
            }
            r = factory.raapi.resolveIteratorNext(it);
        }
        factory.raapi.freeIterator(it);
        return retVal;
    }

    public static boolean deleteAllObjects() {
        return UndoHistory.deleteAllObjects(UndoMetamodelFactory.eINSTANCE);
    }

    public static boolean deleteAllObjects(UndoMetamodelFactory factory) {
        for (UndoHistory undoHistory : UndoHistory.allObjects(factory)) {
            undoHistory.delete();
        }
        return UndoHistory.firstObject(factory) == null;
    }

    public static UndoHistory firstObject() {
        return UndoHistory.firstObject(UndoMetamodelFactory.eINSTANCE);
    }

    public static UndoHistory firstObject(UndoMetamodelFactory factory) {
        long it = factory.raapi.getIteratorForAllClassObjects(factory.UNDOHISTORY);
        if (it == 0L) {
            return null;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        factory.raapi.freeIterator(it);
        if (r == 0L) {
            return null;
        }
        UndoHistory retVal = (UndoHistory)factory.findOrCreateRAAPIReferenceWrapper(r, true);
        if (retVal == null) {
            retVal = (UndoHistory)factory.findOrCreateRAAPIReferenceWrapper(UndoHistory.class, r, true);
        }
        return retVal;
    }

    public List<Transaction> getTransaction() {
        return new UndoMetamodel_RAAPILinkedObjectsList<Transaction>(this.factory, this.rObject, this.factory.UNDOHISTORY_TRANSACTION);
    }

    public boolean setTransaction(Transaction value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.UNDOHISTORY_TRANSACTION);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.UNDOHISTORY_TRANSACTION)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.UNDOHISTORY_TRANSACTION)) {
            ok = false;
        }
        return ok;
    }

    public Transaction getCurrentTransaction() {
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.UNDOHISTORY_CURRENTTRANSACTION);
        if (it == 0L) {
            return null;
        }
        long r = this.factory.raapi.resolveIteratorFirst(it);
        this.factory.raapi.freeIterator(it);
        if (r != 0L) {
            Transaction retVal = (Transaction)this.factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (retVal == null) {
                retVal = (Transaction)this.factory.findOrCreateRAAPIReferenceWrapper(Transaction.class, r, true);
            }
            return retVal;
        }
        return null;
    }

    public boolean setCurrentTransaction(Transaction value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.UNDOHISTORY_CURRENTTRANSACTION);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.UNDOHISTORY_CURRENTTRANSACTION)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.UNDOHISTORY_CURRENTTRANSACTION)) {
            ok = false;
        }
        return ok;
    }

    public List<HistoryStream> getHistoryStream() {
        return new UndoMetamodel_RAAPILinkedObjectsList<HistoryStream>(this.factory, this.rObject, this.factory.UNDOHISTORY_HISTORYSTREAM);
    }

    public boolean setHistoryStream(HistoryStream value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.UNDOHISTORY_HISTORYSTREAM);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.UNDOHISTORY_HISTORYSTREAM)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.UNDOHISTORY_HISTORYSTREAM)) {
            ok = false;
        }
        return ok;
    }
}

