/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.kernel.mm;

import java.util.ArrayList;
import java.util.List;
import lv.lumii.tda.kernel.mm.ModificatingAction;
import lv.lumii.tda.kernel.mm.RAAPIReferenceWrapper;
import lv.lumii.tda.kernel.mm.StreamState;
import lv.lumii.tda.kernel.mm.UndoHistory;
import lv.lumii.tda.kernel.mm.UndoIgnoringClass;
import lv.lumii.tda.kernel.mm.UndoMetamodelFactory;
import lv.lumii.tda.kernel.mm.UndoMetamodel_RAAPILinkedObjectsList;
import lv.lumii.tda.raapi.RAAPI;

public class Transaction
extends UndoIgnoringClass
implements RAAPIReferenceWrapper {
    @Override
    public RAAPI getRAAPI() {
        return this.factory.raapi;
    }

    @Override
    public long getRAAPIReference() {
        return this.rObject;
    }

    @Override
    public boolean delete() {
        if (this.rObject != 0L) {
            if (!this.takeReference) {
                System.err.println("Unable to delete the object " + this.rObject + " of type TDAKernel::Transaction since the RAAPI wrapper does not take care of this reference.");
                return false;
            }
            this.factory.wrappers.remove(this.rObject);
            boolean retVal = this.factory.raapi.deleteObject(this.rObject);
            if (retVal) {
                this.rObject = 0L;
            } else {
                this.factory.wrappers.put(this.rObject, this);
            }
            return retVal;
        }
        return false;
    }

    @Override
    public void finalize() {
        if (this.rObject != 0L) {
            if (this.takeReference) {
                this.factory.wrappers.remove(this.rObject);
                this.factory.raapi.freeReference(this.rObject);
            }
            this.rObject = 0L;
        }
    }

    Transaction(UndoMetamodelFactory _factory) {
        super(_factory, _factory.raapi.createObject(_factory.TRANSACTION), true);
        this.factory = _factory;
        this.rObject = this.rObject;
        this.takeReference = true;
        this.factory.wrappers.put(this.rObject, this);
    }

    public Transaction(UndoMetamodelFactory _factory, long _rObject, boolean _takeReference) {
        super(_factory, _rObject, _takeReference);
    }

    public static Iterable<? extends Transaction> allObjects() {
        return Transaction.allObjects(UndoMetamodelFactory.eINSTANCE);
    }

    public static Iterable<? extends Transaction> allObjects(UndoMetamodelFactory factory) {
        ArrayList<Transaction> retVal = new ArrayList<Transaction>();
        long it = factory.raapi.getIteratorForAllClassObjects(factory.TRANSACTION);
        if (it == 0L) {
            return retVal;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        while (r != 0L) {
            Transaction o = (Transaction)factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (o == null) {
                o = (Transaction)factory.findOrCreateRAAPIReferenceWrapper(Transaction.class, r, true);
            }
            if (o != null) {
                retVal.add(o);
            }
            r = factory.raapi.resolveIteratorNext(it);
        }
        factory.raapi.freeIterator(it);
        return retVal;
    }

    public static boolean deleteAllObjects() {
        return Transaction.deleteAllObjects(UndoMetamodelFactory.eINSTANCE);
    }

    public static boolean deleteAllObjects(UndoMetamodelFactory factory) {
        for (Transaction transaction : Transaction.allObjects(factory)) {
            transaction.delete();
        }
        return Transaction.firstObject(factory) == null;
    }

    public static Transaction firstObject() {
        return Transaction.firstObject(UndoMetamodelFactory.eINSTANCE);
    }

    public static Transaction firstObject(UndoMetamodelFactory factory) {
        long it = factory.raapi.getIteratorForAllClassObjects(factory.TRANSACTION);
        if (it == 0L) {
            return null;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        factory.raapi.freeIterator(it);
        if (r == 0L) {
            return null;
        }
        Transaction retVal = (Transaction)factory.findOrCreateRAAPIReferenceWrapper(r, true);
        if (retVal == null) {
            retVal = (Transaction)factory.findOrCreateRAAPIReferenceWrapper(Transaction.class, r, true);
        }
        return retVal;
    }

    public List<ModificatingAction> getModificatingAction() {
        return new UndoMetamodel_RAAPILinkedObjectsList<ModificatingAction>(this.factory, this.rObject, this.factory.TRANSACTION_MODIFICATINGACTION);
    }

    public boolean setModificatingAction(ModificatingAction value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.TRANSACTION_MODIFICATINGACTION);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.TRANSACTION_MODIFICATINGACTION)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.TRANSACTION_MODIFICATINGACTION)) {
            ok = false;
        }
        return ok;
    }

    public String getDescription() {
        return this.factory.raapi.getAttributeValue(this.rObject, this.factory.TRANSACTION_DESCRIPTION);
    }

    public boolean setDescription(String value) {
        if (value == null) {
            return this.factory.raapi.deleteAttributeValue(this.rObject, this.factory.TRANSACTION_DESCRIPTION);
        }
        return this.factory.raapi.setAttributeValue(this.rObject, this.factory.TRANSACTION_DESCRIPTION, value.toString());
    }

    public List<Transaction> getUndoDependency() {
        return new UndoMetamodel_RAAPILinkedObjectsList<Transaction>(this.factory, this.rObject, this.factory.TRANSACTION_UNDODEPENDENCY);
    }

    public boolean setUndoDependency(Transaction value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.TRANSACTION_UNDODEPENDENCY);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.TRANSACTION_UNDODEPENDENCY)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.TRANSACTION_UNDODEPENDENCY)) {
            ok = false;
        }
        return ok;
    }

    public List<Transaction> getRedoDependency() {
        return new UndoMetamodel_RAAPILinkedObjectsList<Transaction>(this.factory, this.rObject, this.factory.TRANSACTION_REDODEPENDENCY);
    }

    public boolean setRedoDependency(Transaction value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.TRANSACTION_REDODEPENDENCY);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.TRANSACTION_REDODEPENDENCY)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.TRANSACTION_REDODEPENDENCY)) {
            ok = false;
        }
        return ok;
    }

    public List<StreamState> getStreamState() {
        return new UndoMetamodel_RAAPILinkedObjectsList<StreamState>(this.factory, this.rObject, this.factory.TRANSACTION_STREAMSTATE);
    }

    public boolean setStreamState(StreamState value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.TRANSACTION_STREAMSTATE);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.TRANSACTION_STREAMSTATE)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.TRANSACTION_STREAMSTATE)) {
            ok = false;
        }
        return ok;
    }

    public UndoHistory getUndoHistory() {
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.TRANSACTION_UNDOHISTORY);
        if (it == 0L) {
            return null;
        }
        long r = this.factory.raapi.resolveIteratorFirst(it);
        this.factory.raapi.freeIterator(it);
        if (r != 0L) {
            UndoHistory retVal = (UndoHistory)this.factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (retVal == null) {
                retVal = (UndoHistory)this.factory.findOrCreateRAAPIReferenceWrapper(UndoHistory.class, r, true);
            }
            return retVal;
        }
        return null;
    }

    public boolean setUndoHistory(UndoHistory value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.TRANSACTION_UNDOHISTORY);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.TRANSACTION_UNDOHISTORY)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.TRANSACTION_UNDOHISTORY)) {
            ok = false;
        }
        return ok;
    }
}

