/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.kernel.mm;

import java.util.ArrayList;
import java.util.List;
import lv.lumii.tda.kernel.mm.Engine;
import lv.lumii.tda.kernel.mm.Package;
import lv.lumii.tda.kernel.mm.RAAPIReferenceWrapper;
import lv.lumii.tda.kernel.mm.TDAKernelMetamodelFactory;
import lv.lumii.tda.kernel.mm.TDAKernelMetamodel_RAAPILinkedObjectsList;
import lv.lumii.tda.raapi.RAAPI;

public class TDAKernel
implements RAAPIReferenceWrapper {
    protected TDAKernelMetamodelFactory factory;
    protected long rObject = 0L;
    protected boolean takeReference;

    @Override
    public RAAPI getRAAPI() {
        return this.factory.raapi;
    }

    @Override
    public long getRAAPIReference() {
        return this.rObject;
    }

    @Override
    public boolean delete() {
        if (this.rObject != 0L) {
            if (!this.takeReference) {
                System.err.println("Unable to delete the object " + this.rObject + " of type TDAKernel::TDAKernel since the RAAPI wrapper does not take care of this reference.");
                return false;
            }
            this.factory.wrappers.remove(this.rObject);
            boolean retVal = this.factory.raapi.deleteObject(this.rObject);
            if (retVal) {
                this.rObject = 0L;
            } else {
                this.factory.wrappers.put(this.rObject, this);
            }
            return retVal;
        }
        return false;
    }

    public void finalize() {
        if (this.rObject != 0L) {
            if (this.takeReference) {
                this.factory.wrappers.remove(this.rObject);
                this.factory.raapi.freeReference(this.rObject);
            }
            this.rObject = 0L;
        }
    }

    TDAKernel(TDAKernelMetamodelFactory _factory) {
        this.factory = _factory;
        this.rObject = this.factory.raapi.createObject(this.factory.TDAKERNEL);
        this.takeReference = true;
        this.factory.wrappers.put(this.rObject, this);
    }

    public TDAKernel(TDAKernelMetamodelFactory _factory, long _rObject, boolean _takeReference) {
        this.factory = _factory;
        this.rObject = _rObject;
        this.takeReference = _takeReference;
        if (this.takeReference) {
            this.factory.wrappers.put(this.rObject, this);
        }
    }

    public static Iterable<? extends TDAKernel> allObjects() {
        return TDAKernel.allObjects(TDAKernelMetamodelFactory.eINSTANCE);
    }

    public static Iterable<? extends TDAKernel> allObjects(TDAKernelMetamodelFactory factory) {
        ArrayList<TDAKernel> retVal = new ArrayList<TDAKernel>();
        long it = factory.raapi.getIteratorForAllClassObjects(factory.TDAKERNEL);
        if (it == 0L) {
            return retVal;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        while (r != 0L) {
            TDAKernel o = (TDAKernel)factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (o == null) {
                o = (TDAKernel)factory.findOrCreateRAAPIReferenceWrapper(TDAKernel.class, r, true);
            }
            if (o != null) {
                retVal.add(o);
            }
            r = factory.raapi.resolveIteratorNext(it);
        }
        factory.raapi.freeIterator(it);
        return retVal;
    }

    public static boolean deleteAllObjects() {
        return TDAKernel.deleteAllObjects(TDAKernelMetamodelFactory.eINSTANCE);
    }

    public static boolean deleteAllObjects(TDAKernelMetamodelFactory factory) {
        for (TDAKernel tDAKernel : TDAKernel.allObjects(factory)) {
            tDAKernel.delete();
        }
        return TDAKernel.firstObject(factory) == null;
    }

    public static TDAKernel firstObject() {
        return TDAKernel.firstObject(TDAKernelMetamodelFactory.eINSTANCE);
    }

    public static TDAKernel firstObject(TDAKernelMetamodelFactory factory) {
        long it = factory.raapi.getIteratorForAllClassObjects(factory.TDAKERNEL);
        if (it == 0L) {
            return null;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        factory.raapi.freeIterator(it);
        if (r == 0L) {
            return null;
        }
        TDAKernel retVal = (TDAKernel)factory.findOrCreateRAAPIReferenceWrapper(r, true);
        if (retVal == null) {
            retVal = (TDAKernel)factory.findOrCreateRAAPIReferenceWrapper(TDAKernel.class, r, true);
        }
        return retVal;
    }

    public List<Engine> getAttachedEngine() {
        return new TDAKernelMetamodel_RAAPILinkedObjectsList<Engine>(this.factory, this.rObject, this.factory.TDAKERNEL_ATTACHEDENGINE);
    }

    public boolean setAttachedEngine(Engine value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.TDAKERNEL_ATTACHEDENGINE);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.TDAKERNEL_ATTACHEDENGINE)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.TDAKERNEL_ATTACHEDENGINE)) {
            ok = false;
        }
        return ok;
    }

    public Package getRootPackage() {
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.TDAKERNEL_ROOTPACKAGE);
        if (it == 0L) {
            return null;
        }
        long r = this.factory.raapi.resolveIteratorFirst(it);
        this.factory.raapi.freeIterator(it);
        if (r != 0L) {
            Package retVal = (Package)this.factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (retVal == null) {
                retVal = (Package)this.factory.findOrCreateRAAPIReferenceWrapper(Package.class, r, true);
            }
            return retVal;
        }
        return null;
    }

    public boolean setRootPackage(Package value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.TDAKERNEL_ROOTPACKAGE);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.TDAKERNEL_ROOTPACKAGE)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.TDAKERNEL_ROOTPACKAGE)) {
            ok = false;
        }
        return ok;
    }

    public String getOnSaveStartedEvent() {
        return this.factory.raapi.getAttributeValue(this.rObject, this.factory.TDAKERNEL_ONSAVESTARTEDEVENT);
    }

    public boolean setOnSaveStartedEvent(String value) {
        if (value == null) {
            return this.factory.raapi.deleteAttributeValue(this.rObject, this.factory.TDAKERNEL_ONSAVESTARTEDEVENT);
        }
        return this.factory.raapi.setAttributeValue(this.rObject, this.factory.TDAKERNEL_ONSAVESTARTEDEVENT, value.toString());
    }

    public String getOnSaveFinishedEvent() {
        return this.factory.raapi.getAttributeValue(this.rObject, this.factory.TDAKERNEL_ONSAVEFINISHEDEVENT);
    }

    public boolean setOnSaveFinishedEvent(String value) {
        if (value == null) {
            return this.factory.raapi.deleteAttributeValue(this.rObject, this.factory.TDAKERNEL_ONSAVEFINISHEDEVENT);
        }
        return this.factory.raapi.setAttributeValue(this.rObject, this.factory.TDAKERNEL_ONSAVEFINISHEDEVENT, value.toString());
    }

    public String getOnSaveFailedEvent() {
        return this.factory.raapi.getAttributeValue(this.rObject, this.factory.TDAKERNEL_ONSAVEFAILEDEVENT);
    }

    public boolean setOnSaveFailedEvent(String value) {
        if (value == null) {
            return this.factory.raapi.deleteAttributeValue(this.rObject, this.factory.TDAKERNEL_ONSAVEFAILEDEVENT);
        }
        return this.factory.raapi.setAttributeValue(this.rObject, this.factory.TDAKERNEL_ONSAVEFAILEDEVENT, value.toString());
    }
}

