/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.kernel.mm;

import java.util.ArrayList;
import java.util.List;
import lv.lumii.tda.kernel.mm.HistoryStream;
import lv.lumii.tda.kernel.mm.RAAPIReferenceWrapper;
import lv.lumii.tda.kernel.mm.StreamStateCommand;
import lv.lumii.tda.kernel.mm.Transaction;
import lv.lumii.tda.kernel.mm.UndoIgnoringClass;
import lv.lumii.tda.kernel.mm.UndoMetamodelFactory;
import lv.lumii.tda.kernel.mm.UndoMetamodel_RAAPILinkedObjectsList;
import lv.lumii.tda.raapi.RAAPI;

public class StreamState
extends UndoIgnoringClass
implements RAAPIReferenceWrapper {
    @Override
    public RAAPI getRAAPI() {
        return this.factory.raapi;
    }

    @Override
    public long getRAAPIReference() {
        return this.rObject;
    }

    @Override
    public boolean delete() {
        if (this.rObject != 0L) {
            if (!this.takeReference) {
                System.err.println("Unable to delete the object " + this.rObject + " of type TDAKernel::StreamState since the RAAPI wrapper does not take care of this reference.");
                return false;
            }
            this.factory.wrappers.remove(this.rObject);
            boolean retVal = this.factory.raapi.deleteObject(this.rObject);
            if (retVal) {
                this.rObject = 0L;
            } else {
                this.factory.wrappers.put(this.rObject, this);
            }
            return retVal;
        }
        return false;
    }

    @Override
    public void finalize() {
        if (this.rObject != 0L) {
            if (this.takeReference) {
                this.factory.wrappers.remove(this.rObject);
                this.factory.raapi.freeReference(this.rObject);
            }
            this.rObject = 0L;
        }
    }

    StreamState(UndoMetamodelFactory _factory) {
        super(_factory, _factory.raapi.createObject(_factory.STREAMSTATE), true);
        this.factory = _factory;
        this.rObject = this.rObject;
        this.takeReference = true;
        this.factory.wrappers.put(this.rObject, this);
    }

    public StreamState(UndoMetamodelFactory _factory, long _rObject, boolean _takeReference) {
        super(_factory, _rObject, _takeReference);
    }

    public static Iterable<? extends StreamState> allObjects() {
        return StreamState.allObjects(UndoMetamodelFactory.eINSTANCE);
    }

    public static Iterable<? extends StreamState> allObjects(UndoMetamodelFactory factory) {
        ArrayList<StreamState> retVal = new ArrayList<StreamState>();
        long it = factory.raapi.getIteratorForAllClassObjects(factory.STREAMSTATE);
        if (it == 0L) {
            return retVal;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        while (r != 0L) {
            StreamState o = (StreamState)factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (o == null) {
                o = (StreamState)factory.findOrCreateRAAPIReferenceWrapper(StreamState.class, r, true);
            }
            if (o != null) {
                retVal.add(o);
            }
            r = factory.raapi.resolveIteratorNext(it);
        }
        factory.raapi.freeIterator(it);
        return retVal;
    }

    public static boolean deleteAllObjects() {
        return StreamState.deleteAllObjects(UndoMetamodelFactory.eINSTANCE);
    }

    public static boolean deleteAllObjects(UndoMetamodelFactory factory) {
        for (StreamState streamState : StreamState.allObjects(factory)) {
            streamState.delete();
        }
        return StreamState.firstObject(factory) == null;
    }

    public static StreamState firstObject() {
        return StreamState.firstObject(UndoMetamodelFactory.eINSTANCE);
    }

    public static StreamState firstObject(UndoMetamodelFactory factory) {
        long it = factory.raapi.getIteratorForAllClassObjects(factory.STREAMSTATE);
        if (it == 0L) {
            return null;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        factory.raapi.freeIterator(it);
        if (r == 0L) {
            return null;
        }
        StreamState retVal = (StreamState)factory.findOrCreateRAAPIReferenceWrapper(r, true);
        if (retVal == null) {
            retVal = (StreamState)factory.findOrCreateRAAPIReferenceWrapper(StreamState.class, r, true);
        }
        return retVal;
    }

    public HistoryStream getCurrentStateStream() {
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.STREAMSTATE_CURRENTSTATESTREAM);
        if (it == 0L) {
            return null;
        }
        long r = this.factory.raapi.resolveIteratorFirst(it);
        this.factory.raapi.freeIterator(it);
        if (r != 0L) {
            HistoryStream retVal = (HistoryStream)this.factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (retVal == null) {
                retVal = (HistoryStream)this.factory.findOrCreateRAAPIReferenceWrapper(HistoryStream.class, r, true);
            }
            return retVal;
        }
        return null;
    }

    public boolean setCurrentStateStream(HistoryStream value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.STREAMSTATE_CURRENTSTATESTREAM);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.STREAMSTATE_CURRENTSTATESTREAM)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.STREAMSTATE_CURRENTSTATESTREAM)) {
            ok = false;
        }
        return ok;
    }

    public StreamState getPrevious() {
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.STREAMSTATE_PREVIOUS);
        if (it == 0L) {
            return null;
        }
        long r = this.factory.raapi.resolveIteratorFirst(it);
        this.factory.raapi.freeIterator(it);
        if (r != 0L) {
            StreamState retVal = (StreamState)this.factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (retVal == null) {
                retVal = (StreamState)this.factory.findOrCreateRAAPIReferenceWrapper(StreamState.class, r, true);
            }
            return retVal;
        }
        return null;
    }

    public boolean setPrevious(StreamState value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.STREAMSTATE_PREVIOUS);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.STREAMSTATE_PREVIOUS)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.STREAMSTATE_PREVIOUS)) {
            ok = false;
        }
        return ok;
    }

    public List<StreamState> getEarlyNext() {
        return new UndoMetamodel_RAAPILinkedObjectsList<StreamState>(this.factory, this.rObject, this.factory.STREAMSTATE_EARLYNEXT);
    }

    public boolean setEarlyNext(StreamState value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.STREAMSTATE_EARLYNEXT);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.STREAMSTATE_EARLYNEXT)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.STREAMSTATE_EARLYNEXT)) {
            ok = false;
        }
        return ok;
    }

    public StreamState getNext() {
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.STREAMSTATE_NEXT);
        if (it == 0L) {
            return null;
        }
        long r = this.factory.raapi.resolveIteratorFirst(it);
        this.factory.raapi.freeIterator(it);
        if (r != 0L) {
            StreamState retVal = (StreamState)this.factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (retVal == null) {
                retVal = (StreamState)this.factory.findOrCreateRAAPIReferenceWrapper(StreamState.class, r, true);
            }
            return retVal;
        }
        return null;
    }

    public boolean setNext(StreamState value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.STREAMSTATE_NEXT);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.STREAMSTATE_NEXT)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.STREAMSTATE_NEXT)) {
            ok = false;
        }
        return ok;
    }

    public List<StreamState> getLateNext() {
        return new UndoMetamodel_RAAPILinkedObjectsList<StreamState>(this.factory, this.rObject, this.factory.STREAMSTATE_LATENEXT);
    }

    public boolean setLateNext(StreamState value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.STREAMSTATE_LATENEXT);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.STREAMSTATE_LATENEXT)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.STREAMSTATE_LATENEXT)) {
            ok = false;
        }
        return ok;
    }

    public Transaction getTransaction() {
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.STREAMSTATE_TRANSACTION);
        if (it == 0L) {
            return null;
        }
        long r = this.factory.raapi.resolveIteratorFirst(it);
        this.factory.raapi.freeIterator(it);
        if (r != 0L) {
            Transaction retVal = (Transaction)this.factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (retVal == null) {
                retVal = (Transaction)this.factory.findOrCreateRAAPIReferenceWrapper(Transaction.class, r, true);
            }
            return retVal;
        }
        return null;
    }

    public boolean setTransaction(Transaction value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.STREAMSTATE_TRANSACTION);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.STREAMSTATE_TRANSACTION)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.STREAMSTATE_TRANSACTION)) {
            ok = false;
        }
        return ok;
    }

    public StreamStateCommand getStreamStateCommand() {
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.STREAMSTATE_STREAMSTATECOMMAND);
        if (it == 0L) {
            return null;
        }
        long r = this.factory.raapi.resolveIteratorFirst(it);
        this.factory.raapi.freeIterator(it);
        if (r != 0L) {
            StreamStateCommand retVal = (StreamStateCommand)this.factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (retVal == null) {
                retVal = (StreamStateCommand)this.factory.findOrCreateRAAPIReferenceWrapper(StreamStateCommand.class, r, true);
            }
            return retVal;
        }
        return null;
    }

    public boolean setStreamStateCommand(StreamStateCommand value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.STREAMSTATE_STREAMSTATECOMMAND);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.STREAMSTATE_STREAMSTATECOMMAND)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.STREAMSTATE_STREAMSTATECOMMAND)) {
            ok = false;
        }
        return ok;
    }

    public HistoryStream getHistoryStream() {
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.STREAMSTATE_HISTORYSTREAM);
        if (it == 0L) {
            return null;
        }
        long r = this.factory.raapi.resolveIteratorFirst(it);
        this.factory.raapi.freeIterator(it);
        if (r != 0L) {
            HistoryStream retVal = (HistoryStream)this.factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (retVal == null) {
                retVal = (HistoryStream)this.factory.findOrCreateRAAPIReferenceWrapper(HistoryStream.class, r, true);
            }
            return retVal;
        }
        return null;
    }

    public boolean setHistoryStream(HistoryStream value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.STREAMSTATE_HISTORYSTREAM);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.STREAMSTATE_HISTORYSTREAM)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.STREAMSTATE_HISTORYSTREAM)) {
            ok = false;
        }
        return ok;
    }
}

