/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.kernel.mm;

import java.util.ArrayList;
import java.util.List;
import lv.lumii.tda.kernel.mm.Package;
import lv.lumii.tda.kernel.mm.ProxyReference;
import lv.lumii.tda.kernel.mm.RAAPIReferenceWrapper;
import lv.lumii.tda.kernel.mm.TDAKernelMetamodelFactory;
import lv.lumii.tda.kernel.mm.TDAKernelMetamodel_RAAPILinkedObjectsList;
import lv.lumii.tda.raapi.RAAPI;

public class Repository
implements RAAPIReferenceWrapper {
    protected TDAKernelMetamodelFactory factory;
    protected long rObject = 0L;
    protected boolean takeReference;

    @Override
    public RAAPI getRAAPI() {
        return this.factory.raapi;
    }

    @Override
    public long getRAAPIReference() {
        return this.rObject;
    }

    @Override
    public boolean delete() {
        if (this.rObject != 0L) {
            if (!this.takeReference) {
                System.err.println("Unable to delete the object " + this.rObject + " of type TDAKernel::Repository since the RAAPI wrapper does not take care of this reference.");
                return false;
            }
            this.factory.wrappers.remove(this.rObject);
            boolean retVal = this.factory.raapi.deleteObject(this.rObject);
            if (retVal) {
                this.rObject = 0L;
            } else {
                this.factory.wrappers.put(this.rObject, this);
            }
            return retVal;
        }
        return false;
    }

    public void finalize() {
        if (this.rObject != 0L) {
            if (this.takeReference) {
                this.factory.wrappers.remove(this.rObject);
                this.factory.raapi.freeReference(this.rObject);
            }
            this.rObject = 0L;
        }
    }

    Repository(TDAKernelMetamodelFactory _factory) {
        this.factory = _factory;
        this.rObject = this.factory.raapi.createObject(this.factory.REPOSITORY);
        this.takeReference = true;
        this.factory.wrappers.put(this.rObject, this);
    }

    public Repository(TDAKernelMetamodelFactory _factory, long _rObject, boolean _takeReference) {
        this.factory = _factory;
        this.rObject = _rObject;
        this.takeReference = _takeReference;
        if (this.takeReference) {
            this.factory.wrappers.put(this.rObject, this);
        }
    }

    public static Iterable<? extends Repository> allObjects() {
        return Repository.allObjects(TDAKernelMetamodelFactory.eINSTANCE);
    }

    public static Iterable<? extends Repository> allObjects(TDAKernelMetamodelFactory factory) {
        ArrayList<Repository> retVal = new ArrayList<Repository>();
        long it = factory.raapi.getIteratorForAllClassObjects(factory.REPOSITORY);
        if (it == 0L) {
            return retVal;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        while (r != 0L) {
            Repository o = (Repository)factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (o == null) {
                o = (Repository)factory.findOrCreateRAAPIReferenceWrapper(Repository.class, r, true);
            }
            if (o != null) {
                retVal.add(o);
            }
            r = factory.raapi.resolveIteratorNext(it);
        }
        factory.raapi.freeIterator(it);
        return retVal;
    }

    public static boolean deleteAllObjects() {
        return Repository.deleteAllObjects(TDAKernelMetamodelFactory.eINSTANCE);
    }

    public static boolean deleteAllObjects(TDAKernelMetamodelFactory factory) {
        for (Repository repository : Repository.allObjects(factory)) {
            repository.delete();
        }
        return Repository.firstObject(factory) == null;
    }

    public static Repository firstObject() {
        return Repository.firstObject(TDAKernelMetamodelFactory.eINSTANCE);
    }

    public static Repository firstObject(TDAKernelMetamodelFactory factory) {
        long it = factory.raapi.getIteratorForAllClassObjects(factory.REPOSITORY);
        if (it == 0L) {
            return null;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        factory.raapi.freeIterator(it);
        if (r == 0L) {
            return null;
        }
        Repository retVal = (Repository)factory.findOrCreateRAAPIReferenceWrapper(r, true);
        if (retVal == null) {
            retVal = (Repository)factory.findOrCreateRAAPIReferenceWrapper(Repository.class, r, true);
        }
        return retVal;
    }

    public List<Package> getMountPoint() {
        return new TDAKernelMetamodel_RAAPILinkedObjectsList<Package>(this.factory, this.rObject, this.factory.REPOSITORY_MOUNTPOINT);
    }

    public boolean setMountPoint(Package value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.REPOSITORY_MOUNTPOINT);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.REPOSITORY_MOUNTPOINT)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.REPOSITORY_MOUNTPOINT)) {
            ok = false;
        }
        return ok;
    }

    public List<Package> getPackage() {
        return new TDAKernelMetamodel_RAAPILinkedObjectsList<Package>(this.factory, this.rObject, this.factory.REPOSITORY_PACKAGE);
    }

    public boolean setPackage(Package value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.REPOSITORY_PACKAGE);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.REPOSITORY_PACKAGE)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.REPOSITORY_PACKAGE)) {
            ok = false;
        }
        return ok;
    }

    public String getUri() {
        return this.factory.raapi.getAttributeValue(this.rObject, this.factory.REPOSITORY_URI);
    }

    public boolean setUri(String value) {
        if (value == null) {
            return this.factory.raapi.deleteAttributeValue(this.rObject, this.factory.REPOSITORY_URI);
        }
        return this.factory.raapi.setAttributeValue(this.rObject, this.factory.REPOSITORY_URI, value.toString());
    }

    public List<ProxyReference> getProxyReference() {
        return new TDAKernelMetamodel_RAAPILinkedObjectsList<ProxyReference>(this.factory, this.rObject, this.factory.REPOSITORY_PROXYREFERENCE);
    }

    public boolean setProxyReference(ProxyReference value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.REPOSITORY_PROXYREFERENCE);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.REPOSITORY_PROXYREFERENCE)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.REPOSITORY_PROXYREFERENCE)) {
            ok = false;
        }
        return ok;
    }

    public Package getCoveredPackage() {
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.REPOSITORY_COVEREDPACKAGE);
        if (it == 0L) {
            return null;
        }
        long r = this.factory.raapi.resolveIteratorFirst(it);
        this.factory.raapi.freeIterator(it);
        if (r != 0L) {
            Package retVal = (Package)this.factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (retVal == null) {
                retVal = (Package)this.factory.findOrCreateRAAPIReferenceWrapper(Package.class, r, true);
            }
            return retVal;
        }
        return null;
    }

    public boolean setCoveredPackage(Package value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.REPOSITORY_COVEREDPACKAGE);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.REPOSITORY_COVEREDPACKAGE)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.REPOSITORY_COVEREDPACKAGE)) {
            ok = false;
        }
        return ok;
    }
}

