/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.kernel.mm;

import java.util.ArrayList;
import java.util.List;
import lv.lumii.tda.kernel.mm.InterAttributeValue;
import lv.lumii.tda.kernel.mm.InterDirectedAssociation;
import lv.lumii.tda.kernel.mm.InterDirectedLink;
import lv.lumii.tda.kernel.mm.Package;
import lv.lumii.tda.kernel.mm.RAAPIReferenceWrapper;
import lv.lumii.tda.kernel.mm.Repository;
import lv.lumii.tda.kernel.mm.TDAKernelMetamodelFactory;
import lv.lumii.tda.kernel.mm.TDAKernelMetamodel_RAAPILinkedObjectsList;
import lv.lumii.tda.raapi.RAAPI;

public class ProxyReference
implements RAAPIReferenceWrapper {
    protected TDAKernelMetamodelFactory factory;
    protected long rObject = 0L;
    protected boolean takeReference;

    @Override
    public RAAPI getRAAPI() {
        return this.factory.raapi;
    }

    @Override
    public long getRAAPIReference() {
        return this.rObject;
    }

    @Override
    public boolean delete() {
        if (this.rObject != 0L) {
            if (!this.takeReference) {
                System.err.println("Unable to delete the object " + this.rObject + " of type TDAKernel::ProxyReference since the RAAPI wrapper does not take care of this reference.");
                return false;
            }
            this.factory.wrappers.remove(this.rObject);
            boolean retVal = this.factory.raapi.deleteObject(this.rObject);
            if (retVal) {
                this.rObject = 0L;
            } else {
                this.factory.wrappers.put(this.rObject, this);
            }
            return retVal;
        }
        return false;
    }

    public void finalize() {
        if (this.rObject != 0L) {
            if (this.takeReference) {
                this.factory.wrappers.remove(this.rObject);
                this.factory.raapi.freeReference(this.rObject);
            }
            this.rObject = 0L;
        }
    }

    ProxyReference(TDAKernelMetamodelFactory _factory) {
        this.factory = _factory;
        this.rObject = this.factory.raapi.createObject(this.factory.PROXYREFERENCE);
        this.takeReference = true;
        this.factory.wrappers.put(this.rObject, this);
    }

    public ProxyReference(TDAKernelMetamodelFactory _factory, long _rObject, boolean _takeReference) {
        this.factory = _factory;
        this.rObject = _rObject;
        this.takeReference = _takeReference;
        if (this.takeReference) {
            this.factory.wrappers.put(this.rObject, this);
        }
    }

    public static Iterable<? extends ProxyReference> allObjects() {
        return ProxyReference.allObjects(TDAKernelMetamodelFactory.eINSTANCE);
    }

    public static Iterable<? extends ProxyReference> allObjects(TDAKernelMetamodelFactory factory) {
        ArrayList<ProxyReference> retVal = new ArrayList<ProxyReference>();
        long it = factory.raapi.getIteratorForAllClassObjects(factory.PROXYREFERENCE);
        if (it == 0L) {
            return retVal;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        while (r != 0L) {
            ProxyReference o = (ProxyReference)factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (o == null) {
                o = (ProxyReference)factory.findOrCreateRAAPIReferenceWrapper(ProxyReference.class, r, true);
            }
            if (o != null) {
                retVal.add(o);
            }
            r = factory.raapi.resolveIteratorNext(it);
        }
        factory.raapi.freeIterator(it);
        return retVal;
    }

    public static boolean deleteAllObjects() {
        return ProxyReference.deleteAllObjects(TDAKernelMetamodelFactory.eINSTANCE);
    }

    public static boolean deleteAllObjects(TDAKernelMetamodelFactory factory) {
        for (ProxyReference proxyReference : ProxyReference.allObjects(factory)) {
            proxyReference.delete();
        }
        return ProxyReference.firstObject(factory) == null;
    }

    public static ProxyReference firstObject() {
        return ProxyReference.firstObject(TDAKernelMetamodelFactory.eINSTANCE);
    }

    public static ProxyReference firstObject(TDAKernelMetamodelFactory factory) {
        long it = factory.raapi.getIteratorForAllClassObjects(factory.PROXYREFERENCE);
        if (it == 0L) {
            return null;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        factory.raapi.freeIterator(it);
        if (r == 0L) {
            return null;
        }
        ProxyReference retVal = (ProxyReference)factory.findOrCreateRAAPIReferenceWrapper(r, true);
        if (retVal == null) {
            retVal = (ProxyReference)factory.findOrCreateRAAPIReferenceWrapper(ProxyReference.class, r, true);
        }
        return retVal;
    }

    public String getSerializedDomesticReference() {
        return this.factory.raapi.getAttributeValue(this.rObject, this.factory.PROXYREFERENCE_SERIALIZEDDOMESTICREFERENCE);
    }

    public boolean setSerializedDomesticReference(String value) {
        if (value == null) {
            return this.factory.raapi.deleteAttributeValue(this.rObject, this.factory.PROXYREFERENCE_SERIALIZEDDOMESTICREFERENCE);
        }
        return this.factory.raapi.setAttributeValue(this.rObject, this.factory.PROXYREFERENCE_SERIALIZEDDOMESTICREFERENCE, value.toString());
    }

    public List<InterDirectedLink> getOutgoingLink() {
        return new TDAKernelMetamodel_RAAPILinkedObjectsList<InterDirectedLink>(this.factory, this.rObject, this.factory.PROXYREFERENCE_OUTGOINGLINK);
    }

    public boolean setOutgoingLink(InterDirectedLink value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.PROXYREFERENCE_OUTGOINGLINK);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.PROXYREFERENCE_OUTGOINGLINK)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.PROXYREFERENCE_OUTGOINGLINK)) {
            ok = false;
        }
        return ok;
    }

    public List<InterDirectedLink> getIngoingLink() {
        return new TDAKernelMetamodel_RAAPILinkedObjectsList<InterDirectedLink>(this.factory, this.rObject, this.factory.PROXYREFERENCE_INGOINGLINK);
    }

    public boolean setIngoingLink(InterDirectedLink value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.PROXYREFERENCE_INGOINGLINK);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.PROXYREFERENCE_INGOINGLINK)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.PROXYREFERENCE_INGOINGLINK)) {
            ok = false;
        }
        return ok;
    }

    public List<InterDirectedLink> getInterDirectedLink() {
        return new TDAKernelMetamodel_RAAPILinkedObjectsList<InterDirectedLink>(this.factory, this.rObject, this.factory.PROXYREFERENCE_INTERDIRECTEDLINK);
    }

    public boolean setInterDirectedLink(InterDirectedLink value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.PROXYREFERENCE_INTERDIRECTEDLINK);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.PROXYREFERENCE_INTERDIRECTEDLINK)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.PROXYREFERENCE_INTERDIRECTEDLINK)) {
            ok = false;
        }
        return ok;
    }

    public List<InterAttributeValue> getInterAttributeValue() {
        return new TDAKernelMetamodel_RAAPILinkedObjectsList<InterAttributeValue>(this.factory, this.rObject, this.factory.PROXYREFERENCE_INTERATTRIBUTEVALUE);
    }

    public boolean setInterAttributeValue(InterAttributeValue value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.PROXYREFERENCE_INTERATTRIBUTEVALUE);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.PROXYREFERENCE_INTERATTRIBUTEVALUE)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.PROXYREFERENCE_INTERATTRIBUTEVALUE)) {
            ok = false;
        }
        return ok;
    }

    public List<InterAttributeValue> getValue() {
        return new TDAKernelMetamodel_RAAPILinkedObjectsList<InterAttributeValue>(this.factory, this.rObject, this.factory.PROXYREFERENCE_VALUE);
    }

    public boolean setValue(InterAttributeValue value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.PROXYREFERENCE_VALUE);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.PROXYREFERENCE_VALUE)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.PROXYREFERENCE_VALUE)) {
            ok = false;
        }
        return ok;
    }

    public List<ProxyReference> getInterSuperClass() {
        return new TDAKernelMetamodel_RAAPILinkedObjectsList<ProxyReference>(this.factory, this.rObject, this.factory.PROXYREFERENCE_INTERSUPERCLASS);
    }

    public boolean setInterSuperClass(ProxyReference value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.PROXYREFERENCE_INTERSUPERCLASS);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.PROXYREFERENCE_INTERSUPERCLASS)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.PROXYREFERENCE_INTERSUPERCLASS)) {
            ok = false;
        }
        return ok;
    }

    public List<ProxyReference> getInterSubClass() {
        return new TDAKernelMetamodel_RAAPILinkedObjectsList<ProxyReference>(this.factory, this.rObject, this.factory.PROXYREFERENCE_INTERSUBCLASS);
    }

    public boolean setInterSubClass(ProxyReference value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.PROXYREFERENCE_INTERSUBCLASS);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.PROXYREFERENCE_INTERSUBCLASS)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.PROXYREFERENCE_INTERSUBCLASS)) {
            ok = false;
        }
        return ok;
    }

    public List<InterDirectedAssociation> getOutgoingAssociation() {
        return new TDAKernelMetamodel_RAAPILinkedObjectsList<InterDirectedAssociation>(this.factory, this.rObject, this.factory.PROXYREFERENCE_OUTGOINGASSOCIATION);
    }

    public boolean setOutgoingAssociation(InterDirectedAssociation value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.PROXYREFERENCE_OUTGOINGASSOCIATION);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.PROXYREFERENCE_OUTGOINGASSOCIATION)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.PROXYREFERENCE_OUTGOINGASSOCIATION)) {
            ok = false;
        }
        return ok;
    }

    public List<InterDirectedAssociation> getIngoingAssociation() {
        return new TDAKernelMetamodel_RAAPILinkedObjectsList<InterDirectedAssociation>(this.factory, this.rObject, this.factory.PROXYREFERENCE_INGOINGASSOCIATION);
    }

    public boolean setIngoingAssociation(InterDirectedAssociation value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.PROXYREFERENCE_INGOINGASSOCIATION);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.PROXYREFERENCE_INGOINGASSOCIATION)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.PROXYREFERENCE_INGOINGASSOCIATION)) {
            ok = false;
        }
        return ok;
    }

    public Package getPackage() {
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.PROXYREFERENCE_PACKAGE);
        if (it == 0L) {
            return null;
        }
        long r = this.factory.raapi.resolveIteratorFirst(it);
        this.factory.raapi.freeIterator(it);
        if (r != 0L) {
            Package retVal = (Package)this.factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (retVal == null) {
                retVal = (Package)this.factory.findOrCreateRAAPIReferenceWrapper(Package.class, r, true);
            }
            return retVal;
        }
        return null;
    }

    public boolean setPackage(Package value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.PROXYREFERENCE_PACKAGE);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.PROXYREFERENCE_PACKAGE)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.PROXYREFERENCE_PACKAGE)) {
            ok = false;
        }
        return ok;
    }

    public List<ProxyReference> getInterType() {
        return new TDAKernelMetamodel_RAAPILinkedObjectsList<ProxyReference>(this.factory, this.rObject, this.factory.PROXYREFERENCE_INTERTYPE);
    }

    public boolean setInterType(ProxyReference value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.PROXYREFERENCE_INTERTYPE);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.PROXYREFERENCE_INTERTYPE)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.PROXYREFERENCE_INTERTYPE)) {
            ok = false;
        }
        return ok;
    }

    public List<ProxyReference> getInterInstance() {
        return new TDAKernelMetamodel_RAAPILinkedObjectsList<ProxyReference>(this.factory, this.rObject, this.factory.PROXYREFERENCE_INTERINSTANCE);
    }

    public boolean setInterInstance(ProxyReference value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.PROXYREFERENCE_INTERINSTANCE);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.PROXYREFERENCE_INTERINSTANCE)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.PROXYREFERENCE_INTERINSTANCE)) {
            ok = false;
        }
        return ok;
    }

    public List<InterDirectedLink> getNextInterDirectedLink() {
        return new TDAKernelMetamodel_RAAPILinkedObjectsList<InterDirectedLink>(this.factory, this.rObject, this.factory.PROXYREFERENCE_NEXTINTERDIRECTEDLINK);
    }

    public boolean setNextInterDirectedLink(InterDirectedLink value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.PROXYREFERENCE_NEXTINTERDIRECTEDLINK);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.PROXYREFERENCE_NEXTINTERDIRECTEDLINK)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.PROXYREFERENCE_NEXTINTERDIRECTEDLINK)) {
            ok = false;
        }
        return ok;
    }

    public Repository getRepository() {
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.PROXYREFERENCE_REPOSITORY);
        if (it == 0L) {
            return null;
        }
        long r = this.factory.raapi.resolveIteratorFirst(it);
        this.factory.raapi.freeIterator(it);
        if (r != 0L) {
            Repository retVal = (Repository)this.factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (retVal == null) {
                retVal = (Repository)this.factory.findOrCreateRAAPIReferenceWrapper(Repository.class, r, true);
            }
            return retVal;
        }
        return null;
    }

    public boolean setRepository(Repository value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.PROXYREFERENCE_REPOSITORY);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.PROXYREFERENCE_REPOSITORY)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.PROXYREFERENCE_REPOSITORY)) {
            ok = false;
        }
        return ok;
    }
}

