/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.kernel.mm;

import java.util.ArrayList;
import java.util.List;
import lv.lumii.tda.kernel.mm.ProxyReference;
import lv.lumii.tda.kernel.mm.RAAPIReferenceWrapper;
import lv.lumii.tda.kernel.mm.Repository;
import lv.lumii.tda.kernel.mm.TDAKernel;
import lv.lumii.tda.kernel.mm.TDAKernelMetamodelFactory;
import lv.lumii.tda.kernel.mm.TDAKernelMetamodel_RAAPILinkedObjectsList;
import lv.lumii.tda.raapi.RAAPI;

public class Package
implements RAAPIReferenceWrapper {
    protected TDAKernelMetamodelFactory factory;
    protected long rObject = 0L;
    protected boolean takeReference;

    @Override
    public RAAPI getRAAPI() {
        return this.factory.raapi;
    }

    @Override
    public long getRAAPIReference() {
        return this.rObject;
    }

    @Override
    public boolean delete() {
        if (this.rObject != 0L) {
            if (!this.takeReference) {
                System.err.println("Unable to delete the object " + this.rObject + " of type TDAKernel::Package since the RAAPI wrapper does not take care of this reference.");
                return false;
            }
            this.factory.wrappers.remove(this.rObject);
            boolean retVal = this.factory.raapi.deleteObject(this.rObject);
            if (retVal) {
                this.rObject = 0L;
            } else {
                this.factory.wrappers.put(this.rObject, this);
            }
            return retVal;
        }
        return false;
    }

    public void finalize() {
        if (this.rObject != 0L) {
            if (this.takeReference) {
                this.factory.wrappers.remove(this.rObject);
                this.factory.raapi.freeReference(this.rObject);
            }
            this.rObject = 0L;
        }
    }

    Package(TDAKernelMetamodelFactory _factory) {
        this.factory = _factory;
        this.rObject = this.factory.raapi.createObject(this.factory.PACKAGE);
        this.takeReference = true;
        this.factory.wrappers.put(this.rObject, this);
    }

    public Package(TDAKernelMetamodelFactory _factory, long _rObject, boolean _takeReference) {
        this.factory = _factory;
        this.rObject = _rObject;
        this.takeReference = _takeReference;
        if (this.takeReference) {
            this.factory.wrappers.put(this.rObject, this);
        }
    }

    public static Iterable<? extends Package> allObjects() {
        return Package.allObjects(TDAKernelMetamodelFactory.eINSTANCE);
    }

    public static Iterable<? extends Package> allObjects(TDAKernelMetamodelFactory factory) {
        ArrayList<Package> retVal = new ArrayList<Package>();
        long it = factory.raapi.getIteratorForAllClassObjects(factory.PACKAGE);
        if (it == 0L) {
            return retVal;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        while (r != 0L) {
            Package o = (Package)factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (o == null) {
                o = (Package)factory.findOrCreateRAAPIReferenceWrapper(Package.class, r, true);
            }
            if (o != null) {
                retVal.add(o);
            }
            r = factory.raapi.resolveIteratorNext(it);
        }
        factory.raapi.freeIterator(it);
        return retVal;
    }

    public static boolean deleteAllObjects() {
        return Package.deleteAllObjects(TDAKernelMetamodelFactory.eINSTANCE);
    }

    public static boolean deleteAllObjects(TDAKernelMetamodelFactory factory) {
        for (Package package_ : Package.allObjects(factory)) {
            package_.delete();
        }
        return Package.firstObject(factory) == null;
    }

    public static Package firstObject() {
        return Package.firstObject(TDAKernelMetamodelFactory.eINSTANCE);
    }

    public static Package firstObject(TDAKernelMetamodelFactory factory) {
        long it = factory.raapi.getIteratorForAllClassObjects(factory.PACKAGE);
        if (it == 0L) {
            return null;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        factory.raapi.freeIterator(it);
        if (r == 0L) {
            return null;
        }
        Package retVal = (Package)factory.findOrCreateRAAPIReferenceWrapper(r, true);
        if (retVal == null) {
            retVal = (Package)factory.findOrCreateRAAPIReferenceWrapper(Package.class, r, true);
        }
        return retVal;
    }

    public Repository getMountedRepository() {
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.PACKAGE_MOUNTEDREPOSITORY);
        if (it == 0L) {
            return null;
        }
        long r = this.factory.raapi.resolveIteratorFirst(it);
        this.factory.raapi.freeIterator(it);
        if (r != 0L) {
            Repository retVal = (Repository)this.factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (retVal == null) {
                retVal = (Repository)this.factory.findOrCreateRAAPIReferenceWrapper(Repository.class, r, true);
            }
            return retVal;
        }
        return null;
    }

    public boolean setMountedRepository(Repository value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.PACKAGE_MOUNTEDREPOSITORY);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.PACKAGE_MOUNTEDREPOSITORY)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.PACKAGE_MOUNTEDREPOSITORY)) {
            ok = false;
        }
        return ok;
    }

    public Package getParent() {
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.PACKAGE_PARENT);
        if (it == 0L) {
            return null;
        }
        long r = this.factory.raapi.resolveIteratorFirst(it);
        this.factory.raapi.freeIterator(it);
        if (r != 0L) {
            Package retVal = (Package)this.factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (retVal == null) {
                retVal = (Package)this.factory.findOrCreateRAAPIReferenceWrapper(Package.class, r, true);
            }
            return retVal;
        }
        return null;
    }

    public boolean setParent(Package value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.PACKAGE_PARENT);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.PACKAGE_PARENT)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.PACKAGE_PARENT)) {
            ok = false;
        }
        return ok;
    }

    public List<Package> getChild() {
        return new TDAKernelMetamodel_RAAPILinkedObjectsList<Package>(this.factory, this.rObject, this.factory.PACKAGE_CHILD);
    }

    public boolean setChild(Package value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.PACKAGE_CHILD);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.PACKAGE_CHILD)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.PACKAGE_CHILD)) {
            ok = false;
        }
        return ok;
    }

    public Repository getAssociatedRepository() {
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.PACKAGE_ASSOCIATEDREPOSITORY);
        if (it == 0L) {
            return null;
        }
        long r = this.factory.raapi.resolveIteratorFirst(it);
        this.factory.raapi.freeIterator(it);
        if (r != 0L) {
            Repository retVal = (Repository)this.factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (retVal == null) {
                retVal = (Repository)this.factory.findOrCreateRAAPIReferenceWrapper(Repository.class, r, true);
            }
            return retVal;
        }
        return null;
    }

    public boolean setAssociatedRepository(Repository value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.PACKAGE_ASSOCIATEDREPOSITORY);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.PACKAGE_ASSOCIATEDREPOSITORY)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.PACKAGE_ASSOCIATEDREPOSITORY)) {
            ok = false;
        }
        return ok;
    }

    public TDAKernel getKernel() {
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.PACKAGE_KERNEL);
        if (it == 0L) {
            return null;
        }
        long r = this.factory.raapi.resolveIteratorFirst(it);
        this.factory.raapi.freeIterator(it);
        if (r != 0L) {
            TDAKernel retVal = (TDAKernel)this.factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (retVal == null) {
                retVal = (TDAKernel)this.factory.findOrCreateRAAPIReferenceWrapper(TDAKernel.class, r, true);
            }
            return retVal;
        }
        return null;
    }

    public boolean setKernel(TDAKernel value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.PACKAGE_KERNEL);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.PACKAGE_KERNEL)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.PACKAGE_KERNEL)) {
            ok = false;
        }
        return ok;
    }

    public List<ProxyReference> getProxyReference() {
        return new TDAKernelMetamodel_RAAPILinkedObjectsList<ProxyReference>(this.factory, this.rObject, this.factory.PACKAGE_PROXYREFERENCE);
    }

    public boolean setProxyReference(ProxyReference value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.PACKAGE_PROXYREFERENCE);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.PACKAGE_PROXYREFERENCE)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.PACKAGE_PROXYREFERENCE)) {
            ok = false;
        }
        return ok;
    }

    public String getSimpleName() {
        return this.factory.raapi.getAttributeValue(this.rObject, this.factory.PACKAGE_SIMPLENAME);
    }

    public boolean setSimpleName(String value) {
        if (value == null) {
            return this.factory.raapi.deleteAttributeValue(this.rObject, this.factory.PACKAGE_SIMPLENAME);
        }
        return this.factory.raapi.setAttributeValue(this.rObject, this.factory.PACKAGE_SIMPLENAME, value.toString());
    }

    public List<Repository> getStackedRepository() {
        return new TDAKernelMetamodel_RAAPILinkedObjectsList<Repository>(this.factory, this.rObject, this.factory.PACKAGE_STACKEDREPOSITORY);
    }

    public boolean setStackedRepository(Repository value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.PACKAGE_STACKEDREPOSITORY);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.PACKAGE_STACKEDREPOSITORY)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.PACKAGE_STACKEDREPOSITORY)) {
            ok = false;
        }
        return ok;
    }
}

