/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.kernel.mm;

import java.util.ArrayList;
import lv.lumii.tda.kernel.mm.Command;
import lv.lumii.tda.kernel.mm.RAAPIReferenceWrapper;
import lv.lumii.tda.kernel.mm.TDAKernelMetamodelFactory;
import lv.lumii.tda.raapi.RAAPI;

public class MountRepositoryCommand
extends Command
implements RAAPIReferenceWrapper {
    @Override
    public RAAPI getRAAPI() {
        return this.factory.raapi;
    }

    @Override
    public long getRAAPIReference() {
        return this.rObject;
    }

    @Override
    public boolean delete() {
        if (this.rObject != 0L) {
            if (!this.takeReference) {
                System.err.println("Unable to delete the object " + this.rObject + " of type TDAKernel::MountRepositoryCommand since the RAAPI wrapper does not take care of this reference.");
                return false;
            }
            this.factory.wrappers.remove(this.rObject);
            boolean retVal = this.factory.raapi.deleteObject(this.rObject);
            if (retVal) {
                this.rObject = 0L;
            } else {
                this.factory.wrappers.put(this.rObject, this);
            }
            return retVal;
        }
        return false;
    }

    @Override
    public void finalize() {
        if (this.rObject != 0L) {
            if (this.takeReference) {
                this.factory.wrappers.remove(this.rObject);
                this.factory.raapi.freeReference(this.rObject);
            }
            this.rObject = 0L;
        }
    }

    MountRepositoryCommand(TDAKernelMetamodelFactory _factory) {
        super(_factory, _factory.raapi.createObject(_factory.MOUNTREPOSITORYCOMMAND), true);
        this.factory = _factory;
        this.rObject = this.rObject;
        this.takeReference = true;
        this.factory.wrappers.put(this.rObject, this);
    }

    public MountRepositoryCommand(TDAKernelMetamodelFactory _factory, long _rObject, boolean _takeReference) {
        super(_factory, _rObject, _takeReference);
    }

    public static Iterable<? extends MountRepositoryCommand> allObjects() {
        return MountRepositoryCommand.allObjects(TDAKernelMetamodelFactory.eINSTANCE);
    }

    public static Iterable<? extends MountRepositoryCommand> allObjects(TDAKernelMetamodelFactory factory) {
        ArrayList<MountRepositoryCommand> retVal = new ArrayList<MountRepositoryCommand>();
        long it = factory.raapi.getIteratorForAllClassObjects(factory.MOUNTREPOSITORYCOMMAND);
        if (it == 0L) {
            return retVal;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        while (r != 0L) {
            MountRepositoryCommand o = (MountRepositoryCommand)factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (o == null) {
                o = (MountRepositoryCommand)factory.findOrCreateRAAPIReferenceWrapper(MountRepositoryCommand.class, r, true);
            }
            if (o != null) {
                retVal.add(o);
            }
            r = factory.raapi.resolveIteratorNext(it);
        }
        factory.raapi.freeIterator(it);
        return retVal;
    }

    public static boolean deleteAllObjects() {
        return MountRepositoryCommand.deleteAllObjects(TDAKernelMetamodelFactory.eINSTANCE);
    }

    public static boolean deleteAllObjects(TDAKernelMetamodelFactory factory) {
        for (MountRepositoryCommand mountRepositoryCommand : MountRepositoryCommand.allObjects(factory)) {
            mountRepositoryCommand.delete();
        }
        return MountRepositoryCommand.firstObject(factory) == null;
    }

    public static MountRepositoryCommand firstObject() {
        return MountRepositoryCommand.firstObject(TDAKernelMetamodelFactory.eINSTANCE);
    }

    public static MountRepositoryCommand firstObject(TDAKernelMetamodelFactory factory) {
        long it = factory.raapi.getIteratorForAllClassObjects(factory.MOUNTREPOSITORYCOMMAND);
        if (it == 0L) {
            return null;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        factory.raapi.freeIterator(it);
        if (r == 0L) {
            return null;
        }
        MountRepositoryCommand retVal = (MountRepositoryCommand)factory.findOrCreateRAAPIReferenceWrapper(r, true);
        if (retVal == null) {
            retVal = (MountRepositoryCommand)factory.findOrCreateRAAPIReferenceWrapper(MountRepositoryCommand.class, r, true);
        }
        return retVal;
    }

    public String getUri() {
        return this.factory.raapi.getAttributeValue(this.rObject, this.factory.MOUNTREPOSITORYCOMMAND_URI);
    }

    public boolean setUri(String value) {
        if (value == null) {
            return this.factory.raapi.deleteAttributeValue(this.rObject, this.factory.MOUNTREPOSITORYCOMMAND_URI);
        }
        return this.factory.raapi.setAttributeValue(this.rObject, this.factory.MOUNTREPOSITORYCOMMAND_URI, value.toString());
    }

    public String getMountPoint() {
        return this.factory.raapi.getAttributeValue(this.rObject, this.factory.MOUNTREPOSITORYCOMMAND_MOUNTPOINT);
    }

    public boolean setMountPoint(String value) {
        if (value == null) {
            return this.factory.raapi.deleteAttributeValue(this.rObject, this.factory.MOUNTREPOSITORYCOMMAND_MOUNTPOINT);
        }
        return this.factory.raapi.setAttributeValue(this.rObject, this.factory.MOUNTREPOSITORYCOMMAND_MOUNTPOINT, value.toString());
    }
}

