/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.kernel.mm;

import java.util.ArrayList;
import lv.lumii.tda.kernel.mm.ProxyReference;
import lv.lumii.tda.kernel.mm.RAAPIReferenceWrapper;
import lv.lumii.tda.kernel.mm.TDAKernelMetamodelFactory;
import lv.lumii.tda.raapi.RAAPI;

public class InterDirectedLink
implements RAAPIReferenceWrapper {
    protected TDAKernelMetamodelFactory factory;
    protected long rObject = 0L;
    protected boolean takeReference;

    @Override
    public RAAPI getRAAPI() {
        return this.factory.raapi;
    }

    @Override
    public long getRAAPIReference() {
        return this.rObject;
    }

    @Override
    public boolean delete() {
        if (this.rObject != 0L) {
            if (!this.takeReference) {
                System.err.println("Unable to delete the object " + this.rObject + " of type TDAKernel::InterDirectedLink since the RAAPI wrapper does not take care of this reference.");
                return false;
            }
            this.factory.wrappers.remove(this.rObject);
            boolean retVal = this.factory.raapi.deleteObject(this.rObject);
            if (retVal) {
                this.rObject = 0L;
            } else {
                this.factory.wrappers.put(this.rObject, this);
            }
            return retVal;
        }
        return false;
    }

    public void finalize() {
        if (this.rObject != 0L) {
            if (this.takeReference) {
                this.factory.wrappers.remove(this.rObject);
                this.factory.raapi.freeReference(this.rObject);
            }
            this.rObject = 0L;
        }
    }

    InterDirectedLink(TDAKernelMetamodelFactory _factory) {
        this.factory = _factory;
        this.rObject = this.factory.raapi.createObject(this.factory.INTERDIRECTEDLINK);
        this.takeReference = true;
        this.factory.wrappers.put(this.rObject, this);
    }

    public InterDirectedLink(TDAKernelMetamodelFactory _factory, long _rObject, boolean _takeReference) {
        this.factory = _factory;
        this.rObject = _rObject;
        this.takeReference = _takeReference;
        if (this.takeReference) {
            this.factory.wrappers.put(this.rObject, this);
        }
    }

    public static Iterable<? extends InterDirectedLink> allObjects() {
        return InterDirectedLink.allObjects(TDAKernelMetamodelFactory.eINSTANCE);
    }

    public static Iterable<? extends InterDirectedLink> allObjects(TDAKernelMetamodelFactory factory) {
        ArrayList<InterDirectedLink> retVal = new ArrayList<InterDirectedLink>();
        long it = factory.raapi.getIteratorForAllClassObjects(factory.INTERDIRECTEDLINK);
        if (it == 0L) {
            return retVal;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        while (r != 0L) {
            InterDirectedLink o = (InterDirectedLink)factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (o == null) {
                o = (InterDirectedLink)factory.findOrCreateRAAPIReferenceWrapper(InterDirectedLink.class, r, true);
            }
            if (o != null) {
                retVal.add(o);
            }
            r = factory.raapi.resolveIteratorNext(it);
        }
        factory.raapi.freeIterator(it);
        return retVal;
    }

    public static boolean deleteAllObjects() {
        return InterDirectedLink.deleteAllObjects(TDAKernelMetamodelFactory.eINSTANCE);
    }

    public static boolean deleteAllObjects(TDAKernelMetamodelFactory factory) {
        for (InterDirectedLink interDirectedLink : InterDirectedLink.allObjects(factory)) {
            interDirectedLink.delete();
        }
        return InterDirectedLink.firstObject(factory) == null;
    }

    public static InterDirectedLink firstObject() {
        return InterDirectedLink.firstObject(TDAKernelMetamodelFactory.eINSTANCE);
    }

    public static InterDirectedLink firstObject(TDAKernelMetamodelFactory factory) {
        long it = factory.raapi.getIteratorForAllClassObjects(factory.INTERDIRECTEDLINK);
        if (it == 0L) {
            return null;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        factory.raapi.freeIterator(it);
        if (r == 0L) {
            return null;
        }
        InterDirectedLink retVal = (InterDirectedLink)factory.findOrCreateRAAPIReferenceWrapper(r, true);
        if (retVal == null) {
            retVal = (InterDirectedLink)factory.findOrCreateRAAPIReferenceWrapper(InterDirectedLink.class, r, true);
        }
        return retVal;
    }

    public ProxyReference getSourceObject() {
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.INTERDIRECTEDLINK_SOURCEOBJECT);
        if (it == 0L) {
            return null;
        }
        long r = this.factory.raapi.resolveIteratorFirst(it);
        this.factory.raapi.freeIterator(it);
        if (r != 0L) {
            ProxyReference retVal = (ProxyReference)this.factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (retVal == null) {
                retVal = (ProxyReference)this.factory.findOrCreateRAAPIReferenceWrapper(ProxyReference.class, r, true);
            }
            return retVal;
        }
        return null;
    }

    public boolean setSourceObject(ProxyReference value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.INTERDIRECTEDLINK_SOURCEOBJECT);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.INTERDIRECTEDLINK_SOURCEOBJECT)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.INTERDIRECTEDLINK_SOURCEOBJECT)) {
            ok = false;
        }
        return ok;
    }

    public ProxyReference getTargetObject() {
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.INTERDIRECTEDLINK_TARGETOBJECT);
        if (it == 0L) {
            return null;
        }
        long r = this.factory.raapi.resolveIteratorFirst(it);
        this.factory.raapi.freeIterator(it);
        if (r != 0L) {
            ProxyReference retVal = (ProxyReference)this.factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (retVal == null) {
                retVal = (ProxyReference)this.factory.findOrCreateRAAPIReferenceWrapper(ProxyReference.class, r, true);
            }
            return retVal;
        }
        return null;
    }

    public boolean setTargetObject(ProxyReference value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.INTERDIRECTEDLINK_TARGETOBJECT);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.INTERDIRECTEDLINK_TARGETOBJECT)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.INTERDIRECTEDLINK_TARGETOBJECT)) {
            ok = false;
        }
        return ok;
    }

    public InterDirectedLink getInverse() {
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.INTERDIRECTEDLINK_INVERSE);
        if (it == 0L) {
            return null;
        }
        long r = this.factory.raapi.resolveIteratorFirst(it);
        this.factory.raapi.freeIterator(it);
        if (r != 0L) {
            InterDirectedLink retVal = (InterDirectedLink)this.factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (retVal == null) {
                retVal = (InterDirectedLink)this.factory.findOrCreateRAAPIReferenceWrapper(InterDirectedLink.class, r, true);
            }
            return retVal;
        }
        return null;
    }

    public boolean setInverse(InterDirectedLink value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.INTERDIRECTEDLINK_INVERSE);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.INTERDIRECTEDLINK_INVERSE)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.INTERDIRECTEDLINK_INVERSE)) {
            ok = false;
        }
        return ok;
    }

    public InterDirectedLink getInterDirectedLink() {
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.INTERDIRECTEDLINK_INTERDIRECTEDLINK);
        if (it == 0L) {
            return null;
        }
        long r = this.factory.raapi.resolveIteratorFirst(it);
        this.factory.raapi.freeIterator(it);
        if (r != 0L) {
            InterDirectedLink retVal = (InterDirectedLink)this.factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (retVal == null) {
                retVal = (InterDirectedLink)this.factory.findOrCreateRAAPIReferenceWrapper(InterDirectedLink.class, r, true);
            }
            return retVal;
        }
        return null;
    }

    public boolean setInterDirectedLink(InterDirectedLink value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.INTERDIRECTEDLINK_INTERDIRECTEDLINK);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.INTERDIRECTEDLINK_INTERDIRECTEDLINK)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.INTERDIRECTEDLINK_INTERDIRECTEDLINK)) {
            ok = false;
        }
        return ok;
    }

    public ProxyReference getAssociation() {
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.INTERDIRECTEDLINK_ASSOCIATION);
        if (it == 0L) {
            return null;
        }
        long r = this.factory.raapi.resolveIteratorFirst(it);
        this.factory.raapi.freeIterator(it);
        if (r != 0L) {
            ProxyReference retVal = (ProxyReference)this.factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (retVal == null) {
                retVal = (ProxyReference)this.factory.findOrCreateRAAPIReferenceWrapper(ProxyReference.class, r, true);
            }
            return retVal;
        }
        return null;
    }

    public boolean setAssociation(ProxyReference value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.INTERDIRECTEDLINK_ASSOCIATION);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.INTERDIRECTEDLINK_ASSOCIATION)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.INTERDIRECTEDLINK_ASSOCIATION)) {
            ok = false;
        }
        return ok;
    }

    public ProxyReference getPreviousTargetObject() {
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.INTERDIRECTEDLINK_PREVIOUSTARGETOBJECT);
        if (it == 0L) {
            return null;
        }
        long r = this.factory.raapi.resolveIteratorFirst(it);
        this.factory.raapi.freeIterator(it);
        if (r != 0L) {
            ProxyReference retVal = (ProxyReference)this.factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (retVal == null) {
                retVal = (ProxyReference)this.factory.findOrCreateRAAPIReferenceWrapper(ProxyReference.class, r, true);
            }
            return retVal;
        }
        return null;
    }

    public boolean setPreviousTargetObject(ProxyReference value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.INTERDIRECTEDLINK_PREVIOUSTARGETOBJECT);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.INTERDIRECTEDLINK_PREVIOUSTARGETOBJECT)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.INTERDIRECTEDLINK_PREVIOUSTARGETOBJECT)) {
            ok = false;
        }
        return ok;
    }
}

