/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.kernel.mm;

import java.util.ArrayList;
import lv.lumii.tda.kernel.mm.RAAPIReferenceWrapper;
import lv.lumii.tda.kernel.mm.Submitter;
import lv.lumii.tda.kernel.mm.TDAKernelMetamodelFactory;
import lv.lumii.tda.raapi.RAAPI;

public class Event
implements RAAPIReferenceWrapper {
    protected TDAKernelMetamodelFactory factory;
    protected long rObject = 0L;
    protected boolean takeReference;

    @Override
    public RAAPI getRAAPI() {
        return this.factory.raapi;
    }

    @Override
    public long getRAAPIReference() {
        return this.rObject;
    }

    @Override
    public boolean delete() {
        if (this.rObject != 0L) {
            if (!this.takeReference) {
                System.err.println("Unable to delete the object " + this.rObject + " of type TDAKernel::Event since the RAAPI wrapper does not take care of this reference.");
                return false;
            }
            this.factory.wrappers.remove(this.rObject);
            boolean retVal = this.factory.raapi.deleteObject(this.rObject);
            if (retVal) {
                this.rObject = 0L;
            } else {
                this.factory.wrappers.put(this.rObject, this);
            }
            return retVal;
        }
        return false;
    }

    public void finalize() {
        if (this.rObject != 0L) {
            if (this.takeReference) {
                this.factory.wrappers.remove(this.rObject);
                this.factory.raapi.freeReference(this.rObject);
            }
            this.rObject = 0L;
        }
    }

    public boolean submit() {
        long SUBMITTER_ROLE = this.factory.raapi.findAssociationEnd(this.factory.EVENT, "submitter");
        boolean retVal = this.factory.raapi.createLink(this.rObject, Submitter.firstObject((TDAKernelMetamodelFactory)this.factory).rObject, SUBMITTER_ROLE);
        this.factory.raapi.freeReference(SUBMITTER_ROLE);
        return retVal;
    }

    Event(TDAKernelMetamodelFactory _factory) {
        this.factory = _factory;
        this.rObject = this.factory.raapi.createObject(this.factory.EVENT);
        this.takeReference = true;
        this.factory.wrappers.put(this.rObject, this);
    }

    public Event(TDAKernelMetamodelFactory _factory, long _rObject, boolean _takeReference) {
        this.factory = _factory;
        this.rObject = _rObject;
        this.takeReference = _takeReference;
        if (this.takeReference) {
            this.factory.wrappers.put(this.rObject, this);
        }
    }

    public static Iterable<? extends Event> allObjects() {
        return Event.allObjects(TDAKernelMetamodelFactory.eINSTANCE);
    }

    public static Iterable<? extends Event> allObjects(TDAKernelMetamodelFactory factory) {
        ArrayList<Event> retVal = new ArrayList<Event>();
        long it = factory.raapi.getIteratorForAllClassObjects(factory.EVENT);
        if (it == 0L) {
            return retVal;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        while (r != 0L) {
            Event o = (Event)factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (o == null) {
                o = (Event)factory.findOrCreateRAAPIReferenceWrapper(Event.class, r, true);
            }
            if (o != null) {
                retVal.add(o);
            }
            r = factory.raapi.resolveIteratorNext(it);
        }
        factory.raapi.freeIterator(it);
        return retVal;
    }

    public static boolean deleteAllObjects() {
        return Event.deleteAllObjects(TDAKernelMetamodelFactory.eINSTANCE);
    }

    public static boolean deleteAllObjects(TDAKernelMetamodelFactory factory) {
        for (Event event : Event.allObjects(factory)) {
            event.delete();
        }
        return Event.firstObject(factory) == null;
    }

    public static Event firstObject() {
        return Event.firstObject(TDAKernelMetamodelFactory.eINSTANCE);
    }

    public static Event firstObject(TDAKernelMetamodelFactory factory) {
        long it = factory.raapi.getIteratorForAllClassObjects(factory.EVENT);
        if (it == 0L) {
            return null;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        factory.raapi.freeIterator(it);
        if (r == 0L) {
            return null;
        }
        Event retVal = (Event)factory.findOrCreateRAAPIReferenceWrapper(r, true);
        if (retVal == null) {
            retVal = (Event)factory.findOrCreateRAAPIReferenceWrapper(Event.class, r, true);
        }
        return retVal;
    }

    public Submitter getSubmitter() {
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.EVENT_SUBMITTER);
        if (it == 0L) {
            return null;
        }
        long r = this.factory.raapi.resolveIteratorFirst(it);
        this.factory.raapi.freeIterator(it);
        if (r != 0L) {
            Submitter retVal = (Submitter)this.factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (retVal == null) {
                retVal = (Submitter)this.factory.findOrCreateRAAPIReferenceWrapper(Submitter.class, r, true);
            }
            return retVal;
        }
        return null;
    }

    public boolean setSubmitter(Submitter value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.EVENT_SUBMITTER);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.EVENT_SUBMITTER)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.EVENT_SUBMITTER)) {
            ok = false;
        }
        return ok;
    }

    public String getInfo() {
        return this.factory.raapi.getAttributeValue(this.rObject, this.factory.EVENT_INFO);
    }

    public boolean setInfo(String value) {
        if (value == null) {
            return this.factory.raapi.deleteAttributeValue(this.rObject, this.factory.EVENT_INFO);
        }
        return this.factory.raapi.setAttributeValue(this.rObject, this.factory.EVENT_INFO, value.toString());
    }
}

