/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.kernel;

import lv.lumii.tda.kernel.DelegatorToRepositoryBase;
import lv.lumii.tda.kernel.IEventsCommandsHelper;
import lv.lumii.tda.kernel.IEventsCommandsHook;
import lv.lumii.tda.kernel.TDAKernel;
import lv.lumii.tda.kernel.mm.Submitter;
import lv.lumii.tda.kernel.mm.TDAKernelMetamodelFactory;
import lv.lumii.tda.raapi.IRepository;
import lv.lumii.tda.raapi.RAAPI_Synchronizable;
import lv.lumii.tda.raapi.RAAPI_Synchronizer;
import lv.lumii.tda.raapi.RAAPI_WR;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDAKernelDelegate
extends DelegatorToRepositoryBase
implements RAAPI_WR,
RAAPI_Synchronizable {
    private static Logger logger = LoggerFactory.getLogger(TDAKernelDelegate.class);
    private String engineBeingLoaded = null;
    private TDAKernelMetamodelFactory KMM = null;
    private long rSubmitterObject = 0L;
    private TDAKernel tdaKernel;
    private IEventsCommandsHook hook;

    public void setEngineBeingLoaded(String name) {
        this.engineBeingLoaded = name;
    }

    public void setKMM(TDAKernelMetamodelFactory kmm) {
        this.KMM = kmm;
        this.rSubmitterObject = kmm == null ? 0L : Submitter.firstObject(this.KMM).getRAAPIReference();
    }

    public TDAKernelDelegate(IEventsCommandsHook _hook, IRepository d, TDAKernel _kernel) {
        super.setDelegate(d);
        this.hook = _hook;
        this.tdaKernel = _kernel;
    }

    public void setEventsCommandsHook(IEventsCommandsHook _hook) {
        this.hook = _hook;
    }

    @Override
    public long findClass(String name) {
        if ("Command".equals(name)) {
            name = "TDAKernel::Command";
        } else if ("Event".equals(name)) {
            name = "TDAKernel::Event";
        }
        return super.findClass(name);
    }

    @Override
    public boolean createGeneralization(long rSubClass, long rSuperClass) {
        if (this.engineBeingLoaded == null) {
            return this.getDelegate().createGeneralization(rSubClass, rSuperClass);
        }
        boolean wasCommand = this.isDerivedClass(rSubClass, this.KMM.COMMAND);
        boolean wasEvent = this.isDerivedClass(rSubClass, this.KMM.EVENT);
        boolean retVal = super.createGeneralization(rSubClass, rSuperClass);
        if (retVal && (!wasCommand && this.isDerivedClass(rSubClass, this.KMM.COMMAND) || !wasEvent && this.isDerivedClass(rSubClass, this.KMM.EVENT))) {
            IEventsCommandsHelper.associateCommandOrEventWithEngine(this, rSubClass, this.engineBeingLoaded);
        }
        return retVal;
    }

    public boolean creatingSubmitLink(long rSourceObject, long rTargetObject, long rAssociationEnd) {
        return this.rSubmitterObject != 0L && (rSourceObject == this.rSubmitterObject || rTargetObject == this.rSubmitterObject);
    }

    public boolean isSubmitter(long r) {
        return this.rSubmitterObject != 0L && r == this.rSubmitterObject;
    }

    public boolean isEvent(long r) {
        return this.isKindOf(r, this.KMM.EVENT);
    }

    public boolean isCommand(long r) {
        return this.isKindOf(r, this.KMM.COMMAND);
    }

    @Override
    public boolean createLink(long rSourceObject, long rTargetObject, long rAssociationEnd) {
        if (this.rSubmitterObject != 0L && (rSourceObject == this.rSubmitterObject || rTargetObject == this.rSubmitterObject)) {
            if (rSourceObject == this.rSubmitterObject) {
                if (this.isKindOf(rTargetObject, this.KMM.EVENT)) {
                    return this.hook.handleEvent(this.tdaKernel, rTargetObject);
                }
                if (this.isKindOf(rTargetObject, this.KMM.COMMAND)) {
                    return this.hook.executeCommand(this.tdaKernel, rTargetObject);
                }
                return false;
            }
            if (this.isKindOf(rSourceObject, this.KMM.EVENT)) {
                return this.hook.handleEvent(this.tdaKernel, rSourceObject);
            }
            if (this.isKindOf(rSourceObject, this.KMM.COMMAND)) {
                return this.hook.executeCommand(this.tdaKernel, rSourceObject);
            }
            return false;
        }
        return this.getDelegate().createLink(rSourceObject, rTargetObject, rAssociationEnd);
    }

    @Override
    public boolean createOrderedLink(long rSourceObject, long rTargetObject, long rAssociationEnd, int position) {
        if (this.rSubmitterObject != 0L && (rSourceObject == this.rSubmitterObject || rTargetObject == this.rSubmitterObject)) {
            if (rSourceObject == this.rSubmitterObject) {
                if (this.isKindOf(rTargetObject, this.KMM.EVENT)) {
                    return this.hook.handleEvent(this.tdaKernel, rTargetObject);
                }
                if (this.isKindOf(rTargetObject, this.KMM.COMMAND)) {
                    return this.hook.executeCommand(this.tdaKernel, rTargetObject);
                }
                return false;
            }
            if (this.isKindOf(rSourceObject, this.KMM.EVENT)) {
                return this.hook.handleEvent(this.tdaKernel, rSourceObject);
            }
            if (this.isKindOf(rSourceObject, this.KMM.COMMAND)) {
                return this.hook.executeCommand(this.tdaKernel, rSourceObject);
            }
            return false;
        }
        return this.getDelegate().createOrderedLink(rSourceObject, rTargetObject, rAssociationEnd, position);
    }

    @Override
    public long getMaxReference() {
        return ((RAAPI_WR)((Object)this.getDelegate())).getMaxReference();
    }

    @Override
    public boolean createClass(String name, long r) {
        return ((RAAPI_WR)((Object)this.getDelegate())).createClass(name, r);
    }

    @Override
    public boolean createObject(long rClass, long r) {
        return ((RAAPI_WR)((Object)this.getDelegate())).createObject(rClass, r);
    }

    @Override
    public boolean createAttribute(long rClass, String name, long rType, long r) {
        return ((RAAPI_WR)((Object)this.getDelegate())).createAttribute(rClass, name, rType, r);
    }

    @Override
    public boolean createAssociation(long rSourceClass, long rTargetClass, String sourceRole, String targetRole, boolean isComposition, long r, long rInv) {
        return ((RAAPI_WR)((Object)this.getDelegate())).createAssociation(rSourceClass, rTargetClass, sourceRole, targetRole, isComposition, r, rInv);
    }

    @Override
    public boolean createDirectedAssociation(long rSourceClass, long rTargetClass, String targetRole, boolean isComposition, long r) {
        return ((RAAPI_WR)((Object)this.getDelegate())).createDirectedAssociation(rSourceClass, rTargetClass, targetRole, isComposition, r);
    }

    @Override
    public boolean createAdvancedAssociation(String name, boolean nAry, boolean associationClass, long r) {
        return ((RAAPI_WR)((Object)this.getDelegate())).createAdvancedAssociation(name, nAry, associationClass, r);
    }

    @Override
    public void syncAll(RAAPI_Synchronizer synchronizer, long bitsValues) {
        if (this.getDelegate() instanceof RAAPI_Synchronizable) {
            logger.debug("Sync via syncAll started");
            long time1 = System.currentTimeMillis();
            ((RAAPI_Synchronizable)((Object)this.delegate)).syncAll(synchronizer, bitsValues);
            if (logger.isDebugEnabled()) {
                long time2 = System.currentTimeMillis();
                logger.debug("Sync time: " + (time2 - time1));
            }
        } else {
            long rO;
            long itO;
            long rC;
            logger.debug("Sync via traverse all started");
            long time1 = System.currentTimeMillis();
            long itC = this.getDelegate().getIteratorForClasses();
            if (itC != 0L) {
                rC = this.getDelegate().resolveIteratorFirst(itC);
                while (rC != 0L) {
                    synchronizer.syncCreateClass(this.getDelegate().getClassName(rC), rC);
                    long itAt = this.getDelegate().getIteratorForDirectAttributes(rC);
                    if (itAt != 0L) {
                        long rAt = this.getDelegate().resolveIteratorFirst(itAt);
                        while (rAt != 0L) {
                            synchronizer.syncCreateAttribute(rC, this.getDelegate().getAttributeName(rAt), this.getDelegate().getAttributeType(rAt), rAt);
                            rAt = this.getDelegate().resolveIteratorNext(itAt);
                        }
                        this.getDelegate().freeIterator(itAt);
                    }
                    rC = this.getDelegate().resolveIteratorNext(itC);
                }
                this.getDelegate().freeIterator(itC);
            }
            if ((itC = this.getDelegate().getIteratorForClasses()) != 0L) {
                rC = this.getDelegate().resolveIteratorFirst(itC);
                while (rC != 0L) {
                    long itSuper;
                    long itAI;
                    long itAO = this.getDelegate().getIteratorForDirectOutgoingAssociationEnds(rC);
                    if (itAO != 0L) {
                        long rAO = this.getDelegate().resolveIteratorFirst(itAO);
                        while (rAO != 0L) {
                            long rInv = this.getDelegate().getInverseAssociationEnd(rAO);
                            if (rInv != 0L) {
                                if (rInv > rAO && !this.getDelegate().isComposition(rInv) || this.getDelegate().isComposition(rAO)) {
                                    synchronizer.syncCreateAssociation(this.getDelegate().getSourceClass(rAO), this.getDelegate().getTargetClass(rAO), this.getDelegate().getRoleName(rInv), this.getDelegate().getRoleName(rAO), this.getDelegate().isComposition(rAO), rAO, rInv);
                                }
                            } else {
                                synchronizer.syncCreateDirectedAssociation(this.getDelegate().getSourceClass(rAO), this.getDelegate().getTargetClass(rAO), this.getDelegate().getRoleName(rAO), this.getDelegate().isComposition(rAO), rAO);
                            }
                            rAO = this.getDelegate().resolveIteratorNext(itAO);
                        }
                        this.getDelegate().freeIterator(itAO);
                    }
                    if ((itAI = this.getDelegate().getIteratorForDirectIngoingAssociationEnds(rC)) != 0L) {
                        long rAI = this.getDelegate().resolveIteratorFirst(itAI);
                        while (rAI != 0L) {
                            long rInv = this.getDelegate().getInverseAssociationEnd(rAI);
                            if (rInv != 0L) {
                                if (rInv > rAI && !this.getDelegate().isComposition(rInv) || this.getDelegate().isComposition(rAI)) {
                                    synchronizer.syncCreateAssociation(this.getDelegate().getSourceClass(rAI), this.getDelegate().getTargetClass(rAI), this.getDelegate().getRoleName(rInv), this.getDelegate().getRoleName(rAI), this.getDelegate().isComposition(rAI), rAI, rInv);
                                }
                            } else {
                                synchronizer.syncCreateDirectedAssociation(this.getDelegate().getSourceClass(rAI), this.getDelegate().getTargetClass(rAI), this.getDelegate().getRoleName(rAI), this.getDelegate().isComposition(rAI), rAI);
                            }
                            rAI = this.getDelegate().resolveIteratorNext(itAI);
                        }
                        this.getDelegate().freeIterator(itAI);
                    }
                    if ((itSuper = this.getDelegate().getIteratorForDirectSuperClasses(rC)) != 0L) {
                        long rSuper = this.getDelegate().resolveIteratorFirst(itSuper);
                        while (rSuper != 0L) {
                            synchronizer.syncCreateGeneralization(rC, rSuper);
                            rSuper = this.getDelegate().resolveIteratorNext(itSuper);
                        }
                        this.getDelegate().freeIterator(itSuper);
                    }
                    rC = this.getDelegate().resolveIteratorNext(itC);
                }
                this.getDelegate().freeIterator(itC);
            }
            if ((itC = this.getDelegate().getIteratorForClasses()) != 0L) {
                rC = this.getDelegate().resolveIteratorFirst(itC);
                while (rC != 0L) {
                    itO = this.getDelegate().getIteratorForDirectClassObjects(rC);
                    if (itO != 0L) {
                        rO = this.getDelegate().resolveIteratorFirst(itO);
                        while (rO != 0L) {
                            synchronizer.syncCreateObject(rC, rO);
                            long itAt = this.getDelegate().getIteratorForAllAttributes(rC);
                            if (itAt != 0L) {
                                long rAt = this.getDelegate().resolveIteratorFirst(itAt);
                                while (rAt != 0L) {
                                    String value = this.getDelegate().getAttributeValue(rO, rAt);
                                    if (value != null) {
                                        synchronizer.syncSetAttributeValue(rO, rAt, value, null);
                                    }
                                    rAt = this.getDelegate().resolveIteratorNext(itAt);
                                }
                                this.getDelegate().freeIterator(itAt);
                            }
                            rO = this.getDelegate().resolveIteratorNext(itO);
                        }
                        this.getDelegate().freeIterator(itO);
                    }
                    rC = this.getDelegate().resolveIteratorNext(itC);
                }
                this.getDelegate().freeIterator(itC);
            }
            if ((itC = this.getDelegate().getIteratorForClasses()) != 0L) {
                rC = this.getDelegate().resolveIteratorFirst(itC);
                while (rC != 0L) {
                    itO = this.getDelegate().getIteratorForDirectClassObjects(rC);
                    if (itO != 0L) {
                        rO = this.getDelegate().resolveIteratorFirst(itO);
                        while (rO != 0L) {
                            long itAO = this.getDelegate().getIteratorForAllOutgoingAssociationEnds(rC);
                            if (itAO != 0L) {
                                long rAO = this.getDelegate().resolveIteratorFirst(itAO);
                                while (rAO != 0L) {
                                    long rInv = this.getDelegate().getInverseAssociationEnd(rAO);
                                    if (rInv == 0L || rAO < rInv) {
                                        long itLinked = this.getDelegate().getIteratorForLinkedObjects(rO, rAO);
                                        long rLinked = this.getDelegate().resolveIteratorFirst(itLinked);
                                        while (rLinked != 0L) {
                                            synchronizer.syncCreateLink(rO, rLinked, rAO);
                                            rLinked = this.getDelegate().resolveIteratorNext(itLinked);
                                        }
                                        this.getDelegate().freeIterator(itLinked);
                                    }
                                    rAO = this.getDelegate().resolveIteratorNext(itAO);
                                }
                                this.getDelegate().freeIterator(itAO);
                            }
                            rO = this.getDelegate().resolveIteratorNext(itO);
                        }
                        this.getDelegate().freeIterator(itO);
                    }
                    rC = this.getDelegate().resolveIteratorNext(itC);
                }
                this.getDelegate().freeIterator(itC);
            }
            logger.debug("Sync via traverse all ended");
            synchronizer.syncMaxReference(((RAAPI_WR)((Object)this.delegate)).getMaxReference(), ((RAAPI_WR)((Object)this.delegate)).getPredefinedBitsCount(), ((RAAPI_WR)((Object)this.delegate)).getPredefinedBitsValues());
            if (logger.isDebugEnabled()) {
                long time2 = System.currentTimeMillis();
                logger.debug("Sync time: " + (time2 - time1));
            }
        }
    }

    @Override
    public boolean setPredefinedBits(int bitsCount, long bitsValues) {
        return ((RAAPI_WR)((Object)this.getDelegate())).setPredefinedBits(bitsCount, bitsValues);
    }

    @Override
    public int getPredefinedBitsCount() {
        return ((RAAPI_WR)((Object)this.getDelegate())).getPredefinedBitsCount();
    }

    @Override
    public long getPredefinedBitsValues() {
        return ((RAAPI_WR)((Object)this.getDelegate())).getPredefinedBitsValues();
    }
}

