/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.kernel;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.UUID;
import lv.lumii.tda.ee.mm.EnvironmentEngine;
import lv.lumii.tda.ee.mm.EnvironmentEngineMetamodelFactory;
import lv.lumii.tda.ee.mm.Frame;
import lv.lumii.tda.ee.mm.Option;
import lv.lumii.tda.kernel.DelegatorToRepositoryBase;
import lv.lumii.tda.kernel.DelegatorToRepositoryWithOptionalOperations;
import lv.lumii.tda.kernel.DelegatorToRepositoryWithWritableReferences;
import lv.lumii.tda.kernel.DirectEventsCommandsHook;
import lv.lumii.tda.kernel.IEventsCommandsHelper;
import lv.lumii.tda.kernel.IEventsCommandsHook;
import lv.lumii.tda.kernel.TDACopier;
import lv.lumii.tda.kernel.TDAKernelDelegate;
import lv.lumii.tda.kernel.mm.Command;
import lv.lumii.tda.kernel.mm.Event;
import lv.lumii.tda.kernel.mm.Submitter;
import lv.lumii.tda.kernel.mm.TDAKernelMetamodelFactory;
import lv.lumii.tda.kernel.mmdparser.MetamodelInserter;
import lv.lumii.tda.raapi.IEngineAdapter;
import lv.lumii.tda.raapi.IRepository;
import lv.lumii.tda.raapi.ITransformationAdapter;
import lv.lumii.tda.raapi.RAAPIHelper;
import lv.lumii.tda.raapi.RAAPI_Synchronizable;
import lv.lumii.tda.raapi.RAAPI_Synchronizer;
import lv.lumii.tda.raapi.RAAPI_WR;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDAKernel
extends DelegatorToRepositoryBase
implements IEventsCommandsHelper {
    private static Logger logger = LoggerFactory.getLogger(TDAKernel.class);
    private UUID uuid;
    private static Map<UUID, TDAKernel> allTDAKernelsInThisJVM = new HashMap<UUID, TDAKernel>();
    private Owner owner = null;
    IEventsCommandsHook hook = new IEventsCommandsHook(){
        private IEventsCommandsHook directHook = new DirectEventsCommandsHook();

        @Override
        public boolean handleEvent(TDAKernel kernel, long rEvent) {
            int res = kernel.tryToHandleKernelEvent(rEvent);
            if (res != 0) {
                return res == 1;
            }
            return this.directHook.handleEvent(kernel, rEvent);
        }

        @Override
        public boolean executeCommand(TDAKernel kernel, long rCommand) {
            int res = kernel.tryToExecuteKernelCommand(rCommand);
            if (res != 0) {
                return res == 1;
            }
            return this.directHook.executeCommand(kernel, rCommand);
        }
    };
    private String mainTransformation = null;
    private boolean finalizeCalled = false;
    private HashMap<String, ITransformationAdapter> transformationType2adapter = new HashMap();
    private HashMap<String, IEngineAdapter> engineName2adapter = new HashMap();
    private List<IEngineAdapter> reverseOrderedEngineAdapters = new LinkedList<IEngineAdapter>();
    private Map<String, Object> cacheMap = new HashMap<String, Object>();
    private RAAPI_Synchronizer synchronizer = null;
    private Mode mode = Mode.CLOSED_MODE;
    public TDAKernelMetamodelFactory KMM = new TDAKernelMetamodelFactory();
    public EnvironmentEngineMetamodelFactory EEMM = new EnvironmentEngineMetamodelFactory();
    private TDAKernelDelegate delegate = null;

    @Override
    public long findClass(String name) {
        if ("Command".equals(name)) {
            name = "TDAKernel::Command";
        } else if ("Event".equals(name)) {
            name = "TDAKernel::Event";
        }
        return super.findClass(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TDAKernel() {
        Class<TDAKernel> clazz = TDAKernel.class;
        synchronized (TDAKernel.class) {
            do {
                this.uuid = UUID.randomUUID();
            } while (allTDAKernelsInThisJVM.containsKey(this.uuid));
            allTDAKernelsInThisJVM.put(this.uuid, this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void setOwner(Owner _owner) {
        this.owner = _owner;
    }

    public Owner getOwner() {
        return this.owner;
    }

    public void setMainTransformation(String name) {
        this.mainTransformation = name;
    }

    public String getUUID() {
        return this.uuid.toString();
    }

    public static synchronized TDAKernel findTDAKernelByUUID(String uuidString) {
        try {
            UUID uuid = UUID.fromString(uuidString);
            return allTDAKernelsInThisJVM.get(uuid);
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void finalize() {
        if (this.finalizeCalled) {
            return;
        }
        this.finalizeCalled = true;
        Class<TDAKernel> clazz = TDAKernel.class;
        synchronized (TDAKernel.class) {
            allTDAKernelsInThisJVM.remove(this.uuid);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static String getAdapterTypeFromURI(String locationWithAdapterType) {
        int i = locationWithAdapterType.indexOf(":");
        if (i == -1) {
            return null;
        }
        return locationWithAdapterType.substring(0, i).trim();
    }

    public static String getLocationFromURI(String locationWithAdapterType) {
        int i = locationWithAdapterType.indexOf(":");
        if (i == -1) {
            return null;
        }
        String location = locationWithAdapterType.substring(i + 1);
        if (location.startsWith("//")) {
            location = location.substring(2);
        }
        return location;
    }

    public static IRepository newRepositoryAdapter(String adapterType, TDAKernel callerKernel) {
        try {
            Class<?> c = Class.forName("lv.lumii.tda.adapters.repository." + adapterType + ".RepositoryAdapter");
            Method m = null;
            try {
                m = c.getMethod("create", new Class[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Method m1 = null;
            try {
                m1 = c.getMethod("create", TDAKernel.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (m == null && m1 == null) {
                IRepository r = (IRepository)c.getConstructor(new Class[0]).newInstance(new Object[0]);
                return new DelegatorToRepositoryWithOptionalOperations(r);
            }
            if (m1 != null) {
                return (IRepository)m1.invoke(c, callerKernel);
            }
            return (IRepository)m.invoke(c, new Object[0]);
        }
        catch (Throwable t) {
            logger.error("Could not initialize a repository adapter for `" + adapterType + "'.");
            return null;
        }
    }

    public static IRepository newRepositoryAdapter(String adapterType) {
        return TDAKernel.newRepositoryAdapter(adapterType, null);
    }

    public static ITransformationAdapter newTransformationAdapter(String adapterType) {
        try {
            Class<?> c = Class.forName("lv.lumii.tda.adapters.transformation." + adapterType + ".TransformationAdapter");
            Object o = c.getConstructor(new Class[0]).newInstance(new Object[0]);
            return (ITransformationAdapter)o;
        }
        catch (Throwable t) {
            logger.error("Could not initialize a transformation adapter for `" + adapterType + "'.");
            return null;
        }
    }

    public static IEngineAdapter newEngineAdapter(String adapterType) {
        try {
            Class<?> c = Class.forName("lv.lumii.tda.adapters.engine." + adapterType + ".EngineAdapter");
            return (IEngineAdapter)c.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            logger.error("Could not initialize a engine adapter for `" + adapterType + "'.");
            return null;
        }
    }

    private boolean tryToLoadEngine(String engineName, String adapterTypeName) {
        IEngineAdapter adapter = TDAKernel.newEngineAdapter(adapterTypeName);
        if (adapter == null) {
            return false;
        }
        this.engineName2adapter.put(engineName, adapter);
        this.reverseOrderedEngineAdapters.add(0, adapter);
        this.delegate.setEngineBeingLoaded(engineName);
        boolean retVal = adapter.load(engineName, this);
        this.delegate.setEngineBeingLoaded(null);
        if (!retVal) {
            this.engineName2adapter.remove(engineName);
            this.reverseOrderedEngineAdapters.remove(adapter);
        }
        return retVal;
    }

    @Override
    public IEngineAdapter getEngineAdapter(String engineName) {
        IEngineAdapter adapter = this.engineName2adapter.get(engineName);
        if (adapter != null) {
            return adapter;
        }
        String adapterTypeName = System.getProperty("adapterFor" + engineName);
        if (adapterTypeName != null) {
            this.tryToLoadEngine(engineName, adapterTypeName);
            IEngineAdapter retVal = this.engineName2adapter.get(engineName);
            if (retVal == null) {
                logger.error("Could not load engine " + engineName + " with the " + adapterTypeName + " adapter.");
            }
            return retVal;
        }
        if (this.tryToLoadEngine(engineName, "web")) {
            return this.engineName2adapter.get(engineName);
        }
        if (this.tryToLoadEngine(engineName, "staticjava")) {
            return this.engineName2adapter.get(engineName);
        }
        if (this.tryToLoadEngine(engineName, "dll")) {
            return this.engineName2adapter.get(engineName);
        }
        return null;
    }

    @Override
    public ITransformationAdapter getTransformationAdapter(String transformationType) {
        ITransformationAdapter adapter = this.transformationType2adapter.get(transformationType);
        if (adapter != null) {
            return adapter;
        }
        adapter = TDAKernel.newTransformationAdapter(transformationType);
        if (adapter == null) {
            return null;
        }
        if (adapter.load(this)) {
            this.transformationType2adapter.put(transformationType, adapter);
            return adapter;
        }
        return null;
    }

    private void cleanupAdapters() {
        for (IEngineAdapter iEngineAdapter : this.reverseOrderedEngineAdapters) {
            iEngineAdapter.unload();
        }
        for (ITransformationAdapter iTransformationAdapter : this.transformationType2adapter.values()) {
            iTransformationAdapter.unload();
        }
        this.transformationType2adapter.clear();
        this.engineName2adapter.clear();
        this.reverseOrderedEngineAdapters.clear();
    }

    public void storeCache(String id, Object cache) {
        if (this.mode == Mode.CLOSED_MODE) {
            return;
        }
        if (cache == null) {
            this.cacheMap.remove(id);
        } else {
            this.cacheMap.put(id, cache);
        }
    }

    public void clearCache(String id) {
        if (this.mode == Mode.CLOSED_MODE) {
            return;
        }
        this.cacheMap.remove(id);
    }

    public Object retrieveCache(String id) {
        if (this.mode == Mode.CLOSED_MODE) {
            return null;
        }
        return this.cacheMap.get(id);
    }

    @Override
    public IRepository getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean open(String locationWithAdapterType) {
        if (this.mode != Mode.CLOSED_MODE) {
            logger.error("Repository " + locationWithAdapterType + " is already open " + this.mode.toString());
            return false;
        }
        String adapterType = TDAKernel.getAdapterTypeFromURI(locationWithAdapterType);
        IRepository r2 = TDAKernel.newRepositoryAdapter(adapterType, this);
        if (r2 == null) {
            return false;
        }
        if (!(r2 instanceof RAAPI_WR)) {
            r2 = new DelegatorToRepositoryWithWritableReferences(r2);
        }
        this.delegate = new TDAKernelDelegate(this.hook, r2, this);
        String location = TDAKernel.getLocationFromURI(locationWithAdapterType);
        if (!this.delegate.open(location)) {
            this.delegate = null;
            return false;
        }
        this.mode = Mode.OPEN_REPOSITORY_MODE;
        return true;
    }

    @Override
    public boolean exists(String locationWithAdapterType) {
        String adapterType = TDAKernel.getAdapterTypeFromURI(locationWithAdapterType);
        IRepository d = TDAKernel.newRepositoryAdapter(adapterType, this);
        if (d == null) {
            return false;
        }
        String location = TDAKernel.getLocationFromURI(locationWithAdapterType);
        return d.exists(location);
    }

    public boolean upgradeToTDA(boolean bootstrap, String login, boolean light) {
        Submitter submitterObj;
        Iterator<? extends Submitter> it;
        if (this.mode != Mode.OPEN_REPOSITORY_MODE) {
            logger.error("A repository must be in OPEN_REPOSITORY_MODE");
            return false;
        }
        try {
            this.KMM.setRAAPI(this, "", true);
        }
        catch (TDAKernelMetamodelFactory.ElementReferenceException e) {
            logger.error("Could not load TDA Kernel Metamodel.\n" + e.toString());
            return false;
        }
        lv.lumii.tda.kernel.mm.TDAKernel kernelObj = lv.lumii.tda.kernel.mm.TDAKernel.firstObject(this.KMM);
        if (kernelObj == null) {
            kernelObj = this.KMM.createTDAKernel();
        }
        if ((it = Submitter.allObjects(this.KMM).iterator()).hasNext()) {
            submitterObj = it.next();
            while (it.hasNext()) {
                it.next().delete();
            }
        } else {
            submitterObj = this.KMM.createSubmitter();
        }
        this.delegate.setKMM(this.KMM);
        this.delegate.setEngineBeingLoaded("EnvironmentEngine");
        try {
            this.EEMM.setRAAPI(this, "", true);
        }
        catch (EnvironmentEngineMetamodelFactory.ElementReferenceException e) {
            logger.error("Could not load Environment Engine Metamodel.\n" + e.toString());
            this.delegate.setEngineBeingLoaded(null);
            this.KMM.unsetRAAPI();
            return false;
        }
        this.delegate.setEngineBeingLoaded(null);
        EnvironmentEngine eeObj = EnvironmentEngine.firstObject(this.EEMM);
        if (eeObj == null) {
            eeObj = this.EEMM.createEnvironmentEngine();
        }
        if (kernelObj == null || submitterObj == null || eeObj == null) {
            logger.error("Could not find/create the TDAKernel object, the Submitter object, and/or the Environment Engine object");
            this.KMM.unsetRAAPI();
            this.EEMM.unsetRAAPI();
            return false;
        }
        if (light) {
            this.mode = Mode.OPEN_TDA_MODE;
            return true;
        }
        eeObj.setLanguage(System.getProperty("user.language"));
        eeObj.setCountry(System.getProperty("user.country"));
        eeObj.setAnyUnsavedChanges(false);
        Option.deleteAllObjects(this.EEMM);
        Frame.deleteAllObjects(this.EEMM);
        Command.deleteAllObjects(this.KMM);
        Event.deleteAllObjects(this.KMM);
        this.mode = Mode.OPEN_TDA_MODE;
        return true;
    }

    public synchronized boolean setPredefinedBits(int predefinedBitsCount, long predefinedBitsValues) {
        if (!(this.delegate instanceof RAAPI_WR)) {
            logger.error("The underlying repository does not support writable references, which are essential for setPredefinedBits. Use a repository that implements RAAPI_WR!");
            return false;
        }
        if (!this.delegate.setPredefinedBits(predefinedBitsCount, predefinedBitsValues)) {
            logger.error("Could not set predefined " + predefinedBitsCount + " bits!");
            return false;
        }
        return true;
    }

    public synchronized RAAPI_WR attachSynchronizer(RAAPI_Synchronizer _synchronizer, boolean syncExistingContentNow, long predefinedSynchronizerBitsValues) {
        if (_synchronizer == null) {
            return null;
        }
        if (!(this.delegate instanceof RAAPI_WR)) {
            logger.error("The underlying repository does not support writable references, which are essential for synchronization. Use a repository that implements RAAPI_WR!");
            return null;
        }
        int bits = this.delegate.getPredefinedBitsCount();
        if (1L << bits < predefinedSynchronizerBitsValues) {
            logger.error("The number of predefined bits is not sufficient for the given predefined bits values. Call setPredefinedBits with appropriate predefined bits count!");
            return null;
        }
        RAAPI_Synchronizer synchronizer = _synchronizer;
        if (syncExistingContentNow && _synchronizer != null) {
            assert (this.delegate instanceof RAAPI_Synchronizable);
            this.delegate.syncAll(synchronizer, predefinedSynchronizerBitsValues);
        }
        this.synchronizer = _synchronizer;
        return this.delegate;
    }

    public synchronized RAAPI_WR sync(RAAPI_Synchronizer s, long predefinedSynchronizerBitsValues) {
        if (s == null) {
            return null;
        }
        if (!(this.delegate instanceof RAAPI_WR)) {
            logger.error("The underlying repository does not support writable references, which are essential for synchronization. Use a repository that implements RAAPI_WR!");
            return null;
        }
        int bits = this.delegate.getPredefinedBitsCount();
        if (1L << bits < predefinedSynchronizerBitsValues) {
            logger.error("The number of predefined bits is not sufficient for the given predefined bits values. Call setPredefinedBits with appropriate predefined bits count!");
            return null;
        }
        assert (this.delegate instanceof RAAPI_Synchronizable);
        this.delegate.syncAll(s, predefinedSynchronizerBitsValues);
        return this.delegate;
    }

    public synchronized RAAPI_Synchronizer getSynchronizer() {
        return this.synchronizer;
    }

    @Override
    public void close() {
        if (this.mode == Mode.CLOSED_MODE) {
            return;
        }
        if (this.mode == Mode.SAVING_MODE) {
            logger.error("Close during saving.");
        }
        if (this.mode == Mode.OPEN_TDA_MODE) {
            this.KMM.unsetRAAPI();
            this.delegate.setKMM(null);
        }
        if (this.synchronizer != null) {
            this.synchronizer.flush();
        }
        this.synchronizer = null;
        this.cleanupAdapters();
        this.getDelegate().close();
        this.cacheMap.clear();
        this.mode = Mode.CLOSED_MODE;
        System.gc();
    }

    @Override
    public boolean drop(String locationWithAdapterType) {
        String adapterType = TDAKernel.getAdapterTypeFromURI(locationWithAdapterType);
        IRepository r2 = TDAKernel.newRepositoryAdapter(adapterType, this);
        if (r2 == null) {
            return false;
        }
        String location = TDAKernel.getLocationFromURI(locationWithAdapterType);
        return r2.drop(location);
    }

    @Override
    public long createClass(String name) {
        long retVal = this.getDelegate().createClass(name);
        if (retVal != 0L && this.synchronizer != null) {
            this.synchronizer.syncCreateClass(name, retVal);
        }
        return retVal;
    }

    @Override
    public boolean deleteClass(long r) {
        boolean retVal = this.getDelegate().deleteClass(r);
        if (retVal && this.synchronizer != null) {
            this.synchronizer.syncDeleteClass(r);
        }
        return retVal;
    }

    @Override
    public boolean createGeneralization(long rSubClass, long rSuperClass) {
        boolean retVal = this.getDelegate().createGeneralization(rSubClass, rSuperClass);
        if (retVal && this.synchronizer != null) {
            this.synchronizer.syncCreateGeneralization(rSubClass, rSuperClass);
        }
        return retVal;
    }

    @Override
    public boolean deleteGeneralization(long rSubClass, long rSuperClass) {
        boolean retVal = this.getDelegate().deleteGeneralization(rSubClass, rSuperClass);
        if (retVal && this.synchronizer != null) {
            this.synchronizer.syncDeleteGeneralization(rSubClass, rSuperClass);
        }
        return retVal;
    }

    @Override
    public long createObject(long rClass) {
        long retVal = this.getDelegate().createObject(rClass);
        if (retVal != 0L && this.synchronizer != null) {
            this.synchronizer.syncCreateObject(rClass, retVal);
        }
        return retVal;
    }

    @Override
    public boolean deleteObject(long r) {
        boolean retVal = this.getDelegate().deleteObject(r);
        if (retVal && this.synchronizer != null) {
            this.synchronizer.syncDeleteObject(r);
        }
        return retVal;
    }

    @Override
    public boolean includeObjectInClass(long rObject, long rClass) {
        boolean retVal = this.getDelegate().includeObjectInClass(rObject, rClass);
        if (retVal && this.synchronizer != null) {
            this.synchronizer.syncIncludeObjectInClass(rObject, rClass);
        }
        return retVal;
    }

    @Override
    public boolean excludeObjectFromClass(long rObject, long rClass) {
        boolean retVal = this.getDelegate().excludeObjectFromClass(rObject, rClass);
        if (retVal && this.synchronizer != null) {
            this.synchronizer.syncExcludeObjectFromClass(rObject, rClass);
        }
        return retVal;
    }

    @Override
    public boolean moveObject(long rObject, long rToClass) {
        boolean retVal = this.getDelegate().moveObject(rObject, rToClass);
        if (retVal && this.synchronizer != null) {
            this.synchronizer.syncMoveObject(rObject, rToClass);
        }
        return retVal;
    }

    @Override
    public long createAttribute(long rClass, String name, long type) {
        long retVal = this.getDelegate().createAttribute(rClass, name, type);
        if (retVal != 0L && this.synchronizer != null) {
            this.synchronizer.syncCreateAttribute(rClass, name, type, retVal);
        }
        return retVal;
    }

    @Override
    public boolean deleteAttribute(long r) {
        boolean retVal = this.getDelegate().deleteAttribute(r);
        if (retVal && this.synchronizer != null) {
            this.synchronizer.syncDeleteAttribute(r);
        }
        return retVal;
    }

    @Override
    public boolean setAttributeValue(long rObject, long rAttribute, String value) {
        String oldValue = this.getDelegate().getAttributeValue(rObject, rAttribute);
        boolean retVal = this.getDelegate().setAttributeValue(rObject, rAttribute, value);
        if (retVal && this.synchronizer != null) {
            this.synchronizer.syncSetAttributeValue(rObject, rAttribute, value, oldValue);
        }
        return retVal;
    }

    @Override
    public boolean deleteAttributeValue(long rObject, long rAttribute) {
        boolean retVal = this.getDelegate().deleteAttributeValue(rObject, rAttribute);
        if (retVal && this.synchronizer != null) {
            this.synchronizer.syncDeleteAttributeValue(rObject, rAttribute);
        }
        return retVal;
    }

    @Override
    public long createAssociation(long rSourceClass, long rTargetClass, String sourceRoleName, String targetRoleName, boolean isComposition) {
        long retVal = this.getDelegate().createAssociation(rSourceClass, rTargetClass, sourceRoleName, targetRoleName, isComposition);
        if (retVal != 0L && this.synchronizer != null) {
            this.synchronizer.syncCreateAssociation(rSourceClass, rTargetClass, sourceRoleName, targetRoleName, isComposition, retVal, this.getDelegate().getInverseAssociationEnd(retVal));
        }
        return retVal;
    }

    @Override
    public long createDirectedAssociation(long rSourceClass, long rTargetClass, String targetRoleName, boolean isComposition) {
        long retVal = this.getDelegate().createDirectedAssociation(rSourceClass, rTargetClass, targetRoleName, isComposition);
        if (retVal != 0L && this.synchronizer != null) {
            this.synchronizer.syncCreateDirectedAssociation(rSourceClass, rTargetClass, targetRoleName, isComposition, retVal);
        }
        return retVal;
    }

    @Override
    public long createAdvancedAssociation(String name, boolean nAry, boolean associationClass) {
        long retVal = this.getDelegate().createAdvancedAssociation(name, nAry, associationClass);
        if (retVal != 0L && this.synchronizer != null) {
            this.synchronizer.syncCreateAdvancedAssociation(name, nAry, associationClass, retVal);
        }
        return retVal;
    }

    @Override
    public boolean deleteAssociation(long r) {
        boolean retVal = this.getDelegate().deleteAssociation(r);
        if (retVal && this.synchronizer != null) {
            this.synchronizer.syncDeleteAssociation(r);
        }
        return retVal;
    }

    public boolean creatingSubmitLink(long rSourceObject, long rTargetObject, long rAssociationEnd) {
        return this.delegate.creatingSubmitLink(rSourceObject, rTargetObject, rAssociationEnd);
    }

    public boolean isSubmitter(long r) {
        return this.delegate.isSubmitter(r);
    }

    public boolean isEvent(long r) {
        return this.delegate.isEvent(r);
    }

    public boolean isCommand(long r) {
        return this.delegate.isCommand(r);
    }

    @Override
    public boolean createLink(long rSourceObject, long rTargetObject, long rAssociationEnd) {
        boolean retVal = this.getDelegate().createLink(rSourceObject, rTargetObject, rAssociationEnd);
        if (retVal && this.synchronizer != null && this.linkExists(rSourceObject, rTargetObject, rAssociationEnd)) {
            this.synchronizer.syncCreateLink(rSourceObject, rTargetObject, rAssociationEnd);
        }
        return retVal;
    }

    @Override
    public boolean createOrderedLink(long rSourceObject, long rTargetObject, long rAssociationEnd, int position) {
        boolean retVal = this.getDelegate().createOrderedLink(rSourceObject, rTargetObject, rAssociationEnd, position);
        if (retVal && this.synchronizer != null && this.linkExists(rSourceObject, rTargetObject, rAssociationEnd)) {
            this.synchronizer.syncCreateOrderedLink(rSourceObject, rTargetObject, rAssociationEnd, position);
        }
        return retVal;
    }

    @Override
    public boolean deleteLink(long rSourceObject, long rTargetObject, long rAssociationEnd) {
        boolean retVal = this.getDelegate().deleteLink(rSourceObject, rTargetObject, rAssociationEnd);
        if (retVal && this.synchronizer != null) {
            this.synchronizer.syncDeleteLink(rSourceObject, rTargetObject, rAssociationEnd);
        }
        return retVal;
    }

    @Override
    public boolean launchMainTransformation(long rArgument) {
        if (this.mainTransformation == null) {
            return false;
        }
        int i = this.mainTransformation.indexOf(58);
        ITransformationAdapter adapter = this.getTransformationAdapter(this.mainTransformation.substring(0, i));
        if (adapter == null) {
            return false;
        }
        return adapter.launchTransformation(this.mainTransformation.substring(i + 1), rArgument);
    }

    @Override
    public int tryToExecuteKernelCommand(long rCommand) {
        final TDAKernel raapi = this;
        String className = RAAPIHelper.getObjectClassName(raapi, rCommand);
        if (className == null) {
            logger.error("TDA Kernel was unable to try to execute command " + rCommand + " since class name is null");
            return -1;
        }
        if (className.equals("TDAKernel::AttachEngineCommand")) {
            boolean retVal;
            long rCls = RAAPIHelper.getObjectClass(raapi, rCommand);
            long rAttr = raapi.findAttribute(rCls, "name");
            if (rAttr == 0L) {
                raapi.freeReference(rCls);
                logger.error("Attribute 'name' not found in class TDAKernel::AttachEngineCommand.");
                return -1;
            }
            String engineName = raapi.getAttributeValue(rCommand, rAttr);
            raapi.freeReference(rCls);
            raapi.freeReference(rAttr);
            boolean bl = retVal = this.getEngineAdapter(engineName) != null;
            if (retVal) {
                long rKernelCls;
                long rKernelToEngineAssoc;
                long rKernel;
                long rEngineSuperCls;
                long rEngineCls = raapi.findClass(engineName);
                if (rEngineCls == 0L) {
                    rEngineCls = raapi.createClass(engineName);
                }
                if (!raapi.isDerivedClass(rEngineCls, rEngineSuperCls = raapi.findClass("TDAKernel::Engine"))) {
                    raapi.createGeneralization(rEngineCls, rEngineSuperCls);
                }
                raapi.freeReference(rEngineSuperCls);
                long rEngineObj = 0L;
                long it = raapi.getIteratorForAllClassObjects(rEngineCls);
                if (it != 0L) {
                    rEngineObj = raapi.resolveIteratorFirst(it);
                    raapi.freeIterator(it);
                }
                if (rEngineObj == 0L) {
                    rEngineObj = raapi.createObject(rEngineCls);
                }
                if (!raapi.linkExists(rKernel = RAAPIHelper.getSingletonObject(raapi, "TDAKernel::TDAKernel"), rEngineObj, rKernelToEngineAssoc = raapi.findAssociationEnd(rKernelCls = RAAPIHelper.getObjectClass(raapi, rKernel), "attachedEngine"))) {
                    raapi.createLink(rKernel, rEngineObj, rKernelToEngineAssoc);
                }
                raapi.freeReference(rKernel);
                raapi.freeReference(rKernelCls);
                raapi.freeReference(rEngineCls);
                raapi.freeReference(rEngineObj);
                raapi.freeReference(rKernelToEngineAssoc);
            }
            return retVal ? 1 : -1;
        }
        if (className.equals("TDAKernel::InsertMetamodelCommand")) {
            long rCls = RAAPIHelper.getObjectClass(raapi, rCommand);
            long rAttr = raapi.findAttribute(rCls, "url");
            if (rAttr == 0L) {
                raapi.freeReference(rCls);
                logger.error("Attribute 'url' not found in class TDAKernel::InsertMetamodelCommand.");
                return -1;
            }
            String url_str = raapi.getAttributeValue(rCommand, rAttr);
            raapi.freeReference(rCls);
            raapi.freeReference(rAttr);
            try {
                StringBuffer errorMessages = new StringBuffer();
                boolean retVal = MetamodelInserter.insertMetamodel(new URL(url_str), raapi, errorMessages);
                if (!retVal || errorMessages.length() > 0) {
                    logger.error("Error inserting metamodel at " + url_str + "\n" + errorMessages.toString());
                }
                return retVal ? 1 : -1;
            }
            catch (MalformedURLException e) {
                logger.error("TDA Kernel: Error executing InsertMetamodelCommand. " + e.getMessage());
                return -1;
            }
        }
        long rLaunchTransformationCommand = raapi.findClass("TDAKernel::LaunchTransformationCommand");
        if (raapi.isKindOf(rCommand, rLaunchTransformationCommand)) {
            long _transformationArgument;
            raapi.freeReference(rLaunchTransformationCommand);
            long rCls = RAAPIHelper.getObjectClass(raapi, rCommand);
            long rAttr = raapi.findAttribute(rCls, "uri");
            if (rAttr == 0L) {
                raapi.freeReference(rCls);
                logger.error("Attribute 'uri' not found in class TDAKernel::LaunchTransformationCommand (or in its descendants).");
                return -1;
            }
            String transformationName = raapi.getAttributeValue(rCommand, rAttr);
            raapi.freeReference(rAttr);
            raapi.freeReference(rCls);
            String type = TDAKernel.getAdapterTypeFromURI(transformationName);
            String location = TDAKernel.getLocationFromURI(transformationName);
            if (type == null) {
                logger.error("The transformation name " + transformationName + " is not in TDA 2 format.");
                return -1;
            }
            String oldType = type;
            int i = type.indexOf(40);
            if (i >= 0 && type.endsWith(")")) {
                long parsed;
                try {
                    parsed = Long.parseLong(type.substring(i + 1, type.length() - 1));
                }
                catch (Throwable t) {
                    parsed = 0L;
                }
                _transformationArgument = parsed;
                type = type.substring(0, i);
            } else {
                _transformationArgument = rCommand;
            }
            long it = raapi.getIteratorForDirectObjectClasses(rCommand);
            long rrr = raapi.resolveIteratorFirst(it);
            raapi.freeIterator(it);
            it = raapi.getIteratorForDirectObjectClasses(_transformationArgument);
            rrr = raapi.resolveIteratorFirst(it);
            raapi.freeIterator(it);
            long transformationArgument = _transformationArgument;
            ITransformationAdapter adapter = this.getTransformationAdapter(type);
            if (adapter == null) {
                return -1;
            }
            return adapter.launchTransformation(location, transformationArgument) ? 1 : -1;
        }
        raapi.freeReference(rLaunchTransformationCommand);
        long rLaunchTransformationInBackgroundCommand = raapi.findClass("TDAKernel::LaunchTransformationInBackgroundCommand");
        if (raapi.isKindOf(rCommand, rLaunchTransformationInBackgroundCommand)) {
            long transformationArgument;
            raapi.freeReference(rLaunchTransformationInBackgroundCommand);
            long rCls = RAAPIHelper.getObjectClass(raapi, rCommand);
            long rAttr = raapi.findAttribute(rCls, "uri");
            if (rAttr == 0L) {
                raapi.freeReference(rCls);
                logger.error("Attribute 'uri' not found in class TDAKernel::LaunchTransformationCommand (or in its descendants).");
                return -1;
            }
            String transformationName = raapi.getAttributeValue(rCommand, rAttr);
            raapi.freeReference(rAttr);
            raapi.freeReference(rCls);
            String type = TDAKernel.getAdapterTypeFromURI(transformationName);
            final String location = TDAKernel.getLocationFromURI(transformationName);
            if (type == null) {
                logger.error("The transformation name " + transformationName + " is not in TDA 2 format.");
                return -1;
            }
            int i = type.indexOf(40);
            if (i >= 0 && type.endsWith(")")) {
                long parsed;
                try {
                    parsed = Long.parseLong(type.substring(i + 1, type.length() - 1));
                }
                catch (Throwable t) {
                    parsed = 0L;
                }
                transformationArgument = parsed;
                type = type.substring(0, i);
            } else {
                transformationArgument = rCommand;
            }
            final ITransformationAdapter adapter = this.getTransformationAdapter(type);
            if (adapter == null) {
                return -1;
            }
            new Thread(){

                @Override
                public void run() {
                    boolean result = adapter.launchTransformation(location, transformationArgument);
                    if (!result) {
                        logger.error("launchTransformation for the background transformation `" + location + "' returned false");
                    }
                    raapi.deleteObject(transformationArgument);
                }
            }.start();
            return 1;
        }
        raapi.freeReference(rLaunchTransformationInBackgroundCommand);
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int tryToHandleKernelEvent(long rEvent) {
        TDAKernel raapi = this;
        String className = RAAPIHelper.getObjectClassName(raapi, rEvent);
        if (className == null) {
            return -1;
        }
        try {
            if (!className.equals("ProjectOpenedEvent")) {
                return 0;
            }
            long rEECls = raapi.findClass("EnvironmentEngine");
            if (rEECls != 0L) {
                long rAttr = raapi.findAttribute(rEECls, "specificBinDirectory");
                long rAttr2 = raapi.findAttribute(rEECls, "lastToolVersion");
                if (rAttr2 == 0L) {
                    rAttr2 = raapi.createAttribute(rEECls, "lastToolVersion", raapi.findPrimitiveDataType("String"));
                }
                if (rAttr != 0L) {
                    long it = raapi.getIteratorForAllClassObjects(rEECls);
                    long rEEObj = 0L;
                    if (it != 0L) {
                        rEEObj = raapi.resolveIteratorFirst(it);
                        raapi.freeIterator(it);
                    }
                    if (rEEObj != 0L) {
                        String toolBin = raapi.getAttributeValue(rEEObj, rAttr);
                        File f = new File(String.valueOf(toolBin) + File.separator + "project_upgrade" + File.separator + "project_upgrade.properties");
                        if (toolBin != null && f.exists()) {
                            Properties p = new Properties();
                            try {
                                p.load(new BufferedInputStream(new FileInputStream(f)));
                                String lastToolVersion = raapi.getAttributeValue(rEEObj, rAttr2);
                                boolean allOK = true;
                                for (Object _key : p.keySet()) {
                                    String key = (String)_key;
                                    if (lastToolVersion == null || lastToolVersion.compareTo(key) < 0) {
                                        String transformationName = p.getProperty(key);
                                        logger.debug("Executing project_upgrade transformation " + key + " -> " + transformationName + "...");
                                        String type = TDAKernel.getAdapterTypeFromURI(transformationName);
                                        String location = TDAKernel.getLocationFromURI(transformationName);
                                        ITransformationAdapter adapter = this.getTransformationAdapter(type);
                                        if (adapter == null) continue;
                                        boolean ok = false;
                                        try {
                                            ok = adapter.launchTransformation(location, 0L);
                                        }
                                        catch (Throwable throwable) {
                                            // empty catch block
                                        }
                                        logger.debug("Execution of project_upgrade transformation " + transformationName + " returned " + ok);
                                        if (!ok) {
                                            allOK = false;
                                        }
                                        if (!allOK) continue;
                                        raapi.setAttributeValue(rEEObj, rAttr2, key);
                                        continue;
                                    }
                                    logger.debug("DO NOT executing already performed project_upgrade transformation " + key + ".");
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                    raapi.freeReference(rAttr);
                }
                raapi.freeReference(rEECls);
            }
            long rKernelObj = RAAPIHelper.getSingletonObject(raapi, "TDAKernel::TDAKernel");
            long rKernelCls = RAAPIHelper.getObjectClass(raapi, rKernelObj);
            long rAssoc = raapi.findAssociationEnd(rKernelCls, "attachedEngine");
            long it = raapi.getIteratorForLinkedObjects(rKernelObj, rAssoc);
            raapi.freeReference(rKernelObj);
            raapi.freeReference(rKernelCls);
            raapi.freeReference(rAssoc);
            long rEngineObj = raapi.resolveIteratorFirst(it);
            while (true) {
                if (rEngineObj == 0L) {
                    raapi.freeIterator(it);
                    return 0;
                }
                long rEngineCls = RAAPIHelper.getObjectClass(raapi, rEngineObj);
                String engineName = raapi.getClassName(rEngineCls);
                raapi.freeReference(rEngineCls);
                if (this.getEngineAdapter(engineName) == null) {
                    logger.error("Could not load attached engine " + engineName);
                    raapi.freeReference(rEngineObj);
                    raapi.freeIterator(it);
                    return 0;
                }
                raapi.freeReference(rEngineObj);
                rEngineObj = raapi.resolveIteratorNext(it);
            }
        }
        catch (Throwable t) {
            logger.error("Error trying to handle TDA Kernel event - " + t.getMessage());
            return 0;
        }
    }

    @Override
    public String getEngineForEventOrCommand(String eventOrCommandName) {
        if (eventOrCommandName == null) {
            return null;
        }
        TDAKernel raapi = this;
        long rKernelClass = raapi.findClass("TDAKernel::TDAKernel");
        if (rKernelClass == 0L) {
            return null;
        }
        long rAttr = raapi.findAttribute(rKernelClass, "engineFor" + eventOrCommandName);
        if (rAttr == 0L) {
            raapi.freeReference(rKernelClass);
            return null;
        }
        long it = raapi.getIteratorForAllClassObjects(rKernelClass);
        if (it == 0L) {
            raapi.freeReference(rAttr);
            raapi.freeReference(rKernelClass);
            return null;
        }
        raapi.freeReference(rKernelClass);
        long rKernel = raapi.resolveIteratorFirst(it);
        raapi.freeIterator(it);
        if (rKernel == 0L) {
            raapi.freeReference(rAttr);
            return null;
        }
        String engineName = raapi.getAttributeValue(rKernel, rAttr);
        raapi.freeReference(rAttr);
        raapi.freeReference(rKernel);
        return engineName;
    }

    @Override
    public String[] getEventHandlers(long rEvent) {
        String transformationName = null;
        TDAKernel raapi = this;
        String className = RAAPIHelper.getObjectClassName(raapi, rEvent);
        if (className == null) {
            return null;
        }
        String shortClassName = className.substring(className.lastIndexOf(58) + 1);
        long rEventClass = RAAPIHelper.getObjectClass(raapi, rEvent);
        if (rEventClass != 0L) {
            long it = raapi.getIteratorForAllOutgoingAssociationEnds(rEventClass);
            if (it != 0L) {
                long rAssoc = raapi.resolveIteratorFirst(it);
                while (rAssoc != 0L) {
                    long rCls2 = raapi.getTargetClass(rAssoc);
                    long rAttr2 = raapi.findAttribute(rCls2, "on" + shortClassName);
                    if (rCls2 != 0L && rAttr2 != 0L) {
                        long itLinked = raapi.getIteratorForLinkedObjects(rEvent, rAssoc);
                        long r2 = raapi.resolveIteratorFirst(itLinked);
                        while (r2 != 0L) {
                            String val = raapi.getAttributeValue(r2, rAttr2);
                            if (val != null) {
                                transformationName = val;
                            }
                            raapi.freeReference(r2);
                            if (transformationName != null) break;
                            r2 = raapi.resolveIteratorNext(itLinked);
                        }
                        raapi.freeIterator(itLinked);
                    }
                    raapi.freeReference(rCls2);
                    raapi.freeReference(rAttr2);
                    raapi.freeReference(rAssoc);
                    if (transformationName != null) break;
                    rAssoc = raapi.resolveIteratorNext(rAssoc);
                }
                raapi.freeIterator(it);
            }
            raapi.freeReference(rEventClass);
        }
        if (transformationName == null) {
            long rEngine;
            String engineName = this.getEngineForEventOrCommand(shortClassName);
            if (engineName == null) {
                if (shortClassName.equals("SaveStartedEvent") || shortClassName.equals("SaveFinishedEvent") || shortClassName.equals("SaveFailedEvent")) {
                    engineName = "TDAKernel::TDAKernel";
                } else {
                    return null;
                }
            }
            if ((rEngine = RAAPIHelper.getSingletonObject(raapi, engineName)) == 0L) {
                return null;
            }
            long rCls = RAAPIHelper.getObjectClass(raapi, rEngine);
            long rAttr = raapi.findAttribute(rCls, "on" + shortClassName);
            raapi.freeReference(rCls);
            if (rAttr == 0L) {
                raapi.freeReference(rEngine);
                return null;
            }
            transformationName = raapi.getAttributeValue(rEngine, rAttr);
            raapi.freeReference(rEngine);
            raapi.freeReference(rAttr);
        }
        if (transformationName != null) {
            ArrayList<String> arr = new ArrayList<String>();
            StringTokenizer tknz = new StringTokenizer(transformationName, ",;");
            while (tknz.hasMoreTokens()) {
                transformationName = tknz.nextToken();
                if (transformationName.startsWith("lua_engine#lua.")) {
                    transformationName = "lua:" + transformationName.substring(15);
                }
                arr.add(transformationName);
            }
            return arr.toArray(new String[0]);
        }
        return null;
    }

    @Override
    public long replicateEventOrCommand(long rEvent) {
        return TDACopier.copyObject(this, rEvent);
    }

    public void setEventsCommandsHook(IEventsCommandsHook _hook) {
        this.hook = _hook;
        this.delegate.setEventsCommandsHook(this.hook);
    }

    public IEventsCommandsHook getEventsCommandsHook() {
        return this.hook;
    }

    private static enum Mode {
        CLOSED_MODE,
        OPEN_REPOSITORY_MODE,
        OPEN_TDA_MODE,
        SAVING_MODE;

    }

    public static class Owner {
        public String login;
        public String project_id;
    }
}

