/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.kernel;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import lv.lumii.tda.raapi.RAAPI;

public class TDACopier {
    private static boolean DEBUG = false;
    private RAAPI sourceModel;
    private RAAPI targetModel;
    private Set<Long> sourceReferencesToFree = new HashSet<Long>();
    private Set<Long> targetReferencesToFree = new HashSet<Long>();
    private Map<Long, Long> sourceToTargetMap = new HashMap<Long, Long>();
    private List<String> errorMessages = null;
    private Map<Long, List<StructForWaitingAssociation>> waitingAssociations = new HashMap<Long, List<StructForWaitingAssociation>>();

    public static void readln() {
        if (!DEBUG) {
            return;
        }
        System.out.println("Press Enter...");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        try {
            br.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private TDACopier(RAAPI _sourceModel, RAAPI _targetModel, List<String> _errorMessages) {
        this.sourceModel = _sourceModel;
        this.targetModel = _targetModel;
        this.errorMessages = _errorMessages;
    }

    private void putErrorMessage(String errorMessage) {
        System.err.println(errorMessage);
        if (this.errorMessages != null) {
            this.errorMessages.add(errorMessage);
        }
    }

    private void freeReferences() {
        for (Long r : this.sourceReferencesToFree) {
            this.sourceModel.freeReference(r);
        }
        this.sourceReferencesToFree.clear();
        for (Long r : this.targetReferencesToFree) {
            this.targetModel.freeReference(r);
        }
        this.targetReferencesToFree.clear();
    }

    private boolean findOrCreateClass(long sClass) {
        assert (!this.sourceToTargetMap.containsKey(sClass));
        String name = this.sourceModel.getClassName(sClass);
        long tClass = this.targetModel.findClass(name);
        if (tClass == 0L) {
            tClass = this.targetModel.createClass(name);
        }
        if (tClass != 0L) {
            this.targetReferencesToFree.add(tClass);
            this.sourceToTargetMap.put(sClass, tClass);
            return true;
        }
        return false;
    }

    private boolean findOrCreateAssociation(long sFromCls, long sToCls, long sAssoc, long sInvAssoc) {
        boolean bidi;
        System.out.println(" create assoc " + sFromCls + "." + sAssoc);
        boolean bl = bidi = sInvAssoc != 0L;
        assert (!this.sourceToTargetMap.containsKey(sAssoc));
        assert (sInvAssoc == 0L || !this.sourceToTargetMap.containsKey(sInvAssoc));
        long tAssoc = this.targetModel.findAssociationEnd(this.sourceToTargetMap.get(sFromCls), this.sourceModel.getRoleName(sAssoc));
        long tInvAssoc = 0L;
        if (bidi) {
            tInvAssoc = this.targetModel.findAssociationEnd(this.sourceToTargetMap.get(sToCls), this.sourceModel.getRoleName(sInvAssoc));
        }
        if (bidi && tAssoc == 0L != (tInvAssoc == 0L)) {
            tAssoc = this.targetModel.findAssociationEnd(this.sourceToTargetMap.get(sFromCls), this.sourceModel.getRoleName(sAssoc));
            String role1 = String.valueOf(this.targetModel.getClassName(this.sourceToTargetMap.get(sFromCls))) + "." + this.sourceModel.getRoleName(sAssoc);
            String role2 = String.valueOf(this.targetModel.getClassName(this.sourceToTargetMap.get(sToCls))) + "." + this.sourceModel.getRoleName(sInvAssoc);
            if (tAssoc == 0L) {
                String tmp = role1;
                role1 = role2;
                role2 = tmp;
            }
            this.putErrorMessage("TDACopier could not find or create an association in the target repository: one target role (" + role1 + ") already exists, while the other (" + role2 + ") does not.");
            if (tAssoc != 0L) {
                this.targetModel.freeReference(tAssoc);
            }
            if (tInvAssoc != 0L) {
                this.targetModel.freeReference(tInvAssoc);
            }
            this.sourceModel.freeReference(sInvAssoc);
            return false;
        }
        if (tAssoc != 0L) {
            if (bidi) {
                long tgtInvAssoc2 = this.targetModel.getInverseAssociationEnd(tAssoc);
                if (tgtInvAssoc2 != 0L) {
                    this.targetModel.freeReference(tgtInvAssoc2);
                }
                if (tgtInvAssoc2 != tInvAssoc) {
                    this.targetModel.freeReference(tAssoc);
                    this.targetModel.freeReference(tInvAssoc);
                    return false;
                }
            }
        } else {
            if (bidi) {
                if (this.sourceModel.isComposition(sInvAssoc)) {
                    System.err.println("create inv compos " + this.sourceModel.getClassName(sToCls) + sToCls + "." + this.sourceModel.getRoleName(sAssoc) + "->" + this.sourceModel.getClassName(sFromCls) + sFromCls + "." + this.sourceModel.getRoleName(sInvAssoc));
                    tAssoc = this.targetModel.createAssociation(this.sourceToTargetMap.get(sToCls), this.sourceToTargetMap.get(sFromCls), this.sourceModel.getRoleName(sAssoc), this.sourceModel.getRoleName(sInvAssoc), true);
                    tAssoc = this.targetModel.getInverseAssociationEnd(tAssoc);
                } else {
                    System.err.println("create assoc " + this.sourceModel.getClassName(sFromCls) + sFromCls + "|" + this.sourceToTargetMap.get(sFromCls) + "." + this.sourceModel.getRoleName(sInvAssoc) + "->" + sToCls + "|" + this.sourceToTargetMap.get(sToCls) + "." + this.sourceModel.getRoleName(sAssoc));
                    tAssoc = this.targetModel.createAssociation(this.sourceToTargetMap.get(sFromCls), this.sourceToTargetMap.get(sToCls), this.sourceModel.getRoleName(sInvAssoc), this.sourceModel.getRoleName(sAssoc), this.sourceModel.isComposition(sAssoc));
                }
            } else {
                System.err.println("create directed assoc " + sFromCls + "->" + sToCls + "." + this.sourceModel.getRoleName(sAssoc));
                tAssoc = this.targetModel.createDirectedAssociation(this.sourceToTargetMap.get(sFromCls), this.sourceToTargetMap.get(sToCls), this.sourceModel.getRoleName(sAssoc), this.sourceModel.isComposition(sAssoc));
            }
            if (tAssoc == 0L) {
                if (bidi) {
                    this.sourceModel.freeReference(sInvAssoc);
                }
                return false;
            }
            if (bidi && (tInvAssoc = this.targetModel.getInverseAssociationEnd(tAssoc)) == 0L) {
                this.targetModel.freeReference(tAssoc);
                return false;
            }
        }
        assert (tAssoc != 0L);
        assert (!bidi || tInvAssoc != 0L);
        this.targetReferencesToFree.add(tAssoc);
        if (bidi) {
            this.targetReferencesToFree.add(tInvAssoc);
        }
        this.sourceToTargetMap.put(sAssoc, tAssoc);
        if (bidi) {
            this.sourceToTargetMap.put(sInvAssoc, tInvAssoc);
        }
        return true;
    }

    private boolean findOrCreateAttribute(long sCls, long sAttr) {
        long tAttr = this.targetModel.findAttribute(this.sourceToTargetMap.get(sCls), this.sourceModel.getAttributeName(sAttr));
        if (tAttr != 0L) {
            String name1 = this.sourceModel.getPrimitiveDataTypeName(this.sourceModel.getAttributeType(sAttr));
            String name2 = this.targetModel.getPrimitiveDataTypeName(this.targetModel.getAttributeType(tAttr));
            if (name1 == null) {
                this.putErrorMessage("Could not get the type name for attribute " + this.sourceModel.getAttributeName(sAttr) + " of class " + this.sourceModel.getClassName(sCls) + ".");
                this.targetModel.freeReference(tAttr);
                return false;
            }
            if (!name1.equals(name2)) {
                this.putErrorMessage("Target attribute " + this.sourceModel.getAttributeName(sAttr) + " of class " + this.sourceModel.getClassName(sCls) + " found, but it has the type " + name2 + " instead of " + name1 + ".");
                this.targetModel.freeReference(tAttr);
                return false;
            }
        } else {
            String typeName = null;
            long rSrcType = this.sourceModel.getAttributeType(sAttr);
            if (rSrcType != 0L) {
                typeName = this.sourceModel.getPrimitiveDataTypeName(rSrcType);
                this.sourceModel.freeReference(rSrcType);
            }
            System.err.println("create attr " + this.sourceModel.getClassName(sCls) + "." + this.sourceModel.getAttributeName(sAttr) + ":" + typeName);
            if (typeName != null) {
                long rTgtType = this.targetModel.findPrimitiveDataType(typeName);
                if (rTgtType != 0L) {
                    tAttr = this.targetModel.createAttribute(this.sourceToTargetMap.get(sCls), this.sourceModel.getAttributeName(sAttr), rTgtType);
                    this.targetModel.freeReference(rTgtType);
                } else {
                    tAttr = 0L;
                }
            } else {
                tAttr = 0L;
            }
            if (tAttr == 0L) {
                this.putErrorMessage("Could not create attribute " + this.sourceModel.getAttributeName(sAttr) + " of class " + this.sourceModel.getClassName(sCls) + " of type " + typeName + " (type=" + rSrcType + ").");
                return false;
            }
        }
        this.targetReferencesToFree.add(tAttr);
        return true;
    }

    private boolean checkAssociationsWaitingFor(long sToCls, boolean stopOnFirstError) {
        List<StructForWaitingAssociation> waiting = this.waitingAssociations.remove(sToCls);
        if (waiting == null) {
            return true;
        }
        boolean result = true;
        for (StructForWaitingAssociation w : waiting) {
            if (this.findOrCreateAssociation(w.sFromCls, sToCls, w.sAssoc, w.sInvAssoc)) continue;
            this.putErrorMessage("Could not find/create a delayed association " + this.sourceModel.getRoleName(w.sAssoc) + " from class " + this.sourceModel.getClassName(w.sFromCls) + ".");
            if (stopOnFirstError) {
                return false;
            }
            result = false;
        }
        return result;
    }

    private boolean classNameMatches(String className, Pattern[] toMatch, Pattern[] notToMatch) {
        boolean matches = false;
        if (className != null) {
            int i;
            boolean bl = matches = toMatch == null;
            if (toMatch != null) {
                i = 0;
                while (i < toMatch.length) {
                    if (toMatch[i].matcher(className).matches()) {
                        matches = true;
                        break;
                    }
                    ++i;
                }
            }
            if (matches && notToMatch != null) {
                i = 0;
                while (i < notToMatch.length) {
                    if (notToMatch[i].matcher(className).matches()) {
                        matches = false;
                        break;
                    }
                    ++i;
                }
            }
        }
        return matches;
    }

    private boolean internalMakeCopy(boolean stopOnFirstError, String[] regExToMatch, String[] regExNotToMatch, boolean copyInstances) {
        Pattern[] toMatch = null;
        if (regExToMatch != null) {
            toMatch = new Pattern[regExToMatch.length];
            int i = 0;
            while (i < regExToMatch.length) {
                toMatch[i] = Pattern.compile(regExToMatch[i]);
                ++i;
            }
        }
        Pattern[] notToMatch = null;
        if (regExNotToMatch != null) {
            notToMatch = new Pattern[regExNotToMatch.length];
            int i = 0;
            while (i < regExNotToMatch.length) {
                notToMatch[i] = Pattern.compile(regExNotToMatch[i]);
                ++i;
            }
        }
        LinkedList<StructForMetamodelElement> foundMetamodelElements = new LinkedList<StructForMetamodelElement>();
        long itClasses = this.sourceModel.getIteratorForClasses();
        if (itClasses == 0L) {
            return false;
        }
        long sClass = this.sourceModel.resolveIteratorFirst(itClasses);
        while (sClass != 0L) {
            String className = this.sourceModel.getClassName(sClass);
            if (!this.classNameMatches(className, toMatch, notToMatch)) {
                if (DEBUG) {
                    System.out.println("Class " + className + " does not conform to the given regular expressions to match/not to match.");
                }
                this.sourceModel.freeReference(sClass);
                sClass = this.sourceModel.resolveIteratorNext(itClasses);
                continue;
            }
            if (DEBUG) {
                System.out.println("Class " + className + " matches.");
            }
            this.sourceReferencesToFree.add(sClass);
            if (!this.findOrCreateClass(sClass)) {
                this.putErrorMessage("Could not find or create target class " + this.sourceModel.getClassName(sClass));
                if (stopOnFirstError) {
                    this.freeReferences();
                    this.sourceModel.freeIterator(itClasses);
                    return false;
                }
            } else {
                foundMetamodelElements.add(new StructForMetamodelElement(1, sClass));
            }
            sClass = this.sourceModel.resolveIteratorNext(itClasses);
        }
        this.sourceModel.freeIterator(itClasses);
        LinkedList<Long> currentElements = new LinkedList<Long>();
        for (StructForMetamodelElement elmnt : foundMetamodelElements) {
            currentElements.add(elmnt.reference);
        }
        while (!currentElements.isEmpty()) {
            LinkedList<Long> nextElements = new LinkedList<Long>();
            for (Long elmnt : currentElements) {
                long sAttrIt;
                long sAssocIt = this.sourceModel.getIteratorForDirectOutgoingAssociationEnds(elmnt);
                if (sAssocIt != 0L) {
                    long sAssoc = this.sourceModel.resolveIteratorFirst(sAssocIt);
                    while (sAssoc != 0L) {
                        if (this.sourceToTargetMap.containsKey(sAssoc)) {
                            this.sourceModel.freeReference(sAssoc);
                        } else {
                            boolean bidi;
                            long rTargetClass = this.sourceModel.getTargetClass(sAssoc);
                            String targetName = this.sourceModel.getClassName(rTargetClass);
                            this.sourceModel.freeReference(rTargetClass);
                            if (!this.classNameMatches(targetName, toMatch, notToMatch)) {
                                this.sourceModel.freeReference(sAssoc);
                                sAssoc = this.sourceModel.resolveIteratorNext(sAssocIt);
                                continue;
                            }
                            this.sourceReferencesToFree.add(sAssoc);
                            long sInvAssoc = this.sourceModel.getInverseAssociationEnd(sAssoc);
                            boolean bl = bidi = sInvAssoc != 0L;
                            if (bidi) {
                                this.sourceReferencesToFree.add(sInvAssoc);
                            }
                            if (bidi && this.sourceToTargetMap.containsKey(sInvAssoc)) {
                                this.putErrorMessage("Association " + this.sourceModel.getRoleName(sAssoc) + " from class " + this.sourceModel.getClassName(elmnt) + " has been processed only in one direction.");
                                if (stopOnFirstError) {
                                    this.freeReferences();
                                    this.sourceModel.freeIterator(sAssocIt);
                                    return false;
                                }
                                this.sourceReferencesToFree.remove(sAssoc);
                                this.sourceModel.freeReference(sAssoc);
                                this.sourceReferencesToFree.remove(sInvAssoc);
                                this.sourceModel.freeReference(sInvAssoc);
                                sAssoc = this.sourceModel.resolveIteratorNext(sAssocIt);
                                continue;
                            }
                            long sFromCls = this.sourceModel.getSourceClass(sAssoc);
                            if (sFromCls != 0L) {
                                this.sourceModel.freeReference(sFromCls);
                            }
                            if (sFromCls != elmnt) {
                                this.putErrorMessage("Association " + this.sourceModel.getRoleName(sAssoc) + " from class " + this.sourceModel.getClassName(elmnt) + " has been processed only in one direction." + elmnt + " " + sFromCls);
                                if (stopOnFirstError) {
                                    this.freeReferences();
                                    this.sourceModel.freeIterator(sAssocIt);
                                    return false;
                                }
                                this.sourceReferencesToFree.remove(sAssoc);
                                this.sourceModel.freeReference(sAssoc);
                                this.sourceReferencesToFree.remove(sInvAssoc);
                                this.sourceModel.freeReference(sInvAssoc);
                                sAssoc = this.sourceModel.resolveIteratorNext(sAssocIt);
                                continue;
                            }
                            long sToCls = this.sourceModel.getTargetClass(sAssoc);
                            if (sToCls == 0L) {
                                this.putErrorMessage("Could not get the target class of association " + this.sourceModel.getRoleName(sAssoc) + " from class " + this.sourceModel.getClassName(elmnt) + ".");
                                if (stopOnFirstError) {
                                    this.freeReferences();
                                    this.sourceModel.freeIterator(sAssocIt);
                                    return false;
                                }
                                this.sourceReferencesToFree.remove(sAssoc);
                                this.sourceModel.freeReference(sAssoc);
                                this.sourceReferencesToFree.remove(sInvAssoc);
                                this.sourceModel.freeReference(sInvAssoc);
                                sAssoc = this.sourceModel.resolveIteratorNext(sAssocIt);
                                continue;
                            }
                            assert (!this.sourceToTargetMap.containsKey(sAssoc));
                            assert (bidi || !this.sourceToTargetMap.containsKey(sInvAssoc));
                            assert (elmnt.equals(sFromCls));
                            assert (this.sourceToTargetMap.containsKey(sFromCls));
                            if (this.sourceToTargetMap.containsKey(sToCls)) {
                                this.sourceModel.freeReference(sToCls);
                                if (!this.findOrCreateAssociation(sFromCls, sToCls, sAssoc, sInvAssoc)) {
                                    try {
                                        throw new RuntimeException("aaa");
                                    }
                                    catch (Throwable t) {
                                        t.printStackTrace();
                                        this.putErrorMessage("Could not find/create association " + this.sourceModel.getRoleName(sAssoc) + " from class " + this.sourceModel.getClassName(elmnt) + ".");
                                        if (stopOnFirstError) {
                                            this.freeReferences();
                                            this.sourceModel.freeIterator(sAssocIt);
                                            return false;
                                        }
                                        this.sourceReferencesToFree.remove(sAssoc);
                                        this.sourceModel.freeReference(sAssoc);
                                        this.sourceReferencesToFree.remove(sInvAssoc);
                                        this.sourceModel.freeReference(sInvAssoc);
                                        sAssoc = this.sourceModel.resolveIteratorNext(sAssocIt);
                                        continue;
                                    }
                                }
                                foundMetamodelElements.add(new StructForMetamodelElement(2, sAssoc));
                                if (bidi) {
                                    foundMetamodelElements.add(new StructForMetamodelElement(2, sInvAssoc));
                                }
                                nextElements.add(sAssoc);
                                if (bidi) {
                                    nextElements.add(sInvAssoc);
                                }
                                if ((!this.checkAssociationsWaitingFor(sAssoc, stopOnFirstError) || bidi && !this.checkAssociationsWaitingFor(sInvAssoc, stopOnFirstError)) && stopOnFirstError) {
                                    this.freeReferences();
                                    this.sourceModel.freeIterator(sAssocIt);
                                    return false;
                                }
                            } else {
                                this.sourceReferencesToFree.add(sToCls);
                                if (!this.waitingAssociations.containsKey(sToCls)) {
                                    this.waitingAssociations.put(sToCls, new LinkedList());
                                }
                                this.waitingAssociations.get(sToCls).add(new StructForWaitingAssociation(sFromCls, sAssoc, sInvAssoc));
                            }
                        }
                        sAssoc = this.sourceModel.resolveIteratorNext(sAssocIt);
                    }
                    this.sourceModel.freeIterator(sAssocIt);
                }
                if ((sAttrIt = this.sourceModel.getIteratorForDirectAttributes(elmnt)) != 0L) {
                    long sAttr = this.sourceModel.resolveIteratorFirst(sAttrIt);
                    while (sAttr != 0L) {
                        if (DEBUG) {
                            System.out.println(" attr " + this.sourceModel.getClassName(elmnt) + "." + this.sourceModel.getAttributeName(sAttr));
                        }
                        if (!this.findOrCreateAttribute(elmnt, sAttr)) {
                            if (stopOnFirstError) {
                                this.freeReferences();
                                this.sourceModel.freeIterator(sAttrIt);
                                return false;
                            }
                            this.sourceReferencesToFree.remove(sAttr);
                            this.sourceModel.freeReference(sAttr);
                        } else {
                            foundMetamodelElements.add(new StructForMetamodelElement(3, sAttr));
                            nextElements.add(sAttr);
                            if (!this.checkAssociationsWaitingFor(sAttr, stopOnFirstError)) {
                                if (stopOnFirstError) {
                                    this.freeReferences();
                                    this.sourceModel.freeIterator(sAttrIt);
                                    return false;
                                }
                                this.sourceReferencesToFree.remove(sAttr);
                                this.sourceModel.freeReference(sAttr);
                            }
                        }
                        sAttr = this.sourceModel.resolveIteratorNext(sAttrIt);
                    }
                }
                this.sourceModel.freeIterator(sAttrIt);
            }
            currentElements = nextElements;
        }
        for (StructForMetamodelElement elmnt : foundMetamodelElements) {
            long sSuperClsIt = this.sourceModel.getIteratorForDirectSuperClasses(elmnt.reference);
            if (sSuperClsIt == 0L) continue;
            long sSuperCls = this.sourceModel.resolveIteratorFirst(sSuperClsIt);
            while (sSuperCls != 0L) {
                if (!this.classNameMatches(this.sourceModel.getClassName(sSuperCls), toMatch, notToMatch)) {
                    this.sourceModel.freeReference(sSuperCls);
                    sSuperCls = this.sourceModel.resolveIteratorNext(sSuperClsIt);
                    continue;
                }
                long tCls = this.sourceToTargetMap.get(elmnt.reference);
                Long tSuperCls = this.sourceToTargetMap.get(sSuperCls);
                if (tSuperCls == null) {
                    this.putErrorMessage("Target super class " + this.sourceModel.getClassName(sSuperCls) + " was not found.");
                    if (stopOnFirstError) {
                        this.freeReferences();
                        this.sourceModel.freeReference(sSuperCls);
                        this.sourceModel.freeIterator(sSuperClsIt);
                        return false;
                    }
                } else if (!this.targetModel.isDirectSubClass(tCls, tSuperCls) && !this.targetModel.createGeneralization(tCls, tSuperCls)) {
                    this.putErrorMessage("Could not create the generalization from " + this.targetModel.getClassName(tCls) + " to " + this.targetModel.getClassName(tSuperCls) + ".");
                    if (stopOnFirstError) {
                        this.freeReferences();
                        this.sourceModel.freeReference(sSuperCls);
                        this.sourceModel.freeIterator(sSuperClsIt);
                        return false;
                    }
                }
                this.sourceModel.freeReference(sSuperCls);
                sSuperCls = this.sourceModel.resolveIteratorNext(sSuperClsIt);
            }
            this.sourceModel.freeIterator(sSuperClsIt);
        }
        if (!copyInstances) {
            this.freeReferences();
            return true;
        }
        for (StructForMetamodelElement elmnt : foundMetamodelElements) {
            long sCls;
            if (elmnt.kind == 1) {
                long sCls2 = elmnt.reference;
                assert (this.sourceToTargetMap.containsKey(sCls2));
                long tCls = this.sourceToTargetMap.get(sCls2);
                long sObjIt = this.sourceModel.getIteratorForDirectClassObjects(sCls2);
                long sObj = this.sourceModel.resolveIteratorFirst(sObjIt);
                while (sObj != 0L) {
                    long tObj;
                    if (this.sourceToTargetMap.containsKey(sObj)) {
                        this.sourceModel.freeReference(sObj);
                        tObj = this.sourceToTargetMap.get(sObj);
                        if (!this.targetModel.isTypeOf(tObj, tCls) && !this.targetModel.includeObjectInClass(tObj, tCls)) {
                            this.putErrorMessage("Could not include object into class " + this.targetModel.getClassName(tCls));
                            if (stopOnFirstError) {
                                this.freeReferences();
                                this.sourceModel.freeIterator(sObjIt);
                                return false;
                            }
                        }
                    } else {
                        tObj = this.targetModel.createObject(tCls);
                        if (tObj == 0L) {
                            this.sourceModel.freeReference(sObj);
                            this.putErrorMessage("!!! " + this.sourceModel.getClassName(sCls2) + " " + sCls2 + "|" + tCls);
                            this.putErrorMessage("Could not create an object of class " + this.targetModel.getClassName(tCls));
                            if (stopOnFirstError) {
                                this.freeReferences();
                                this.sourceModel.freeIterator(sObjIt);
                                return false;
                            }
                        } else {
                            this.sourceToTargetMap.put(sObj, tObj);
                        }
                    }
                    sObj = this.sourceModel.resolveIteratorNext(sObjIt);
                }
                this.sourceModel.freeIterator(sObjIt);
            }
            if (elmnt.kind == 3) {
                long clsit = this.sourceModel.getIteratorForClasses();
                long sCls3 = this.sourceModel.resolveIteratorFirst(clsit);
                while (sCls3 != 0L) {
                    long attrref;
                    if (this.classNameMatches(this.sourceModel.getClassName(sCls3), toMatch, notToMatch) && (attrref = this.sourceModel.findAttribute(sCls3, this.sourceModel.getAttributeName(elmnt.reference))) != 0L) {
                        this.sourceModel.freeReference(attrref);
                        long sObjIt = this.sourceModel.getIteratorForAllClassObjects(sCls3);
                        if (sObjIt != 0L) {
                            long sObj = this.sourceModel.resolveIteratorFirst(sObjIt);
                            while (sObj != 0L) {
                                if (!this.sourceToTargetMap.containsKey(sObj)) {
                                    this.putErrorMessage("Could not find the corresponding target object for a source object of class " + this.sourceModel.getClassName(sCls3));
                                    if (stopOnFirstError) {
                                        this.freeReferences();
                                        this.sourceModel.freeReference(sObj);
                                        this.sourceModel.freeReference(sCls3);
                                        this.sourceModel.freeIterator(sObjIt);
                                        return false;
                                    }
                                } else {
                                    long tObj = this.sourceToTargetMap.get(sObj);
                                    long tAttr = this.targetModel.findAttribute(this.sourceToTargetMap.get(sCls3), this.sourceModel.getAttributeName(elmnt.reference));
                                    String value = this.sourceModel.getAttributeValue(sObj, elmnt.reference);
                                    if (this.sourceModel.getAttributeType(elmnt.reference) == this.sourceModel.findPrimitiveDataType("Integer")) {
                                        try {
                                            Integer.parseInt(value);
                                        }
                                        catch (Throwable t) {
                                            value = null;
                                        }
                                    }
                                    if (this.sourceModel.getAttributeType(elmnt.reference) == this.sourceModel.findPrimitiveDataType("Real")) {
                                        try {
                                            Double.parseDouble(value);
                                        }
                                        catch (Throwable t) {
                                            value = null;
                                        }
                                    }
                                    if (this.sourceModel.getAttributeType(elmnt.reference) == this.sourceModel.findPrimitiveDataType("Boolean") && !"true".equalsIgnoreCase(value) && !"false".equalsIgnoreCase(value)) {
                                        value = null;
                                    }
                                    if (value != null) {
                                        int z = value.indexOf(0);
                                        if (z >= 0) {
                                            value = value.substring(0, z);
                                        }
                                        if (!this.targetModel.setAttributeValue(tObj, tAttr, value)) {
                                            this.putErrorMessage("Could not set the attribute " + this.targetModel.getAttributeName(tAttr) + " value for an object of class " + this.sourceModel.getClassName(sCls3));
                                            if (stopOnFirstError) {
                                                this.freeReferences();
                                                this.sourceModel.freeReference(sObj);
                                                this.sourceModel.freeReference(sCls3);
                                                this.sourceModel.freeIterator(sObjIt);
                                                return false;
                                            }
                                        }
                                    }
                                }
                                this.sourceModel.freeReference(sObj);
                                sObj = this.sourceModel.resolveIteratorNext(sObjIt);
                            }
                            this.sourceModel.freeIterator(sObjIt);
                        }
                        this.sourceModel.freeReference(sCls3);
                    }
                    sCls3 = this.sourceModel.resolveIteratorNext(clsit);
                }
                this.sourceModel.freeIterator(clsit);
            }
            if (elmnt.kind != 2 || (sCls = this.sourceModel.getSourceClass(elmnt.reference)) == 0L) continue;
            long sObjIt = this.sourceModel.getIteratorForAllClassObjects(sCls);
            if (sObjIt != 0L) {
                long sObj = this.sourceModel.resolveIteratorFirst(sObjIt);
                while (sObj != 0L) {
                    if (!this.sourceToTargetMap.containsKey(sObj)) {
                        this.putErrorMessage("Could not find the corresponding target object for a source object of class " + this.sourceModel.getClassName(sCls));
                        if (stopOnFirstError) {
                            this.freeReferences();
                            this.sourceModel.freeReference(sObj);
                            this.sourceModel.freeReference(sCls);
                            this.sourceModel.freeIterator(sObjIt);
                            return false;
                        }
                    } else {
                        long tObj = this.sourceToTargetMap.get(sObj);
                        assert (this.sourceToTargetMap.containsKey(elmnt.reference));
                        long tAssoc = this.sourceToTargetMap.get(elmnt.reference);
                        long sLinkedObjIt = this.sourceModel.getIteratorForLinkedObjects(sObj, elmnt.reference);
                        if (sLinkedObjIt != 0L) {
                            long sLinkedObj = this.sourceModel.resolveIteratorFirst(sLinkedObjIt);
                            while (sLinkedObj != 0L) {
                                long tLinkedObj;
                                Long ttLinkedObj = this.sourceToTargetMap.get(sLinkedObj);
                                if (ttLinkedObj != null && !this.targetModel.linkExists(tObj, tLinkedObj = ttLinkedObj.longValue(), tAssoc) && !this.targetModel.createLink(tObj, tLinkedObj, tAssoc)) {
                                    this.targetModel.createLink(tObj, tLinkedObj, tAssoc);
                                    long rTargetClass = this.sourceModel.getTargetClass(elmnt.reference);
                                    this.putErrorMessage("Could not create a link corresponding to the " + this.targetModel.getRoleName(tAssoc) + " association from class " + this.sourceModel.getClassName(sCls) + "; target class in the source model = " + this.sourceModel.getClassName(rTargetClass));
                                    this.sourceModel.freeReference(rTargetClass);
                                    if (stopOnFirstError) {
                                        this.freeReferences();
                                        this.sourceModel.freeReference(sLinkedObj);
                                        this.sourceModel.freeIterator(sLinkedObjIt);
                                        this.sourceModel.freeReference(sObj);
                                        this.sourceModel.freeReference(sCls);
                                        this.sourceModel.freeIterator(sObjIt);
                                        return false;
                                    }
                                }
                                this.sourceModel.freeReference(sLinkedObj);
                                sLinkedObj = this.sourceModel.resolveIteratorNext(sLinkedObjIt);
                            }
                            this.sourceModel.freeIterator(sLinkedObjIt);
                        }
                    }
                    this.sourceModel.freeReference(sObj);
                    sObj = this.sourceModel.resolveIteratorNext(sObjIt);
                }
                this.sourceModel.freeIterator(sObjIt);
            }
            this.sourceModel.freeReference(sCls);
        }
        this.freeReferences();
        return true;
    }

    public static boolean makeCopy(RAAPI sourceModel, RAAPI targetModel, List<String> errorMessages, boolean stopOnFirstError) {
        TDACopier copier = new TDACopier(sourceModel, targetModel, errorMessages);
        return copier.internalMakeCopy(stopOnFirstError, null, null, true);
    }

    public static boolean makeCopy(RAAPI sourceModel, RAAPI targetModel, List<String> errorMessages, boolean stopOnFirstError, String[] regExToMatch, String[] regExNotToMatch, boolean copyInstances) {
        TDACopier copier = new TDACopier(sourceModel, targetModel, errorMessages);
        return copier.internalMakeCopy(stopOnFirstError, regExToMatch, regExNotToMatch, copyInstances);
    }

    public static boolean makeCopy(RAAPI sourceModel, RAAPI targetModel, boolean stopOnFirstError) {
        return TDACopier.makeCopy(sourceModel, targetModel, null, stopOnFirstError);
    }

    /*
     * Unable to fully structure code
     */
    public static long copyObject(RAAPI raapi, long rObject) {
        itCls = raapi.getIteratorForDirectObjectClasses(rObject);
        if (itCls == 0L) {
            return 0L;
        }
        rCls = raapi.resolveIteratorFirst(itCls);
        if (rCls == 0L) {
            raapi.freeIterator(itCls);
            return 0L;
        }
        retVal = raapi.createObject(rCls);
        if (retVal != 0L) ** GOTO lbl78
        raapi.freeReference(rCls);
        raapi.freeIterator(itCls);
        return 0L;
lbl-1000:
        // 1 sources

        {
            itA = raapi.getIteratorForAllAttributes(rCls);
            rA = raapi.resolveIteratorFirst(itA);
            while (rA != 0L) {
                val = raapi.getAttributeValue(rObject, rA);
                if (val != null) {
                    raapi.setAttributeValue(retVal, rA, val);
                }
                raapi.freeReference(rA);
                rA = raapi.resolveIteratorNext(itA);
            }
            raapi.freeIterator(itA);
            itA = raapi.getIteratorForAllOutgoingAssociationEnds(rCls);
            rA = raapi.resolveIteratorFirst(itA);
            while (rA != 0L) {
                isComposition = raapi.isComposition(rA);
                itLinked = raapi.getIteratorForLinkedObjects(rObject, rA);
                rLinked = raapi.resolveIteratorFirst(itLinked);
                while (rLinked != 0L) {
                    if (isComposition) {
                        rLinked2 = TDACopier.copyObject(raapi, rLinked);
                        raapi.createLink(retVal, rLinked2, rA);
                    } else {
                        raapi.createLink(retVal, rLinked, rA);
                    }
                    rLinked = raapi.resolveIteratorNext(itLinked);
                }
                raapi.freeIterator(itLinked);
                raapi.freeReference(rA);
                rA = raapi.resolveIteratorNext(itA);
            }
            raapi.freeIterator(itA);
            itA = raapi.getIteratorForAllIngoingAssociationEnds(rCls);
            rA = raapi.resolveIteratorFirst(itA);
            while (rA != 0L) {
                rAInv = raapi.getInverseAssociationEnd(rA);
                if (rAInv == 0L) {
                    isCompositionInv = raapi.isComposition(rAInv);
                    rSrcCls = raapi.getSourceClass(rA);
                    itSrcObj = raapi.getIteratorForAllClassObjects(rSrcCls);
                    rSrcObj = raapi.resolveIteratorFirst(itSrcObj);
                    while (rSrcObj != 0L) {
                        if (raapi.linkExists(rSrcObj, rObject, rA)) {
                            if (isCompositionInv) {
                                rSrcObj2 = TDACopier.copyObject(raapi, rSrcObj);
                                raapi.createLink(rSrcObj2, retVal, rA);
                            } else {
                                raapi.createLink(rSrcObj, retVal, rA);
                            }
                        }
                        rSrcObj = raapi.resolveIteratorNext(itSrcObj);
                    }
                    raapi.freeIterator(itSrcObj);
                    raapi.freeReference(rA);
                } else {
                    raapi.freeReference(rAInv);
                    raapi.freeReference(rA);
                }
                rA = raapi.resolveIteratorNext(itA);
            }
            raapi.freeIterator(itA);
            raapi.freeReference(rCls);
            rCls = raapi.resolveIteratorNext(itCls);
            if (rCls == 0L) continue;
            raapi.includeObjectInClass(retVal, rCls);
lbl78:
            // 3 sources

            ** while (rCls != 0L)
        }
lbl79:
        // 1 sources

        raapi.freeIterator(itCls);
        return retVal;
    }

    private final class StructForMetamodelElement {
        static final byte CLASS = 1;
        static final byte ASSOCIATION = 2;
        static final byte ATTRIBUTE = 3;
        byte kind;
        long reference;

        StructForMetamodelElement(byte _kind, long _reference) {
            this.kind = _kind;
            this.reference = _reference;
        }
    }

    private final class StructForWaitingAssociation {
        long sFromCls;
        long sAssoc;
        long sInvAssoc;

        StructForWaitingAssociation(long _sFromCls, long _sAssoc, long _sInvAssoc) {
            this.sFromCls = _sFromCls;
            this.sAssoc = _sAssoc;
            this.sInvAssoc = _sInvAssoc;
        }
    }
}

