/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.kernel;

import java.util.HashSet;
import lv.lumii.tda.kernel.DelegatorBase;
import lv.lumii.tda.raapi.RAAPI;

public class RAAPIWrapper
extends DelegatorBase {
    RAAPI delegate;
    private HashSet<Long> referencesToFree = new HashSet();
    private HashSet<Long> iteratorsToFree = new HashSet();

    public RAAPI getDelegate() {
        return this.delegate;
    }

    private long regRef(long r) {
        if (r == 0L) {
            return 0L;
        }
        if (this.referencesToFree.contains(r)) {
            this.delegate.freeReference(r);
        } else {
            this.referencesToFree.add(r);
        }
        return r;
    }

    private long regIt(long it) {
        if (it == 0L) {
            return 0L;
        }
        if (this.iteratorsToFree.contains(it)) {
            this.delegate.freeIterator(it);
        } else {
            this.iteratorsToFree.add(it);
        }
        return it;
    }

    public RAAPIWrapper(RAAPI _delegate) {
        this.delegate = _delegate;
    }

    @Override
    public long findClass(String arg0) {
        return this.regRef(this.getDelegate().findClass(arg0));
    }

    @Override
    public long createObject(long arg0) {
        return this.regRef(this.getDelegate().createObject(arg0));
    }

    @Override
    public long getAttributeType(long arg0) {
        return this.regRef(this.getDelegate().getAttributeType(arg0));
    }

    @Override
    public long getIteratorForClasses() {
        return this.regIt(this.getDelegate().getIteratorForClasses());
    }

    @Override
    public long findPrimitiveDataType(String arg0) {
        return this.regRef(this.getDelegate().findPrimitiveDataType(arg0));
    }

    @Override
    public long createAttribute(long arg0, String arg1, long arg2) {
        return this.regRef(this.getDelegate().createAttribute(arg0, arg1, arg2));
    }

    @Override
    public long findAttribute(long arg0, String arg1) {
        return this.regRef(this.getDelegate().findAttribute(arg0, arg1));
    }

    @Override
    public long getIteratorForAllAttributes(long arg0) {
        return this.regIt(this.getDelegate().getIteratorForAllAttributes(arg0));
    }

    @Override
    public long getAttributeDomain(long arg0) {
        return this.regRef(this.getDelegate().getAttributeDomain(arg0));
    }

    @Override
    public long createAssociation(long arg0, long arg1, String arg2, String arg3, boolean arg4) {
        return this.regRef(this.getDelegate().createAssociation(arg0, arg1, arg2, arg3, arg4));
    }

    @Override
    public long createDirectedAssociation(long arg0, long arg1, String arg2, boolean arg3) {
        return this.regRef(this.getDelegate().createDirectedAssociation(arg0, arg1, arg2, arg3));
    }

    @Override
    public long createAdvancedAssociation(String arg0, boolean arg1, boolean arg2) {
        return this.regRef(this.getDelegate().createAdvancedAssociation(arg0, arg1, arg2));
    }

    @Override
    public long findAssociationEnd(long arg0, String arg1) {
        return this.regRef(this.getDelegate().findAssociationEnd(arg0, arg1));
    }

    @Override
    public long getInverseAssociationEnd(long arg0) {
        return this.regRef(this.getDelegate().getInverseAssociationEnd(arg0));
    }

    @Override
    public long getSourceClass(long arg0) {
        return this.regRef(this.getDelegate().getSourceClass(arg0));
    }

    @Override
    public long getTargetClass(long arg0) {
        return this.regRef(this.getDelegate().getTargetClass(arg0));
    }

    @Override
    public long getIteratorForLinkedObjects(long arg0, long arg1) {
        return this.regIt(this.getDelegate().getIteratorForLinkedObjects(arg0, arg1));
    }

    @Override
    public long resolveIteratorFirst(long arg0) {
        return this.regRef(this.getDelegate().resolveIteratorFirst(arg0));
    }

    @Override
    public long resolveIteratorNext(long arg0) {
        return this.regRef(this.getDelegate().resolveIteratorNext(arg0));
    }

    @Override
    public long resolveIterator(long arg0, int arg1) {
        return this.regRef(this.getDelegate().resolveIterator(arg0, arg1));
    }

    @Override
    public void freeReference(long arg0) {
    }

    @Override
    public long deserializeReference(String arg0) {
        return this.regRef(this.getDelegate().deserializeReference(arg0));
    }

    @Override
    public long getLinguisticClassFor(long arg0) {
        return this.regRef(this.getDelegate().getLinguisticClassFor(arg0));
    }

    @Override
    public long getIteratorForDirectSubClasses(long arg0) {
        return this.regIt(this.getDelegate().getIteratorForDirectSubClasses(arg0));
    }

    @Override
    public long getIteratorForDirectClassObjects(long arg0) {
        return this.regIt(this.getDelegate().getIteratorForDirectClassObjects(arg0));
    }

    @Override
    public long getIteratorForDirectObjectClasses(long arg0) {
        return this.regIt(this.getDelegate().getIteratorForDirectObjectClasses(arg0));
    }

    @Override
    public long getIteratorForDirectSuperClasses(long arg0) {
        return this.regIt(this.getDelegate().getIteratorForDirectSuperClasses(arg0));
    }

    @Override
    public long getIteratorForAllClassObjects(long arg0) {
        return this.regIt(this.getDelegate().getIteratorForAllClassObjects(arg0));
    }

    @Override
    public long getIteratorForDirectAttributes(long arg0) {
        return this.regIt(this.getDelegate().getIteratorForDirectAttributes(arg0));
    }

    @Override
    public long getIteratorForObjectsByAttributeValue(long arg0, String arg1) {
        return this.regIt(this.getDelegate().getIteratorForObjectsByAttributeValue(arg0, arg1));
    }

    @Override
    public long getIteratorForAllOutgoingAssociationEnds(long arg0) {
        return this.regIt(this.getDelegate().getIteratorForAllOutgoingAssociationEnds(arg0));
    }

    @Override
    public long getIteratorForDirectOutgoingAssociationEnds(long arg0) {
        return this.regIt(this.getDelegate().getIteratorForDirectOutgoingAssociationEnds(arg0));
    }

    @Override
    public long getIteratorForAllIngoingAssociationEnds(long arg0) {
        return this.regIt(this.getDelegate().getIteratorForAllIngoingAssociationEnds(arg0));
    }

    @Override
    public long getIteratorForDirectIngoingAssociationEnds(long arg0) {
        return this.regIt(this.getDelegate().getIteratorForDirectIngoingAssociationEnds(arg0));
    }

    @Override
    public long getIteratorForLinguisticClasses() {
        return this.regIt(this.getDelegate().getIteratorForLinguisticClasses());
    }

    @Override
    public long getIteratorForDirectLinguisticInstances(long arg0) {
        return this.regIt(this.getDelegate().getIteratorForDirectLinguisticInstances(arg0));
    }

    @Override
    public long getIteratorForAllLinguisticInstances(long arg0) {
        return this.regIt(this.getDelegate().getIteratorForAllLinguisticInstances(arg0));
    }

    @Override
    public long createClass(String arg0) {
        return this.regRef(this.getDelegate().createClass(arg0));
    }

    @Override
    public boolean deleteAttribute(long arg0) {
        if (this.getDelegate().deleteAttribute(arg0)) {
            this.referencesToFree.remove(arg0);
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteAssociation(long arg0) {
        if (this.getDelegate().deleteAssociation(arg0)) {
            this.referencesToFree.remove(arg0);
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteObject(long arg0) {
        if (this.getDelegate().deleteObject(arg0)) {
            this.referencesToFree.remove(arg0);
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteClass(long arg0) {
        if (this.getDelegate().deleteClass(arg0)) {
            this.referencesToFree.remove(arg0);
            return true;
        }
        return false;
    }

    @Override
    public void freeIterator(long arg0) {
    }

    public void free() {
        for (Long r : this.referencesToFree) {
            this.delegate.freeReference(r);
        }
        this.referencesToFree.clear();
        for (Long it : this.iteratorsToFree) {
            this.delegate.freeIterator(it);
        }
        this.iteratorsToFree.clear();
    }

    public void finalize() {
        this.free();
    }

    public long getFirstClassObject(long rClass) {
        long it = this.getIteratorForAllClassObjects(rClass);
        if (it == 0L) {
            return 0L;
        }
        long r = this.resolveIteratorFirst(it);
        this.freeIterator(it);
        return r;
    }

    public long getFirstObjectByClassName(String name) {
        long rCls = this.findClass(name);
        if (rCls == 0L) {
            return 0L;
        }
        long retVal = this.getFirstClassObject(rCls);
        this.freeReference(rCls);
        return retVal;
    }

    public long getAssociationEndByNames(String className, String roleName) {
        long rCls = this.findClass(className);
        if (rCls == 0L) {
            return 0L;
        }
        long retVal = this.findAssociationEnd(rCls, roleName);
        this.freeReference(rCls);
        return retVal;
    }

    public long getFirstObjectClass(long rObject) {
        long it = this.getIteratorForDirectObjectClasses(rObject);
        if (it == 0L) {
            return 0L;
        }
        long r = this.resolveIteratorFirst(it);
        this.freeIterator(it);
        return r;
    }

    public long getFirstLinkedObject(long rObject, String roleName) {
        return this.resolveIteratorFirst(this.getIteratorForLinkedObjects(rObject, this.findAssociationEnd(this.getFirstObjectClass(rObject), roleName)));
    }

    public String getObjectClassName(long rObject) {
        long rCls = this.getFirstObjectClass(rObject);
        if (rCls == 0L) {
            return null;
        }
        String retVal = this.getClassName(rCls);
        this.freeReference(rObject);
        return retVal;
    }

    public String getAttributeValueByName(long rObject, String name) {
        return this.getAttributeValue(rObject, this.findAttribute(this.getFirstObjectClass(rObject), name));
    }

    public boolean createLinkByRoleName(long rSrc, long rTgt, String roleName) {
        return this.createLink(rSrc, rTgt, this.findAssociationEnd(this.getFirstObjectClass(rSrc), roleName));
    }

    public boolean isEventOrCommand(long r) {
        return this.isKindOf(r, this.findClass("TDAKernel::Event")) || this.isKindOf(r, this.findClass("TDAKernel::Command"));
    }

    public void submitAndForget(long rEventOrCommand) {
        if (this.isKindOf(rEventOrCommand, this.findClass("TDAKernel::AsyncCommand"))) {
            boolean b = this.createLinkByRoleName(rEventOrCommand, this.getFirstObjectByClassName("TDAKernel::Submitter"), "submitter");
            if (!b) {
                this.deleteObject(rEventOrCommand);
            } else {
                this.referencesToFree.remove(rEventOrCommand);
            }
        } else {
            this.createLinkByRoleName(rEventOrCommand, this.getFirstObjectByClassName("TDAKernel::Submitter"), "submitter");
            this.deleteObject(rEventOrCommand);
        }
    }
}

