/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.kernel;

import java.util.ArrayList;
import lv.lumii.tda.kernel.DelegatorBase;
import lv.lumii.tda.kernel.IReferenceMapper;
import lv.lumii.tda.raapi.IRepository;
import lv.lumii.tda.raapi.IRepositoryManagement;
import lv.lumii.tda.raapi.RAAPI;

public class RAAPITransaction
extends DelegatorBase<RAAPI>
implements IRepository {
    RAAPI delegate = null;
    IRepositoryManagement delegate2 = null;
    IReferenceMapper mapper;
    boolean undone = false;
    ArrayList<RepositoryAction> actions = new ArrayList();

    public RAAPITransaction(RAAPI _delegate, IRepositoryManagement _delegate2, IReferenceMapper _mapper) {
        this.delegate = _delegate;
        this.delegate2 = _delegate2;
        this.mapper = _mapper;
    }

    public RAAPITransaction(IRepository _delegate, IReferenceMapper _mapper) {
        this.delegate = _delegate;
        this.delegate2 = _delegate;
        this.mapper = _mapper;
    }

    public RAAPITransaction(RAAPI _delegate, IReferenceMapper _mapper) {
        this.delegate = _delegate;
        this.delegate2 = null;
        this.mapper = _mapper;
    }

    public IReferenceMapper getReferenceMapper() {
        return this.mapper;
    }

    @Override
    public RAAPI getDelegate() {
        return this.delegate;
    }

    @Override
    public long createClass(String name) {
        long rCls;
        if (this.undone) {
            this.clear();
        }
        if ((rCls = this.delegate.createClass(name)) == 0L) {
            return 0L;
        }
        long rsCls = this.mapper.getStableReference(rCls);
        this.actions.add(new ClassAction(this.delegate, this.mapper, rsCls, name, true));
        return rCls;
    }

    @Override
    public boolean deleteClass(long rClass) {
        String name;
        if (this.undone) {
            this.clear();
        }
        if ((name = this.delegate.getClassName(rClass)) == null) {
            return false;
        }
        long rsCls = this.mapper.getStableReference(rClass);
        if (!this.delegate.deleteClass(rClass)) {
            this.mapper.redirectStableReference(rsCls, 0L);
            this.mapper.releaseStableReference(rsCls);
            return false;
        }
        this.actions.add(new ClassAction(this.delegate, this.mapper, rsCls, name, false));
        return true;
    }

    @Override
    public boolean createGeneralization(long rSubClass, long rSuperClass) {
        if (this.undone) {
            this.clear();
        }
        if (!this.delegate.createGeneralization(rSubClass, rSuperClass)) {
            return false;
        }
        long rsSubCls = this.mapper.getStableReference(rSubClass);
        long rsSuperCls = this.mapper.getStableReference(rSuperClass);
        this.actions.add(new GeneralizationAction(this.delegate, this.mapper, rsSubCls, rsSuperCls, true));
        return true;
    }

    @Override
    public boolean deleteGeneralization(long rSubClass, long rSuperClass) {
        if (this.undone) {
            this.clear();
        }
        if (!this.delegate.deleteGeneralization(rSubClass, rSuperClass)) {
            return false;
        }
        long rsSubCls = this.mapper.getStableReference(rSubClass);
        long rsSuperCls = this.mapper.getStableReference(rSuperClass);
        this.actions.add(new GeneralizationAction(this.delegate, this.mapper, rsSubCls, rsSuperCls, false));
        return true;
    }

    @Override
    public long createObject(long rClass) {
        long rObject;
        if (this.undone) {
            this.clear();
        }
        if ((rObject = this.delegate.createObject(rClass)) == 0L) {
            return 0L;
        }
        long rsClass = this.mapper.getStableReference(rClass);
        long rsObject = this.mapper.getStableReference(rObject);
        this.actions.add(new ObjectAction(this.delegate, this.mapper, rsObject, rsClass, true));
        return rObject;
    }

    @Override
    public boolean deleteObject(long rObject) {
        long it;
        if (this.undone) {
            this.clear();
        }
        if ((it = this.delegate.getIteratorForDirectObjectClasses(rObject)) == 0L) {
            return false;
        }
        long rCls = this.delegate.resolveIteratorFirst(it);
        this.delegate.freeIterator(it);
        if (rCls == 0L) {
            return false;
        }
        long rsObject = this.mapper.getStableReference(rObject);
        if (!this.delegate.deleteObject(rObject)) {
            this.mapper.releaseStableReference(rsObject);
            this.delegate.freeReference(rCls);
            return false;
        }
        this.mapper.redirectStableReference(rsObject, 0L);
        long rsCls = this.mapper.getStableReference(rCls);
        this.delegate.freeReference(rCls);
        this.actions.add(new ObjectAction(this.delegate, this.mapper, rsObject, rsCls, false));
        return true;
    }

    @Override
    public boolean includeObjectInClass(long rObject, long rClass) {
        if (this.undone) {
            this.clear();
        }
        if (!this.delegate.includeObjectInClass(rObject, rClass)) {
            return false;
        }
        long rsObject = this.mapper.getStableReference(rObject);
        long rsClass = this.mapper.getStableReference(rClass);
        this.actions.add(new ObjectClassAction(this.delegate, this.mapper, rsObject, rsClass, true));
        return true;
    }

    @Override
    public boolean excludeObjectFromClass(long rObject, long rClass) {
        if (this.undone) {
            this.clear();
        }
        if (!this.delegate.excludeObjectFromClass(rObject, rClass)) {
            return false;
        }
        long rsObject = this.mapper.getStableReference(rObject);
        long rsClass = this.mapper.getStableReference(rClass);
        this.actions.add(new ObjectClassAction(this.delegate, this.mapper, rsObject, rsClass, false));
        return true;
    }

    @Override
    public boolean moveObject(long rObject, long rToClass) {
        long it;
        if (this.undone) {
            this.clear();
        }
        if ((it = this.delegate.getIteratorForDirectObjectClasses(rObject)) == 0L) {
            return false;
        }
        long rOldCls = this.delegate.resolveIteratorFirst(it);
        this.delegate.freeIterator(it);
        if (rOldCls == 0L) {
            return false;
        }
        if (!this.delegate.moveObject(rObject, rToClass)) {
            this.delegate.freeReference(rOldCls);
            return false;
        }
        long rsObject = this.mapper.getStableReference(rObject);
        long rsOldClass = this.mapper.getStableReference(rOldCls);
        this.delegate.freeReference(rOldCls);
        long rsNewClass = this.mapper.getStableReference(rToClass);
        this.actions.add(new MoveObjectAction(this.delegate, this.mapper, rsObject, rsOldClass, rsNewClass));
        return true;
    }

    @Override
    public long createAttribute(long rClass, String name, long rPrimitiveType) {
        long rAttr;
        if (this.undone) {
            this.clear();
        }
        if ((rAttr = this.delegate.createAttribute(rClass, name, rPrimitiveType)) == 0L) {
            return 0L;
        }
        long rsClass = this.mapper.getStableReference(rClass);
        long rsAttr = this.mapper.getStableReference(rAttr);
        long rsType = this.mapper.getStableReference(rPrimitiveType);
        this.actions.add(new AttributeAction(this.delegate, this.mapper, rsClass, rsAttr, name, rsType, true));
        return rAttr;
    }

    @Override
    public boolean deleteAttribute(long rAttribute) {
        if (this.undone) {
            this.clear();
        }
        if (rAttribute == 0L) {
            return false;
        }
        long rType = this.delegate.getAttributeType(rAttribute);
        if (rType == 0L) {
            return false;
        }
        long rClass = this.delegate.getAttributeDomain(rAttribute);
        if (rClass == 0L) {
            this.delegate.freeReference(rType);
            return false;
        }
        String name = this.delegate.getAttributeName(rAttribute);
        long rsClass = this.mapper.getStableReference(rClass);
        this.delegate.freeReference(rClass);
        long rsAttr = this.mapper.getStableReference(rAttribute);
        long rsType = this.mapper.getStableReference(rType);
        this.delegate.freeReference(rType);
        if (name == null || !this.delegate.deleteAttribute(rAttribute)) {
            this.mapper.releaseStableReference(rsClass);
            this.mapper.releaseStableReference(rsAttr);
            this.mapper.releaseStableReference(rsType);
            return false;
        }
        this.mapper.redirectStableReference(rsAttr, 0L);
        this.actions.add(new AttributeAction(this.delegate, this.mapper, rsClass, rsAttr, name, rsType, false));
        return true;
    }

    @Override
    public boolean setAttributeValue(long rObject, long rAttribute, String value) {
        if (this.undone) {
            this.clear();
        }
        String oldValue = this.delegate.getAttributeValue(rObject, rAttribute);
        if (!this.delegate.setAttributeValue(rObject, rAttribute, value)) {
            return false;
        }
        long rsObject = this.mapper.getStableReference(rObject);
        long rsAttribute = this.mapper.getStableReference(rAttribute);
        this.actions.add(new AttributeValueAction(this.delegate, this.mapper, rsObject, rsAttribute, oldValue, value));
        return true;
    }

    @Override
    public boolean deleteAttributeValue(long rObject, long rAttribute) {
        if (this.undone) {
            this.clear();
        }
        String value = this.delegate.getAttributeValue(rObject, rAttribute);
        if (!this.delegate.deleteAttributeValue(rObject, rAttribute)) {
            return false;
        }
        long rsObject = this.mapper.getStableReference(rObject);
        long rsAttribute = this.mapper.getStableReference(rAttribute);
        this.actions.add(new AttributeValueAction(this.delegate, this.mapper, rsObject, rsAttribute, value, null));
        return true;
    }

    @Override
    public long createAssociation(long rSourceClass, long rTargetClass, String sourceRoleName, String targetRoleName, boolean isComposition) {
        long rAssoc;
        if (this.undone) {
            this.clear();
        }
        if ((rAssoc = this.delegate.createAssociation(rSourceClass, rTargetClass, sourceRoleName, targetRoleName, isComposition)) == 0L) {
            return 0L;
        }
        long rsAssoc = this.mapper.getStableReference(rAssoc);
        long rInv = this.delegate.getInverseAssociationEnd(rAssoc);
        long rsInv = this.mapper.getStableReference(rInv);
        this.delegate.freeReference(rInv);
        long rsSourceClass = this.mapper.getStableReference(rSourceClass);
        long rsTargetClass = this.mapper.getStableReference(rTargetClass);
        this.actions.add(new AssociationAction(this.delegate, this.mapper, rsAssoc, rsInv, rsSourceClass, rsTargetClass, sourceRoleName, targetRoleName, isComposition, true));
        return rAssoc;
    }

    @Override
    public long createDirectedAssociation(long rSourceClass, long rTargetClass, String targetRoleName, boolean isComposition) {
        long rAssoc;
        if (this.undone) {
            this.clear();
        }
        if ((rAssoc = this.delegate.createDirectedAssociation(rSourceClass, rTargetClass, targetRoleName, isComposition)) == 0L) {
            return 0L;
        }
        long rsAssoc = this.mapper.getStableReference(rAssoc);
        long rsSourceClass = this.mapper.getStableReference(rSourceClass);
        long rsTargetClass = this.mapper.getStableReference(rTargetClass);
        this.actions.add(new AssociationAction(this.delegate, this.mapper, rsAssoc, 0L, rsSourceClass, rsTargetClass, null, targetRoleName, isComposition, true));
        return rAssoc;
    }

    @Override
    public long createAdvancedAssociation(String name, boolean nAry, boolean associationClass) {
        long rAssoc;
        if (this.undone) {
            this.clear();
        }
        if ((rAssoc = this.delegate.createAdvancedAssociation(name, nAry, associationClass)) == 0L) {
            return 0L;
        }
        long rsAssoc = this.mapper.getStableReference(rAssoc);
        this.actions.add(new AssociationAction(this.delegate, this.mapper, rsAssoc, name, nAry, associationClass, true));
        return rAssoc;
    }

    @Override
    public boolean deleteAssociation(long rAssociationEndOrAdvancedAssociation) {
        if (this.undone) {
            this.clear();
        }
        if (this.delegate.isAdvancedAssociation(rAssociationEndOrAdvancedAssociation)) {
            String name = this.delegate.getClassName(rAssociationEndOrAdvancedAssociation);
            long rs = this.mapper.getStableReference(rAssociationEndOrAdvancedAssociation);
            boolean retVal = this.delegate.deleteAssociation(rAssociationEndOrAdvancedAssociation);
            if (retVal) {
                this.mapper.redirectStableReference(rs, 0L);
                this.actions.add(new AssociationAction(this.delegate, this.mapper, rs, name, true, true, false));
            } else {
                this.mapper.releaseStableReference(rs);
            }
            return retVal;
        }
        long rInv = this.delegate.getInverseAssociationEnd(rAssociationEndOrAdvancedAssociation);
        if (rInv != 0L) {
            long rSrcCls = this.delegate.getSourceClass(rAssociationEndOrAdvancedAssociation);
            long rTgtCls = this.delegate.getTargetClass(rAssociationEndOrAdvancedAssociation);
            long rsAssoc = this.mapper.getStableReference(rAssociationEndOrAdvancedAssociation);
            long rsInv = this.mapper.getStableReference(rInv);
            this.delegate.freeReference(rInv);
            long rsSourceClass = this.mapper.getStableReference(rSrcCls);
            this.delegate.freeReference(rSrcCls);
            long rsTargetClass = this.mapper.getStableReference(rTgtCls);
            this.delegate.freeReference(rTgtCls);
            String targetRoleName = this.delegate.getRoleName(rAssociationEndOrAdvancedAssociation);
            String sourceRoleName = this.delegate.getRoleName(rInv);
            boolean isComposition = this.delegate.isComposition(rAssociationEndOrAdvancedAssociation);
            if (this.delegate.deleteAssociation(rAssociationEndOrAdvancedAssociation)) {
                this.mapper.redirectStableReference(rsAssoc, 0L);
                this.mapper.redirectStableReference(rsInv, 0L);
                this.actions.add(new AssociationAction(this.delegate, this.mapper, rsAssoc, rsInv, rsSourceClass, rsTargetClass, sourceRoleName, targetRoleName, isComposition, false));
                return true;
            }
            this.mapper.releaseStableReference(rsAssoc);
            this.mapper.releaseStableReference(rsInv);
            this.mapper.releaseStableReference(rsSourceClass);
            this.mapper.releaseStableReference(rsTargetClass);
            return false;
        }
        long rSrcCls = this.delegate.getSourceClass(rAssociationEndOrAdvancedAssociation);
        long rTgtCls = this.delegate.getTargetClass(rAssociationEndOrAdvancedAssociation);
        long rsAssoc = this.mapper.getStableReference(rAssociationEndOrAdvancedAssociation);
        long rsSourceClass = this.mapper.getStableReference(rSrcCls);
        this.delegate.freeReference(rSrcCls);
        long rsTargetClass = this.mapper.getStableReference(rTgtCls);
        this.delegate.freeReference(rTgtCls);
        String targetRoleName = this.delegate.getRoleName(rAssociationEndOrAdvancedAssociation);
        boolean isComposition = this.delegate.isComposition(rAssociationEndOrAdvancedAssociation);
        if (this.delegate.deleteAssociation(rAssociationEndOrAdvancedAssociation)) {
            this.mapper.redirectStableReference(rsAssoc, 0L);
            this.actions.add(new AssociationAction(this.delegate, this.mapper, rsAssoc, 0L, rsSourceClass, rsTargetClass, null, targetRoleName, isComposition, false));
            return true;
        }
        this.mapper.releaseStableReference(rsAssoc);
        this.mapper.releaseStableReference(rsSourceClass);
        this.mapper.releaseStableReference(rsTargetClass);
        return false;
    }

    @Override
    public boolean createLink(long rSourceObject, long rTargetObject, long rAssociationEnd) {
        if (this.undone) {
            this.clear();
        }
        if (!this.delegate.createLink(rSourceObject, rTargetObject, rAssociationEnd)) {
            return false;
        }
        long rsSourceObject = this.mapper.getStableReference(rSourceObject);
        long rsAssociationEnd = this.mapper.getStableReference(rAssociationEnd);
        long rsTargetObject = this.mapper.getStableReference(rTargetObject);
        this.actions.add(new LinkAction(this.delegate, this.mapper, rsSourceObject, rsTargetObject, rsAssociationEnd, -1, true));
        return true;
    }

    @Override
    public boolean createOrderedLink(long rSourceObject, long rTargetObject, long rAssociationEnd, int targetPosition) {
        if (this.undone) {
            this.clear();
        }
        if (!this.delegate.createOrderedLink(rSourceObject, rTargetObject, rAssociationEnd, targetPosition)) {
            return false;
        }
        long rsSourceObject = this.mapper.getStableReference(rSourceObject);
        long rsAssociationEnd = this.mapper.getStableReference(rAssociationEnd);
        long rsTargetObject = this.mapper.getStableReference(rTargetObject);
        this.actions.add(new LinkAction(this.delegate, this.mapper, rsSourceObject, rsTargetObject, rsAssociationEnd, targetPosition, true));
        return true;
    }

    @Override
    public boolean deleteLink(long rSourceObject, long rTargetObject, long rAssociationEnd) {
        if (this.undone) {
            this.clear();
        }
        if (!this.delegate.deleteLink(rSourceObject, rTargetObject, rAssociationEnd)) {
            return false;
        }
        assert (!this.linkExists(rSourceObject, rTargetObject, rAssociationEnd));
        long rsSourceObject = this.mapper.getStableReference(rSourceObject);
        long rsAssociationEnd = this.mapper.getStableReference(rAssociationEnd);
        long rsTargetObject = this.mapper.getStableReference(rTargetObject);
        this.actions.add(new LinkAction(this.delegate, this.mapper, rsSourceObject, rsTargetObject, rsAssociationEnd, -1, false));
        return true;
    }

    public void registerExternalAction(IExternalAction a) {
        if (this.undone) {
            this.clear();
        }
        this.actions.add(new ExternalActionWrapper(a));
    }

    public boolean isUndone() {
        return this.undone;
    }

    public boolean undo() {
        if (this.undone) {
            return this.actions.isEmpty();
        }
        this.undone = true;
        boolean ok = true;
        int i = this.actions.size() - 1;
        while (i >= 0) {
            if (!this.actions.get(i).undo()) {
                ok = false;
            }
            --i;
        }
        return ok;
    }

    public boolean redo() {
        if (!this.undone) {
            return this.actions.isEmpty();
        }
        this.undone = false;
        boolean ok = true;
        int i = 0;
        while (i < this.actions.size()) {
            if (!this.actions.get(i).redo()) {
                ok = false;
            }
            ++i;
        }
        return ok;
    }

    public void clear() {
        for (RepositoryAction a : this.actions) {
            a.free();
        }
        this.actions.clear();
        this.undone = false;
    }

    @Override
    public boolean exists(String location) {
        if (this.delegate2 != null) {
            return this.delegate2.exists(location);
        }
        return false;
    }

    @Override
    public boolean open(String location) {
        if (this.delegate2 != null) {
            return this.delegate2.open(location);
        }
        return false;
    }

    @Override
    public void close() {
        if (this.delegate2 != null) {
            this.delegate2.close();
        }
    }

    @Override
    public boolean startSave() {
        if (this.delegate2 != null) {
            return this.delegate2.startSave();
        }
        return false;
    }

    @Override
    public boolean finishSave() {
        if (this.delegate2 != null) {
            return this.delegate2.finishSave();
        }
        return false;
    }

    @Override
    public boolean cancelSave() {
        if (this.delegate2 != null) {
            return this.delegate2.cancelSave();
        }
        return false;
    }

    @Override
    public boolean drop(String location) {
        if (this.delegate2 != null) {
            return this.delegate2.drop(location);
        }
        return false;
    }

    private class AssociationAction
    extends RepositoryAction {
        long rsSourceClassReference;
        long rsTargetClassReference;
        long rsAssociationReference;
        long rsInverseAssociationReference;
        String sourceRole;
        String targetRole;
        boolean isComposition;
        String name;
        boolean nAry;
        boolean associationClass;

        AssociationAction(RAAPI _raapi, IReferenceMapper _mapper, long _rsAssociationReference, long _rsInverseAssociationReference, long _rsSourceClassReference, long _rsTargetClassReference, String _sourceRole, String _targetRole, boolean _isComposition, boolean _created) {
            super(_raapi, _mapper, _created);
            this.sourceRole = null;
            this.name = null;
            this.rsAssociationReference = _rsAssociationReference;
            this.rsInverseAssociationReference = _rsInverseAssociationReference;
            this.rsSourceClassReference = _rsSourceClassReference;
            this.rsTargetClassReference = _rsTargetClassReference;
            this.sourceRole = _sourceRole;
            this.targetRole = _targetRole;
            this.isComposition = _isComposition;
        }

        AssociationAction(RAAPI _raapi, IReferenceMapper _mapper, long _rsAssociationReference, String _name, boolean _nAry, boolean _associationClass, boolean _created) {
            super(_raapi, _mapper, _created);
            this.sourceRole = null;
            this.name = null;
            this.rsAssociationReference = _rsAssociationReference;
            this.name = _name;
            this.nAry = _nAry;
            this.associationClass = _associationClass;
        }

        boolean isAdvancedAssociation() {
            return this.name != null;
        }

        boolean isDirectedAssociation() {
            return this.sourceRole != null;
        }

        @Override
        boolean recreate() {
            if (this.isAdvancedAssociation()) {
                long r = this.raapi.createAdvancedAssociation(this.name, this.nAry, this.associationClass);
                if (r != 0L) {
                    this.mapper.redirectStableReference(this.rsAssociationReference, r);
                }
                return r != 0L;
            }
            if (this.isDirectedAssociation()) {
                long r = this.raapi.createDirectedAssociation(this.mapper.getUnstableReference(this.rsSourceClassReference), this.mapper.getUnstableReference(this.rsTargetClassReference), this.targetRole, this.isComposition);
                if (r != 0L) {
                    this.mapper.redirectStableReference(this.rsAssociationReference, r);
                }
                return r != 0L;
            }
            long r = this.raapi.createAssociation(this.mapper.getUnstableReference(this.rsSourceClassReference), this.mapper.getUnstableReference(this.rsTargetClassReference), this.sourceRole, this.targetRole, this.isComposition);
            if (r != 0L) {
                this.mapper.redirectStableReference(this.rsAssociationReference, r);
                r = this.raapi.getInverseAssociationEnd(r);
                if (r != 0L) {
                    this.mapper.redirectStableReference(this.rsInverseAssociationReference, r);
                    this.raapi.freeReference(r);
                }
            }
            return r != 0L;
        }

        @Override
        boolean redelete() {
            boolean retVal = this.raapi.deleteAssociation(this.mapper.getUnstableReference(this.rsAssociationReference));
            if (retVal) {
                this.mapper.redirectStableReference(this.rsAssociationReference, 0L);
                if (!this.isAdvancedAssociation() && this.isDirectedAssociation()) {
                    this.mapper.redirectStableReference(this.rsInverseAssociationReference, 0L);
                }
            }
            return retVal;
        }

        @Override
        void free() {
            if (!this.isAdvancedAssociation()) {
                this.mapper.releaseStableReference(this.rsSourceClassReference);
                this.mapper.releaseStableReference(this.rsTargetClassReference);
                if (!this.isDirectedAssociation()) {
                    this.mapper.releaseStableReference(this.rsInverseAssociationReference);
                }
            }
            this.mapper.releaseStableReference(this.rsAssociationReference);
        }
    }

    private class AttributeAction
    extends RepositoryAction {
        long rsClass;
        long rsAttribute;
        String name;
        long rsType;

        AttributeAction(RAAPI _raapi, IReferenceMapper _mapper, long _rsClass, long _rsAttribute, String _name, long _rsType, boolean _created) {
            super(_raapi, _mapper, _created);
            this.rsClass = _rsClass;
            this.rsAttribute = _rsAttribute;
            this.name = _name;
            this.rsType = _rsType;
        }

        @Override
        boolean recreate() {
            long newUnstableReference = this.raapi.createAttribute(this.mapper.getUnstableReference(this.rsClass), this.name, this.mapper.getUnstableReference(this.rsType));
            if (newUnstableReference != 0L) {
                this.mapper.redirectStableReference(this.rsAttribute, newUnstableReference);
                return true;
            }
            return false;
        }

        @Override
        boolean redelete() {
            boolean retVal = this.raapi.deleteAttribute(this.mapper.getUnstableReference(this.rsAttribute));
            if (retVal) {
                this.mapper.redirectStableReference(this.rsAttribute, 0L);
            }
            return retVal;
        }

        @Override
        void free() {
            this.mapper.releaseStableReference(this.rsClass);
            this.mapper.releaseStableReference(this.rsAttribute);
            this.mapper.releaseStableReference(this.rsType);
        }
    }

    private class AttributeValueAction
    extends RepositoryAction {
        long rsObject;
        long rsAttribute;
        String oldValue;
        String newValue;

        AttributeValueAction(RAAPI _raapi, IReferenceMapper _mapper, long _rsObjectReference, long _rsAttributeReference, String _oldValue, String _newValue) {
            super(_raapi, _mapper, true);
            this.rsObject = _rsObjectReference;
            this.rsAttribute = _rsAttributeReference;
            this.oldValue = _oldValue;
            this.newValue = _newValue;
        }

        @Override
        boolean recreate() {
            if (this.newValue == null) {
                return this.raapi.deleteAttributeValue(this.mapper.getUnstableReference(this.rsObject), this.mapper.getUnstableReference(this.rsAttribute));
            }
            return this.raapi.setAttributeValue(this.mapper.getUnstableReference(this.rsObject), this.mapper.getUnstableReference(this.rsAttribute), this.newValue);
        }

        @Override
        boolean redelete() {
            if (this.oldValue == null) {
                return this.raapi.deleteAttributeValue(this.mapper.getUnstableReference(this.rsObject), this.mapper.getUnstableReference(this.rsAttribute));
            }
            return this.raapi.setAttributeValue(this.mapper.getUnstableReference(this.rsObject), this.mapper.getUnstableReference(this.rsAttribute), this.oldValue);
        }

        @Override
        void free() {
            this.mapper.releaseStableReference(this.rsObject);
            this.mapper.releaseStableReference(this.rsAttribute);
        }
    }

    private class ClassAction
    extends RepositoryAction {
        IReferenceMapper mapper;
        long rsClass;
        String name;

        ClassAction(RAAPI _raapi, IReferenceMapper _mapper, long _rsClass, String _name, boolean _created) {
            super(_raapi, _mapper, _created);
            this.mapper = _mapper;
            this.rsClass = _rsClass;
            this.name = _name;
        }

        @Override
        boolean recreate() {
            long newUnstableReference = this.raapi.createClass(this.name);
            if (newUnstableReference != 0L) {
                this.mapper.redirectStableReference(this.rsClass, newUnstableReference);
                return true;
            }
            return false;
        }

        @Override
        boolean redelete() {
            boolean retVal = this.raapi.deleteClass(this.mapper.getUnstableReference(this.rsClass));
            if (retVal) {
                this.mapper.redirectStableReference(this.rsClass, 0L);
            }
            return retVal;
        }

        @Override
        void free() {
            this.mapper.releaseStableReference(this.rsClass);
        }
    }

    private class ExternalActionWrapper
    extends RepositoryAction {
        IExternalAction action;

        ExternalActionWrapper(IExternalAction _a) {
            super(null, null, true);
            this.action = _a;
        }

        @Override
        boolean recreate() {
            return this.action.redo();
        }

        @Override
        boolean redelete() {
            return this.action.undo();
        }

        @Override
        void free() {
            this.action.free();
        }
    }

    private class GeneralizationAction
    extends RepositoryAction {
        IReferenceMapper mapper;
        long rsSubClass;
        long rsSuperClass;

        GeneralizationAction(RAAPI _raapi, IReferenceMapper _mapper, long _rsSubClass, long _rsSuperClass, boolean _created) {
            super(_raapi, _mapper, _created);
            this.mapper = _mapper;
            this.rsSubClass = _rsSubClass;
            this.rsSuperClass = _rsSuperClass;
        }

        @Override
        boolean recreate() {
            return this.raapi.createGeneralization(this.mapper.getUnstableReference(this.rsSubClass), this.mapper.getUnstableReference(this.rsSuperClass));
        }

        @Override
        boolean redelete() {
            return this.raapi.deleteGeneralization(this.mapper.getUnstableReference(this.rsSubClass), this.mapper.getUnstableReference(this.rsSuperClass));
        }

        @Override
        void free() {
            this.mapper.releaseStableReference(this.rsSubClass);
            this.mapper.releaseStableReference(this.rsSuperClass);
        }
    }

    public static interface IExternalAction {
        public boolean undo();

        public boolean redo();

        public void free();
    }

    private class LinkAction
    extends RepositoryAction {
        long rsSourceObjectReference;
        long rsTargetObjectReference;
        long rsAssociationReference;
        int position;

        LinkAction(RAAPI _raapi, IReferenceMapper _mapper, long _rsSourceObjectReference, long _rsTargetObjectReference, long _rsAssociationReference, int _position, boolean _created) {
            super(_raapi, _mapper, _created);
            this.rsSourceObjectReference = _rsSourceObjectReference;
            this.rsTargetObjectReference = _rsTargetObjectReference;
            this.rsAssociationReference = _rsAssociationReference;
            this.position = _position;
        }

        @Override
        boolean recreate() {
            if (this.position == -1) {
                boolean retVal = this.raapi.createLink(this.mapper.getUnstableReference(this.rsSourceObjectReference), this.mapper.getUnstableReference(this.rsTargetObjectReference), this.mapper.getUnstableReference(this.rsAssociationReference));
                return retVal;
            }
            return this.raapi.createOrderedLink(this.mapper.getUnstableReference(this.rsSourceObjectReference), this.mapper.getUnstableReference(this.rsTargetObjectReference), this.mapper.getUnstableReference(this.rsAssociationReference), this.position);
        }

        @Override
        boolean redelete() {
            boolean retVal = this.raapi.deleteLink(this.mapper.getUnstableReference(this.rsSourceObjectReference), this.mapper.getUnstableReference(this.rsTargetObjectReference), this.mapper.getUnstableReference(this.rsAssociationReference));
            return retVal;
        }

        @Override
        void free() {
            this.mapper.releaseStableReference(this.rsSourceObjectReference);
            this.mapper.releaseStableReference(this.rsTargetObjectReference);
            this.mapper.releaseStableReference(this.rsAssociationReference);
        }
    }

    private class MoveObjectAction
    extends RepositoryAction {
        long rsObject;
        long rsOldClass;
        long rsNewClass;

        MoveObjectAction(RAAPI _raapi, IReferenceMapper _mapper, long _rsObjectReference, long _rsOldClass, long _rsNewClass) {
            super(_raapi, _mapper, true);
            this.rsObject = _rsObjectReference;
            this.rsOldClass = _rsOldClass;
            this.rsNewClass = _rsNewClass;
        }

        @Override
        boolean recreate() {
            return this.raapi.moveObject(this.mapper.getUnstableReference(this.rsObject), this.mapper.getUnstableReference(this.rsNewClass));
        }

        @Override
        boolean redelete() {
            return this.raapi.moveObject(this.mapper.getUnstableReference(this.rsObject), this.mapper.getUnstableReference(this.rsOldClass));
        }

        @Override
        void free() {
            this.mapper.releaseStableReference(this.rsObject);
            this.mapper.releaseStableReference(this.rsOldClass);
            this.mapper.releaseStableReference(this.rsNewClass);
        }
    }

    private class ObjectAction
    extends RepositoryAction {
        IReferenceMapper mapper;
        long rsObject;
        long rsClass;

        ObjectAction(RAAPI _raapi, IReferenceMapper _mapper, long _rsObject, long _rsClass, boolean _created) {
            super(_raapi, _mapper, _created);
            this.mapper = _mapper;
            this.rsObject = _rsObject;
            this.rsClass = _rsClass;
        }

        @Override
        boolean recreate() {
            long newUnstableReference = this.raapi.createObject(this.mapper.getUnstableReference(this.rsClass));
            if (newUnstableReference != 0L) {
                this.mapper.redirectStableReference(this.rsObject, newUnstableReference);
                return true;
            }
            return false;
        }

        @Override
        boolean redelete() {
            boolean retVal = this.raapi.deleteObject(this.mapper.getUnstableReference(this.rsObject));
            if (retVal) {
                this.mapper.redirectStableReference(this.rsObject, 0L);
            }
            return retVal;
        }

        @Override
        void free() {
            this.mapper.releaseStableReference(this.rsObject);
            this.mapper.releaseStableReference(this.rsClass);
        }
    }

    private class ObjectClassAction
    extends RepositoryAction {
        long rsObject;
        long rsClass;

        ObjectClassAction(RAAPI _raapi, IReferenceMapper _mapper, long _rsObjectReference, long _rsClassReference, boolean _created) {
            super(_raapi, _mapper, _created);
            this.rsObject = _rsObjectReference;
            this.rsClass = _rsClassReference;
        }

        @Override
        boolean recreate() {
            return this.raapi.includeObjectInClass(this.mapper.getUnstableReference(this.rsObject), this.mapper.getUnstableReference(this.rsClass));
        }

        @Override
        boolean redelete() {
            return this.raapi.excludeObjectFromClass(this.mapper.getUnstableReference(this.rsObject), this.mapper.getUnstableReference(this.rsClass));
        }

        @Override
        void free() {
            this.mapper.releaseStableReference(this.rsObject);
            this.mapper.releaseStableReference(this.rsClass);
        }
    }

    private abstract class RepositoryAction {
        RAAPI raapi;
        IReferenceMapper mapper;
        boolean created;

        RepositoryAction(RAAPI _raapi, IReferenceMapper _mapper, boolean _created) {
            this.raapi = _raapi;
            this.mapper = _mapper;
            this.created = _created;
        }

        boolean undo() {
            if (this.created) {
                return this.redelete();
            }
            return this.recreate();
        }

        boolean redo() {
            if (this.created) {
                return this.recreate();
            }
            return this.redelete();
        }

        abstract boolean recreate();

        abstract boolean redelete();

        abstract void free();
    }
}

