/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.kernel;

import lv.lumii.tda.kernel.IEventsCommandsHook;
import lv.lumii.tda.kernel.TDAKernel;
import lv.lumii.tda.raapi.IEngineAdapter;
import lv.lumii.tda.raapi.ITransformationAdapter;
import lv.lumii.tda.raapi.RAAPIHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webappos.util.StackTrace;

public class DirectEventsCommandsHook
implements IEventsCommandsHook {
    private static Logger logger = LoggerFactory.getLogger(DirectEventsCommandsHook.class);

    @Override
    public boolean handleEvent(TDAKernel raapi, long rEvent) {
        TDAKernel adapters = raapi;
        String[] handlers = adapters.getEventHandlers(rEvent);
        if (handlers == null) {
            return true;
        }
        boolean retVal = true;
        String[] stringArray = handlers;
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            long transformationArgument;
            String transformationName = stringArray[n2];
            String type = TDAKernel.getAdapterTypeFromURI(transformationName);
            String location = TDAKernel.getLocationFromURI(transformationName);
            if (type == null) {
                return false;
            }
            int i = type.indexOf(40);
            if (i >= 0 && type.endsWith(")")) {
                long parsed;
                try {
                    parsed = Long.parseLong(type.substring(i + 1, type.length() - 1));
                }
                catch (Throwable t) {
                    parsed = 0L;
                }
                transformationArgument = parsed;
                type = type.substring(0, i);
            } else {
                transformationArgument = rEvent;
            }
            ITransformationAdapter adapter = adapters.getTransformationAdapter(type);
            if (adapter == null) {
                retVal = false;
            }
            try {
                if (!adapter.launchTransformation(location, transformationArgument)) {
                    retVal = false;
                }
            }
            catch (Throwable t) {
                StackTrace.log((Throwable)t, (Logger)logger);
                retVal = false;
            }
            ++n2;
        }
        return retVal;
    }

    @Override
    public boolean executeCommand(TDAKernel raapi, long rCommand) {
        TDAKernel adapters = raapi;
        String className = RAAPIHelper.getObjectClassName(raapi, rCommand);
        if (className == null) {
            return false;
        }
        String engineName = adapters.getEngineForEventOrCommand(className);
        if (engineName == null) {
            return false;
        }
        IEngineAdapter adapter = adapters.getEngineAdapter(engineName);
        if (adapter == null) {
            return false;
        }
        return adapter.executeCommand(rCommand);
    }
}

