/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.kernel;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lv.lumii.tda.kernel.DelegatorToRepositoryBase;
import lv.lumii.tda.raapi.IRepository;
import lv.lumii.tda.raapi.RAAPI_WR;
import lv.lumii.tda.util.ObjectsIndexer;

public class DelegatorToRepositoryWithWritableReferences
extends DelegatorToRepositoryBase
implements RAAPI_WR {
    private ObjectsIndexer<PeculiarIterator> iteratorIndexer = new ObjectsIndexer(32);
    IRepository repo;
    private int predefinedBitsCount = 0;
    private long predefinedBitsValues = 0L;
    private String mapLocation = null;
    private boolean even = false;
    private long maxIndex = 0L;
    private Map<Long, Long> r2i_map = new HashMap<Long, Long>();
    private Map<Long, Long> i2r_map = new HashMap<Long, Long>();

    DelegatorToRepositoryWithWritableReferences(IRepository _repo) {
        super.setDelegate(_repo);
        this.repo = _repo;
    }

    private synchronized long i2r(long index) {
        if (index == 0L) {
            return 0L;
        }
        Long l = this.i2r_map.get(index);
        if (l == null) {
            return 0L;
        }
        return l;
    }

    private synchronized long r2i(long reference) {
        if (reference == 0L) {
            return 0L;
        }
        Long l = this.r2i_map.get(reference);
        if (l == null) {
            return 0L;
        }
        return l;
    }

    private synchronized long r2n(long reference) {
        if (reference == 0L) {
            return 0L;
        }
        long i = this.newIndex();
        this.r2i_map.put(reference, i);
        this.i2r_map.put(i, reference);
        return i;
    }

    private synchronized long newIndex() {
        this.maxIndex = (this.maxIndex >> this.predefinedBitsCount) + 1L << this.predefinedBitsCount | this.predefinedBitsValues;
        return this.maxIndex;
    }

    @Override
    public synchronized long findPrimitiveDataType(String name) {
        return this.r2i(this.getDelegate().findPrimitiveDataType(name));
    }

    @Override
    public synchronized String getPrimitiveDataTypeName(long iDataType) {
        return this.getDelegate().getPrimitiveDataTypeName(this.i2r(iDataType));
    }

    @Override
    public synchronized boolean isPrimitiveDataType(long index) {
        if (index == 0L) {
            return false;
        }
        return this.getDelegate().isPrimitiveDataType(this.i2r(index));
    }

    @Override
    public synchronized long createClass(String name) {
        return this.r2n(this.getDelegate().createClass(name));
    }

    @Override
    public synchronized long findClass(String name) {
        return this.r2i(this.getDelegate().findClass(name));
    }

    @Override
    public synchronized String getClassName(long iClass) {
        return this.getDelegate().getClassName(this.i2r(iClass));
    }

    @Override
    public synchronized boolean deleteClass(long iClass) {
        Long r2 = this.i2r_map.get(iClass);
        if (r2 != null) {
            this.getDelegate().deleteClass(r2);
            this.i2r_map.remove(iClass);
            this.r2i_map.remove(r2);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean isClass(long i) {
        return this.getDelegate().isClass(this.i2r(i));
    }

    @Override
    public synchronized long createObject(long iClass) {
        return this.r2n(this.getDelegate().createObject(this.i2r(iClass)));
    }

    @Override
    public synchronized boolean moveObject(long iObject, long iToClass) {
        return this.getDelegate().moveObject(this.i2r(iObject), this.i2r(iToClass));
    }

    @Override
    public synchronized boolean deleteObject(long iObject) {
        Long r2 = this.i2r_map.get(iObject);
        if (r2 != null) {
            this.getDelegate().deleteObject(r2);
            this.i2r_map.remove(iObject);
            this.r2i_map.remove(r2);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean includeObjectInClass(long iObject, long iClass) {
        return this.getDelegate().includeObjectInClass(this.i2r(iObject), this.i2r(iClass));
    }

    @Override
    public synchronized boolean excludeObjectFromClass(long iObject, long iClass) {
        return this.getDelegate().excludeObjectFromClass(this.i2r(iObject), this.i2r(iClass));
    }

    @Override
    public synchronized long createAttribute(long iClass, String name, long iType) {
        return this.r2n(this.getDelegate().createAttribute(this.i2r(iClass), name, this.i2r(iType)));
    }

    @Override
    public synchronized long findAttribute(long iClass, String name) {
        return this.r2i(this.getDelegate().findAttribute(this.i2r(iClass), name));
    }

    @Override
    public synchronized String getAttributeName(long iAttribute) {
        return this.getDelegate().getAttributeName(this.i2r(iAttribute));
    }

    @Override
    public synchronized long getAttributeDomain(long iAttribute) {
        return this.r2i(this.getDelegate().getAttributeDomain(this.i2r(iAttribute)));
    }

    @Override
    public synchronized long getAttributeType(long iAttribute) {
        return this.r2i(this.getDelegate().getAttributeType(this.i2r(iAttribute)));
    }

    @Override
    public synchronized boolean deleteAttribute(long iAttribute) {
        Long r2 = this.i2r_map.get(iAttribute);
        if (r2 != null) {
            this.getDelegate().deleteAttribute(r2);
            this.i2r_map.remove(iAttribute);
            this.r2i_map.remove(r2);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean isAttribute(long i) {
        return this.getDelegate().isAttribute(this.i2r(i));
    }

    @Override
    public synchronized boolean setAttributeValue(long iObject, long iAttribute, String value) {
        return this.getDelegate().setAttributeValue(this.i2r(iObject), this.i2r(iAttribute), value);
    }

    @Override
    public synchronized String getAttributeValue(long iObject, long iAttribute) {
        return this.getDelegate().getAttributeValue(this.i2r(iObject), this.i2r(iAttribute));
    }

    @Override
    public synchronized boolean deleteAttributeValue(long iObject, long iAttribute) {
        return this.getDelegate().deleteAttributeValue(this.i2r(iObject), this.i2r(iAttribute));
    }

    @Override
    public synchronized long createAssociation(long iSourceClass, long iTargetClass, String sourceRole, String targetRole, boolean isComposition) {
        long r = this.getDelegate().createAssociation(this.i2r(iSourceClass), this.i2r(iTargetClass), sourceRole, targetRole, isComposition);
        long rInv = this.getDelegate().getInverseAssociationEnd(r);
        this.r2n(rInv);
        return this.r2n(r);
    }

    @Override
    public synchronized long createDirectedAssociation(long iSourceClass, long iTargetClass, String targetRole, boolean isComposition) {
        long r = this.getDelegate().createDirectedAssociation(this.i2r(iSourceClass), this.i2r(iTargetClass), targetRole, isComposition);
        long rInv = this.getDelegate().getInverseAssociationEnd(r);
        this.r2n(rInv);
        return this.r2n(r);
    }

    @Override
    public synchronized long createAdvancedAssociation(String name, boolean nAry, boolean associationClass) {
        long r = this.getDelegate().createAdvancedAssociation(name, nAry, associationClass);
        long rInv = this.getDelegate().getInverseAssociationEnd(r);
        this.r2n(rInv);
        return this.r2n(r);
    }

    @Override
    public synchronized boolean isAdvancedAssociation(long i) {
        return this.getDelegate().isAdvancedAssociation(this.i2r(i));
    }

    @Override
    public synchronized long findAssociationEnd(long iSourceClass, String targetRoleName) {
        return this.r2i(this.getDelegate().findAssociationEnd(this.i2r(iSourceClass), targetRoleName));
    }

    @Override
    public synchronized long getInverseAssociationEnd(long iAssociation) {
        return this.r2i(this.getDelegate().getInverseAssociationEnd(this.i2r(iAssociation)));
    }

    @Override
    public synchronized long getSourceClass(long iAssociation) {
        return this.r2i(this.getDelegate().getSourceClass(this.i2r(iAssociation)));
    }

    @Override
    public synchronized long getTargetClass(long iAssociation) {
        return this.r2i(this.getDelegate().getTargetClass(this.i2r(iAssociation)));
    }

    @Override
    public synchronized String getRoleName(long iAssociation) {
        return this.getDelegate().getRoleName(this.i2r(iAssociation));
    }

    @Override
    public synchronized boolean isComposition(long iAssociation) {
        return this.getDelegate().isComposition(this.i2r(iAssociation));
    }

    @Override
    public synchronized boolean deleteAssociation(long iAssociation) {
        Long r2 = this.i2r_map.get(iAssociation);
        if (r2 != null) {
            this.getDelegate().deleteAssociation(r2);
            this.i2r_map.remove(iAssociation);
            this.r2i_map.remove(r2);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean isAssociationEnd(long i) {
        return this.getDelegate().isAssociationEnd(this.i2r(i));
    }

    @Override
    public synchronized boolean createLink(long iSourceObject, long iTargetObject, long iAssociationEnd) {
        return this.getDelegate().createLink(this.i2r(iSourceObject), this.i2r(iTargetObject), this.i2r(iAssociationEnd));
    }

    @Override
    public synchronized boolean linkExists(long iSourceObject, long iTargetObject, long iAssociationEnd) {
        return this.getDelegate().linkExists(this.i2r(iSourceObject), this.i2r(iTargetObject), this.i2r(iAssociationEnd));
    }

    @Override
    public synchronized boolean createOrderedLink(long iSourceObject, long iTargetObject, long iAssociationEnd, int targetPosition) {
        return this.getDelegate().createOrderedLink(this.i2r(iSourceObject), this.i2r(iTargetObject), this.i2r(iAssociationEnd), targetPosition);
    }

    @Override
    public synchronized int getLinkedObjectPosition(long iSourceObject, long iTargetObject, long iAssociationEnd) {
        return this.getDelegate().getLinkedObjectPosition(this.i2r(iSourceObject), this.i2r(iTargetObject), this.i2r(iAssociationEnd));
    }

    @Override
    public synchronized boolean deleteLink(long iSourceObject, long iTargetObject, long iAssociationEnd) {
        return this.getDelegate().deleteLink(this.i2r(iSourceObject), this.i2r(iTargetObject), this.i2r(iAssociationEnd));
    }

    @Override
    public synchronized boolean createGeneralization(long iSubClass, long iSuperClass) {
        return this.getDelegate().createGeneralization(this.i2r(iSubClass), this.i2r(iSuperClass));
    }

    @Override
    public synchronized boolean isDirectSubClass(long iSubClass, long iSuperClass) {
        return this.getDelegate().isDirectSubClass(this.i2r(iSubClass), this.i2r(iSuperClass));
    }

    @Override
    public synchronized boolean isDerivedClass(long iDirectlyOrIndirectlyDerivedClass, long iSuperClass) {
        return this.getDelegate().isDerivedClass(this.i2r(iDirectlyOrIndirectlyDerivedClass), this.i2r(iSuperClass));
    }

    @Override
    public synchronized boolean deleteGeneralization(long iSubClass, long iSuperClass) {
        return this.getDelegate().deleteGeneralization(this.i2r(iSubClass), this.i2r(iSuperClass));
    }

    @Override
    public synchronized boolean isTypeOf(long iObject, long iClass) {
        return this.getDelegate().isTypeOf(this.i2r(iObject), this.i2r(iClass));
    }

    @Override
    public synchronized boolean isKindOf(long iObject, long iClass) {
        return this.getDelegate().isKindOf(this.i2r(iObject), this.i2r(iClass));
    }

    @Override
    public synchronized long getIteratorForClasses() {
        PeculiarIterator pit = new PeculiarIterator();
        long itCls = this.getDelegate().getIteratorForClasses();
        if (itCls != 0L) {
            long dCls = this.getDelegate().resolveIteratorFirst(itCls);
            while (dCls != 0L) {
                pit.add(this.r2i(dCls));
                dCls = this.getDelegate().resolveIteratorNext(itCls);
            }
            this.getDelegate().freeIterator(itCls);
        }
        return this.iteratorIndexer.acquireIndex(pit);
    }

    @Override
    public synchronized long getIteratorForAllClassObjects(long iClass) {
        PeculiarIterator pit = new PeculiarIterator();
        long it = this.getDelegate().getIteratorForAllClassObjects(this.i2r(iClass));
        if (it != 0L) {
            long r = this.getDelegate().resolveIteratorFirst(it);
            while (r != 0L) {
                pit.add(this.r2i(r));
                r = this.getDelegate().resolveIteratorNext(it);
            }
            this.getDelegate().freeIterator(it);
        }
        return this.iteratorIndexer.acquireIndex(pit);
    }

    @Override
    public synchronized long getIteratorForDirectClassObjects(long iClass) {
        PeculiarIterator pit = new PeculiarIterator();
        long it = this.getDelegate().getIteratorForDirectClassObjects(this.i2r(iClass));
        if (it != 0L) {
            long r = this.getDelegate().resolveIteratorFirst(it);
            while (r != 0L) {
                pit.add(this.r2i(r));
                r = this.getDelegate().resolveIteratorNext(it);
            }
            this.getDelegate().freeIterator(it);
        }
        return this.iteratorIndexer.acquireIndex(pit);
    }

    @Override
    public synchronized long getIteratorForDirectObjectClasses(long iObject) {
        PeculiarIterator pit = new PeculiarIterator();
        long it = this.getDelegate().getIteratorForDirectObjectClasses(this.i2r(iObject));
        if (it != 0L) {
            long r = this.getDelegate().resolveIteratorFirst(it);
            while (r != 0L) {
                pit.add(this.r2i(r));
                r = this.getDelegate().resolveIteratorNext(it);
            }
            this.getDelegate().freeIterator(it);
        }
        return this.iteratorIndexer.acquireIndex(pit);
    }

    @Override
    public synchronized long getIteratorForAllAttributes(long iClass) {
        PeculiarIterator pit = new PeculiarIterator();
        long it = this.getDelegate().getIteratorForAllAttributes(this.i2r(iClass));
        if (it != 0L) {
            long r = this.getDelegate().resolveIteratorFirst(it);
            while (r != 0L) {
                pit.add(this.r2i(r));
                r = this.getDelegate().resolveIteratorNext(it);
            }
            this.getDelegate().freeIterator(it);
        }
        return this.iteratorIndexer.acquireIndex(pit);
    }

    @Override
    public synchronized long getIteratorForDirectAttributes(long iClass) {
        PeculiarIterator pit = new PeculiarIterator();
        long it = this.getDelegate().getIteratorForDirectAttributes(this.i2r(iClass));
        if (it != 0L) {
            long r = this.getDelegate().resolveIteratorFirst(it);
            while (r != 0L) {
                pit.add(this.r2i(r));
                r = this.getDelegate().resolveIteratorNext(it);
            }
            this.getDelegate().freeIterator(it);
        }
        return this.iteratorIndexer.acquireIndex(pit);
    }

    @Override
    public synchronized long getIteratorForAllOutgoingAssociationEnds(long iClass) {
        PeculiarIterator pit = new PeculiarIterator();
        long it = this.getDelegate().getIteratorForAllOutgoingAssociationEnds(this.i2r(iClass));
        if (it != 0L) {
            long r = this.getDelegate().resolveIteratorFirst(it);
            while (r != 0L) {
                pit.add(this.r2i(r));
                r = this.getDelegate().resolveIteratorNext(it);
            }
            this.getDelegate().freeIterator(it);
        }
        return this.iteratorIndexer.acquireIndex(pit);
    }

    @Override
    public synchronized long getIteratorForDirectOutgoingAssociationEnds(long iClass) {
        PeculiarIterator pit = new PeculiarIterator();
        long it = this.getDelegate().getIteratorForDirectOutgoingAssociationEnds(this.i2r(iClass));
        if (it != 0L) {
            long r = this.getDelegate().resolveIteratorFirst(it);
            while (r != 0L) {
                pit.add(this.r2i(r));
                r = this.getDelegate().resolveIteratorNext(it);
            }
            this.getDelegate().freeIterator(it);
        }
        return this.iteratorIndexer.acquireIndex(pit);
    }

    @Override
    public synchronized long getIteratorForAllIngoingAssociationEnds(long iClass) {
        PeculiarIterator pit = new PeculiarIterator();
        long it = this.getDelegate().getIteratorForAllIngoingAssociationEnds(this.i2r(iClass));
        if (it != 0L) {
            long r = this.getDelegate().resolveIteratorFirst(it);
            while (r != 0L) {
                pit.add(this.r2i(r));
                r = this.getDelegate().resolveIteratorNext(it);
            }
            this.getDelegate().freeIterator(it);
        }
        return this.iteratorIndexer.acquireIndex(pit);
    }

    @Override
    public synchronized long getIteratorForDirectIngoingAssociationEnds(long iClass) {
        PeculiarIterator pit = new PeculiarIterator();
        long it = this.getDelegate().getIteratorForDirectIngoingAssociationEnds(this.i2r(iClass));
        if (it != 0L) {
            long r = this.getDelegate().resolveIteratorFirst(it);
            while (r != 0L) {
                pit.add(this.r2i(r));
                r = this.getDelegate().resolveIteratorNext(it);
            }
            this.getDelegate().freeIterator(it);
        }
        return this.iteratorIndexer.acquireIndex(pit);
    }

    @Override
    public synchronized long getIteratorForLinkedObjects(long iObject, long iAssociation) {
        PeculiarIterator pit = new PeculiarIterator();
        long it = this.getDelegate().getIteratorForLinkedObjects(this.i2r(iObject), this.i2r(iAssociation));
        if (it != 0L) {
            long r = this.getDelegate().resolveIteratorFirst(it);
            while (r != 0L) {
                pit.add(this.r2i(r));
                r = this.getDelegate().resolveIteratorNext(it);
            }
            this.getDelegate().freeIterator(it);
        }
        return this.iteratorIndexer.acquireIndex(pit);
    }

    @Override
    public synchronized long getIteratorForDirectSuperClasses(long iSubClass) {
        PeculiarIterator pit = new PeculiarIterator();
        long it = this.getDelegate().getIteratorForDirectSuperClasses(this.i2r(iSubClass));
        if (it != 0L) {
            long r = this.getDelegate().resolveIteratorFirst(it);
            while (r != 0L) {
                pit.add(this.r2i(r));
                r = this.getDelegate().resolveIteratorNext(it);
            }
            this.getDelegate().freeIterator(it);
        }
        return this.iteratorIndexer.acquireIndex(pit);
    }

    @Override
    public synchronized long getIteratorForDirectSubClasses(long iSuperClass) {
        PeculiarIterator pit = new PeculiarIterator();
        long it = this.getDelegate().getIteratorForDirectSubClasses(this.i2r(iSuperClass));
        if (it != 0L) {
            long r = this.getDelegate().resolveIteratorFirst(it);
            while (r != 0L) {
                pit.add(this.r2i(r));
                r = this.getDelegate().resolveIteratorNext(it);
            }
            this.getDelegate().freeIterator(it);
        }
        return this.iteratorIndexer.acquireIndex(pit);
    }

    @Override
    public synchronized long getIteratorForObjectsByAttributeValue(long iAttribute, String value) {
        PeculiarIterator pit = new PeculiarIterator();
        long it = this.getDelegate().getIteratorForObjectsByAttributeValue(this.i2r(iAttribute), value);
        if (it != 0L) {
            long r = this.getDelegate().resolveIteratorFirst(it);
            while (r != 0L) {
                pit.add(this.r2i(r));
                r = this.getDelegate().resolveIteratorNext(it);
            }
            this.getDelegate().freeIterator(it);
        }
        return this.iteratorIndexer.acquireIndex(pit);
    }

    @Override
    public synchronized long resolveIteratorFirst(long it) {
        if (it != 0L) {
            PeculiarIterator pi = this.iteratorIndexer.get(it);
            if (pi != null) {
                return pi.resolveFirst();
            }
            return 0L;
        }
        return 0L;
    }

    @Override
    public synchronized long resolveIteratorNext(long it) {
        if (it != 0L) {
            PeculiarIterator pi = this.iteratorIndexer.get(it);
            if (pi != null) {
                return pi.resolveNext();
            }
            return 0L;
        }
        return 0L;
    }

    @Override
    public synchronized int getIteratorLength(long it) {
        if (it != 0L) {
            PeculiarIterator pi = this.iteratorIndexer.get(it);
            if (pi != null) {
                return pi.getLength();
            }
            return 0;
        }
        return 0;
    }

    @Override
    public synchronized long resolveIterator(long it, int position) {
        if (it != 0L) {
            PeculiarIterator pi = this.iteratorIndexer.get(it);
            if (pi != null) {
                return pi.resolve(position);
            }
            return 0L;
        }
        return 0L;
    }

    @Override
    public synchronized String serializeReference(long r) {
        throw new RuntimeException("TDA Kernel: serializeReference() not yet implemented in DelegatorToRepositoryWithWritableReferences.");
    }

    @Override
    public synchronized long deserializeReference(String s) {
        throw new RuntimeException("TDA Kernel: deserializeReference() not yet implemented in DelegatorToRepositoryWithWritableReferences.");
    }

    @Override
    public synchronized void freeReference(long r) {
    }

    @Override
    public synchronized void freeIterator(long it) {
        PeculiarIterator pi;
        if (it != 0L && (pi = this.iteratorIndexer.get(it)) != null) {
            pi.free();
            this.iteratorIndexer.freeIndex(it);
        }
    }

    private synchronized boolean readMap() {
        long itC;
        this.r2i_map.clear();
        this.i2r_map.clear();
        if (this.mapLocation == null) {
            return false;
        }
        this.maxIndex = 0L;
        File f = new File(this.mapLocation);
        if (f.exists()) {
            FilterInputStream in = null;
            try {
                in = new DataInputStream(new FileInputStream(f));
                while (true) {
                    long index = ((DataInputStream)in).readLong();
                    long r = ((DataInputStream)in).readLong();
                    this.r2i_map.put(r, index);
                    this.i2r_map.put(index, r);
                    if (index <= this.maxIndex) continue;
                    this.maxIndex = index;
                }
            }
            catch (FileNotFoundException e) {
                return false;
            }
            catch (EOFException ignored) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return true;
            }
            catch (IOException e) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return false;
            }
        }
        long r = this.getDelegate().findPrimitiveDataType("String");
        if (r != 0L) {
            ++this.maxIndex;
            this.r2i_map.put(r, this.maxIndex);
            this.i2r_map.put(this.maxIndex, r);
        }
        if ((r = this.getDelegate().findPrimitiveDataType("Integer")) != 0L) {
            ++this.maxIndex;
            this.r2i_map.put(r, this.maxIndex);
            this.i2r_map.put(this.maxIndex, r);
        }
        if ((r = this.getDelegate().findPrimitiveDataType("Real")) != 0L) {
            ++this.maxIndex;
            this.r2i_map.put(r, this.maxIndex);
            this.i2r_map.put(this.maxIndex, r);
        }
        if ((r = this.getDelegate().findPrimitiveDataType("Boolean")) != 0L) {
            ++this.maxIndex;
            this.r2i_map.put(r, this.maxIndex);
            this.i2r_map.put(this.maxIndex, r);
        }
        if ((itC = this.getDelegate().getIteratorForClasses()) != 0L) {
            long rC = this.getDelegate().resolveIteratorFirst(itC);
            while (rC != 0L) {
                long itAI;
                long itAO;
                long itAt;
                ++this.maxIndex;
                this.r2i_map.put(rC, this.maxIndex);
                this.i2r_map.put(this.maxIndex, rC);
                long itO = this.getDelegate().getIteratorForDirectClassObjects(rC);
                if (itO != 0L) {
                    long rO = this.getDelegate().resolveIteratorFirst(itO);
                    while (rO != 0L) {
                        ++this.maxIndex;
                        this.r2i_map.put(rO, this.maxIndex);
                        this.i2r_map.put(this.maxIndex, rO);
                        rO = this.getDelegate().resolveIteratorNext(itO);
                    }
                    this.getDelegate().freeIterator(itO);
                }
                if ((itAt = this.getDelegate().getIteratorForDirectAttributes(rC)) != 0L) {
                    long rAt = this.getDelegate().resolveIteratorFirst(itAt);
                    while (rAt != 0L) {
                        ++this.maxIndex;
                        this.r2i_map.put(rAt, this.maxIndex);
                        this.i2r_map.put(this.maxIndex, rAt);
                        rAt = this.getDelegate().resolveIteratorNext(itAt);
                    }
                    this.getDelegate().freeIterator(itAt);
                }
                if ((itAO = this.getDelegate().getIteratorForDirectOutgoingAssociationEnds(rC)) != 0L) {
                    long rAO = this.getDelegate().resolveIteratorFirst(itAO);
                    while (rAO != 0L) {
                        ++this.maxIndex;
                        this.r2i_map.put(rAO, this.maxIndex);
                        this.i2r_map.put(this.maxIndex, rAO);
                        rAO = this.getDelegate().resolveIteratorNext(itAO);
                    }
                    this.getDelegate().freeIterator(itAO);
                }
                if ((itAI = this.getDelegate().getIteratorForDirectIngoingAssociationEnds(rC)) != 0L) {
                    long rAI = this.getDelegate().resolveIteratorFirst(itAI);
                    while (rAI != 0L) {
                        ++this.maxIndex;
                        this.r2i_map.put(rAI, this.maxIndex);
                        this.i2r_map.put(this.maxIndex, rAI);
                        rAI = this.getDelegate().resolveIteratorNext(itAI);
                    }
                    this.getDelegate().freeIterator(itAI);
                }
                rC = this.getDelegate().resolveIteratorNext(itC);
            }
            this.getDelegate().freeIterator(itC);
        }
        return true;
    }

    private synchronized boolean saveMap() {
        if (this.mapLocation == null) {
            return false;
        }
        File f = new File(this.mapLocation);
        File fbak = new File(String.valueOf(this.mapLocation) + "bak");
        if (fbak.exists() && fbak.isFile()) {
            fbak.delete();
        }
        if (f.exists() && f.isFile()) {
            f.renameTo(fbak);
        }
        FilterOutputStream out = null;
        try {
            out = new DataOutputStream(new FileOutputStream(f));
            Map<Long, Long> m = this.i2r_map;
            for (Long index : m.keySet()) {
                ((DataOutputStream)out).writeLong(index);
                ((DataOutputStream)out).writeLong(m.get(index));
            }
            out.close();
            return true;
        }
        catch (IOException e) {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (f.exists() && f.isFile()) {
                f.delete();
            }
            if (fbak.exists() && fbak.isFile()) {
                fbak.renameTo(f);
            }
            return false;
        }
    }

    @Override
    public synchronized boolean exists(String location) {
        return this.getDelegate().exists(location);
    }

    @Override
    public synchronized boolean open(String location) {
        boolean retVal = this.getDelegate().open(location);
        if (retVal) {
            int i = location.indexOf("file:///");
            if (i >= 0) {
                location = location.substring(8);
            } else {
                i = location.indexOf("file:/");
                if (i >= 0) {
                    location = location.substring(6);
                }
            }
            File f = new File(location);
            this.mapLocation = f.isDirectory() ? String.valueOf(f.getParent()) + File.separator + f.getName() + File.separator + "writable_references.map" : String.valueOf(f.getParent()) + File.separator + f.getName() + ".map";
            if (this.readMap()) {
                return true;
            }
            this.mapLocation = null;
            this.getDelegate().close();
            return false;
        }
        return retVal;
    }

    @Override
    public synchronized void close() {
        this.getDelegate().close();
        this.mapLocation = null;
        this.i2r_map.clear();
        this.r2i_map.clear();
    }

    @Override
    public synchronized boolean startSave() {
        if (!this.getDelegate().startSave()) {
            return false;
        }
        if (!this.saveMap()) {
            this.getDelegate().cancelSave();
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean finishSave() {
        if (this.getDelegate().finishSave()) {
            File fbak = new File(String.valueOf(this.mapLocation) + "bak");
            fbak.delete();
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean cancelSave() {
        File f = new File(this.mapLocation);
        File fbak = new File(String.valueOf(this.mapLocation) + "bak");
        if (f.exists() && f.isFile()) {
            f.delete();
        }
        if (fbak.exists() && fbak.isFile()) {
            fbak.renameTo(f);
        }
        return this.getDelegate().cancelSave();
    }

    @Override
    public synchronized boolean drop(String location) {
        File f1 = new File(location);
        File f = null;
        if (f1.isDirectory() || f1.isFile()) {
            f = new File(String.valueOf(f1.getParent()) + File.separator + f1.getName() + ".map");
        }
        if (this.getDelegate().drop(location)) {
            if (f.exists() && f.isFile()) {
                f.delete();
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized long getIteratorForLinguisticClasses() {
        PeculiarIterator pit = new PeculiarIterator();
        long it = this.getDelegate().getIteratorForLinguisticClasses();
        if (it != 0L) {
            long r = this.getDelegate().resolveIteratorFirst(it);
            while (r != 0L) {
                pit.add(this.r2i(r));
                r = this.getDelegate().resolveIteratorNext(it);
            }
            this.getDelegate().freeIterator(it);
        }
        return this.iteratorIndexer.acquireIndex(pit);
    }

    @Override
    public synchronized long getIteratorForDirectLinguisticInstances(long iClass) {
        PeculiarIterator pit = new PeculiarIterator();
        long it = this.getDelegate().getIteratorForDirectLinguisticInstances(this.i2r(iClass));
        if (it != 0L) {
            long r = this.getDelegate().resolveIteratorFirst(it);
            while (r != 0L) {
                pit.add(this.r2i(r));
                r = this.getDelegate().resolveIteratorNext(it);
            }
            this.getDelegate().freeIterator(it);
        }
        return this.iteratorIndexer.acquireIndex(pit);
    }

    @Override
    public synchronized long getIteratorForAllLinguisticInstances(long iClass) {
        PeculiarIterator pit = new PeculiarIterator();
        long it = this.getDelegate().getIteratorForAllLinguisticInstances(this.i2r(iClass));
        if (it != 0L) {
            long r = this.getDelegate().resolveIteratorFirst(it);
            while (r != 0L) {
                pit.add(this.r2i(r));
                r = this.getDelegate().resolveIteratorNext(it);
            }
            this.getDelegate().freeIterator(it);
        }
        return this.iteratorIndexer.acquireIndex(pit);
    }

    @Override
    public synchronized long getLinguisticClassFor(long i) {
        return this.r2i(this.getDelegate().getLinguisticClassFor(this.i2r(i)));
    }

    @Override
    public synchronized boolean isLinguistic(long i) {
        return this.getDelegate().isLinguistic(this.i2r(i));
    }

    @Override
    public synchronized String callSpecificOperation(String operationName, String arguments) {
        return this.getDelegate().callSpecificOperation(operationName, arguments);
    }

    @Override
    public synchronized long getMaxReference() {
        return this.maxIndex;
    }

    @Override
    public boolean setPredefinedBits(int bitsCount, long bitsValues) {
        if (bitsCount > 50) {
            return false;
        }
        this.predefinedBitsCount = bitsCount;
        this.predefinedBitsValues = bitsValues & (long)((1 << bitsCount) - 1);
        return true;
    }

    @Override
    public int getPredefinedBitsCount() {
        return this.predefinedBitsCount;
    }

    @Override
    public long getPredefinedBitsValues() {
        return this.predefinedBitsValues;
    }

    @Override
    public synchronized boolean createClass(String name, long i) {
        long r = this.getDelegate().createClass(name);
        if (r == 0L) {
            return false;
        }
        this.r2i_map.put(r, i);
        this.i2r_map.put(i, r);
        if (i > this.maxIndex) {
            this.maxIndex = i;
        }
        return true;
    }

    @Override
    public synchronized boolean createObject(long iClass, long i) {
        long r = this.getDelegate().createObject(this.i2r(iClass));
        if (r == 0L) {
            return false;
        }
        this.r2i_map.put(r, i);
        this.i2r_map.put(i, r);
        if (i > this.maxIndex) {
            this.maxIndex = i;
        }
        return true;
    }

    @Override
    public synchronized boolean createAttribute(long iClass, String name, long iType, long i) {
        long r = this.getDelegate().createAttribute(this.i2r(iClass), name, this.i2r(iType));
        if (r == 0L) {
            return false;
        }
        this.r2i_map.put(r, i);
        this.i2r_map.put(i, r);
        if (i > this.maxIndex) {
            this.maxIndex = i;
        }
        return true;
    }

    @Override
    public synchronized boolean createAssociation(long iSourceClass, long iTargetClass, String sourceRole, String targetRole, boolean isComposition, long i, long iInv) {
        long r = this.getDelegate().createAssociation(this.i2r(iSourceClass), this.i2r(iTargetClass), sourceRole, targetRole, isComposition);
        if (r == 0L) {
            return false;
        }
        long rInv = this.getDelegate().getInverseAssociationEnd(r);
        this.r2i_map.put(r, i);
        this.i2r_map.put(i, r);
        if (i > this.maxIndex) {
            this.maxIndex = i;
        }
        this.r2i_map.put(rInv, iInv);
        this.i2r_map.put(iInv, rInv);
        if (iInv > this.maxIndex) {
            this.maxIndex = iInv;
        }
        return true;
    }

    @Override
    public synchronized boolean createDirectedAssociation(long iSourceClass, long iTargetClass, String targetRole, boolean isComposition, long i) {
        long r = this.getDelegate().createDirectedAssociation(this.i2r(iSourceClass), this.i2r(iTargetClass), targetRole, isComposition);
        if (r == 0L) {
            return false;
        }
        this.r2i_map.put(r, i);
        this.i2r_map.put(i, r);
        if (i > this.maxIndex) {
            this.maxIndex = i;
        }
        return true;
    }

    @Override
    public synchronized boolean createAdvancedAssociation(String name, boolean nAry, boolean associationClass, long i) {
        long r = this.getDelegate().createAdvancedAssociation(name, nAry, associationClass);
        if (r == 0L) {
            return false;
        }
        this.r2i_map.put(r, i);
        this.i2r_map.put(i, r);
        if (i > this.maxIndex) {
            this.maxIndex = i;
        }
        return true;
    }

    class PeculiarIterator {
        private ArrayList<Long> list = new ArrayList();
        private int i = 0;

        PeculiarIterator() {
        }

        void add(long r) {
            this.list.add(r);
        }

        void addToFront(long r) {
            this.list.add(0, r);
        }

        void addAfter(long rNew, long rExisting) {
            int i = this.list.indexOf(rExisting);
            if (i == -1) {
                this.list.add(rNew);
            } else {
                this.list.add(i + 1, rNew);
            }
        }

        boolean alreadyAdded(long r) {
            return this.list.contains(r);
        }

        long resolveFirst() {
            this.i = 0;
            return this.resolveNext();
        }

        long resolveNext() {
            if (this.i < this.list.size()) {
                long r = this.list.get(this.i++);
                return r;
            }
            return 0L;
        }

        long resolve(int _i) {
            if (_i >= 0 && _i < this.list.size()) {
                Long retVal = this.list.get(_i);
                this.i = _i + 1;
                return retVal == null ? 0L : retVal;
            }
            return 0L;
        }

        int getLength() {
            return this.list.size();
        }

        void free() {
        }
    }
}

