/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.kernel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lv.lumii.tda.kernel.DelegatorToRepositoryBase;
import lv.lumii.tda.kernel.DelegatorToRepositoryWithCascadeDelete;
import lv.lumii.tda.kernel.IReferenceMapper;
import lv.lumii.tda.kernel.RAAPITransaction;
import lv.lumii.tda.raapi.IRepository;
import lv.lumii.tda.util.ReverseObjectsIndexer;

public class DelegatorToRepositoryWithObjectRecreation
extends DelegatorToRepositoryBase
implements IRepository {
    Map<Long, PeculiarIterator> peculiarIterators = new HashMap<Long, PeculiarIterator>();
    ReverseObjectsIndexer<Long> objectsIndexer = null;
    RAAPITransaction t = null;

    void registerRecreatedObject(long oldRef, long newRef) {
        if (oldRef == newRef) {
            this.objectsIndexer.freeIndex(oldRef);
        } else {
            this.objectsIndexer.set(oldRef, newRef);
        }
    }

    long recreatedObject(long oldRef) {
        Long l = this.objectsIndexer.getObject(oldRef);
        if (l == null) {
            return oldRef;
        }
        return l;
    }

    long initialReference(long currentObjectReference) {
        if (this.objectsIndexer.findIndex(currentObjectReference) == 0L && this.objectsIndexer.get(currentObjectReference) == null) {
            return currentObjectReference;
        }
        return this.objectsIndexer.getIndex(currentObjectReference);
    }

    private long peculiarize(long it, boolean forObjects) {
        if (it == 0L) {
            return 0L;
        }
        PeculiarIterator pi = new PeculiarIterator(it, forObjects);
        long r = this.delegate.resolveIteratorFirst(it);
        while (r != 0L) {
            pi.add(r);
            r = this.delegate.resolveIteratorNext(it);
        }
        this.peculiarIterators.put(it, pi);
        return it;
    }

    private long peculiarize(long it, PeculiarIterator pi) {
        this.peculiarIterators.put(it, pi);
        return it;
    }

    private long getPeculiarIteratorForIngoingAssociationEnds(long rTargetClass, boolean all) {
        long itCls = this.getIteratorForClasses();
        if (itCls == 0L) {
            return 0L;
        }
        PeculiarIterator pi = new PeculiarIterator(itCls, false);
        long rCls = this.resolveIteratorFirst(itCls);
        while (rCls != 0L) {
            long itAssoc = all ? this.getIteratorForAllOutgoingAssociationEnds(rCls) : this.getIteratorForDirectOutgoingAssociationEnds(rCls);
            if (itAssoc != 0L) {
                long rAssoc = this.resolveIteratorFirst(itAssoc);
                while (rAssoc != 0L) {
                    if (this.getTargetClass(rAssoc) == rTargetClass) {
                        pi.add(rAssoc);
                    } else {
                        this.freeReference(rAssoc);
                    }
                    rAssoc = this.resolveIteratorNext(itAssoc);
                }
                this.freeIterator(itAssoc);
            }
            this.freeReference(rCls);
            rCls = this.resolveIteratorNext(itCls);
        }
        this.peculiarIterators.put(itCls, pi);
        return itCls;
    }

    public DelegatorToRepositoryWithObjectRecreation(IRepository _delegate) {
        this.setDelegate(_delegate);
    }

    public void nullify() {
        this.delegate = null;
    }

    private boolean strOK(String name) {
        return name != null && name.length() > 0;
    }

    @Override
    public long findPrimitiveDataType(String name) {
        if (this.delegate != null && this.strOK(name)) {
            return this.delegate.findPrimitiveDataType(name);
        }
        return 0L;
    }

    @Override
    public String getPrimitiveDataTypeName(long r) {
        if (this.delegate != null && r != 0L) {
            return this.delegate.getPrimitiveDataTypeName(r);
        }
        return null;
    }

    @Override
    public boolean isPrimitiveDataType(long r) {
        if (this.delegate != null && r != 0L) {
            return this.delegate.isPrimitiveDataType(r);
        }
        return false;
    }

    @Override
    public boolean createGeneralization(long rSubClass, long rSuperClass) {
        if (this.delegate != null && rSubClass != 0L && rSuperClass != 0L) {
            if (!this.classHasObjects(rSubClass)) {
                return this.delegate.createGeneralization(rSubClass, rSuperClass);
            }
            this.startUpdateObjects(rSubClass);
            boolean retVal = this.delegate.createGeneralization(rSubClass, rSuperClass);
            this.finishUpdateObjects();
            return retVal;
        }
        return false;
    }

    @Override
    public boolean deleteGeneralization(long rSubClass, long rSuperClass) {
        if (this.delegate != null && rSubClass != 0L && rSuperClass != 0L) {
            if (!this.classHasObjects(rSubClass)) {
                return this.delegate.deleteGeneralization(rSubClass, rSuperClass);
            }
            this.startUpdateObjects(rSubClass);
            boolean retVal = this.delegate.deleteGeneralization(rSubClass, rSuperClass);
            this.finishUpdateObjects();
            return retVal;
        }
        return false;
    }

    @Override
    public boolean isClass(long param0) {
        param0 = this.recreatedObject(param0);
        return this.delegate.isClass(param0);
    }

    @Override
    public long createObject(long rClass) {
        if (this.delegate != null && rClass != 0L) {
            return this.initialReference(this.delegate.createObject(rClass));
        }
        return 0L;
    }

    @Override
    public boolean deleteObject(long rClass) {
        rClass = this.recreatedObject(rClass);
        if (this.delegate != null && rClass != 0L) {
            boolean retVal = this.delegate.deleteObject(rClass);
            return retVal;
        }
        return false;
    }

    @Override
    public boolean includeObjectInClass(long rObject, long rClass) {
        rObject = this.recreatedObject(rObject);
        if (this.delegate == null && rObject != 0L && rClass != 0L) {
            return this.delegate.includeObjectInClass(rObject, rClass);
        }
        return false;
    }

    @Override
    public boolean excludeObjectFromClass(long rObject, long rClass) {
        rObject = this.recreatedObject(rObject);
        if (this.delegate == null && rObject != 0L && rClass != 0L) {
            return this.delegate.excludeObjectFromClass(rObject, rClass);
        }
        return false;
    }

    @Override
    public boolean moveObject(long rObject, long rToClass) {
        rObject = this.recreatedObject(rObject);
        if (this.delegate == null && rObject != 0L && rToClass != 0L) {
            return this.delegate.moveObject(rObject, rToClass);
        }
        return false;
    }

    @Override
    public long getIteratorForAllClassObjects(long rClass) {
        return this.peculiarize(this.delegate.getIteratorForAllClassObjects(rClass), true);
    }

    @Override
    public long getIteratorForDirectClassObjects(long rClass) {
        return this.peculiarize(this.delegate.getIteratorForDirectClassObjects(rClass), true);
    }

    @Override
    public boolean isTypeOf(long rObject, long rClass) {
        rObject = this.recreatedObject(rObject);
        return this.delegate.isTypeOf(rObject, rClass);
    }

    @Override
    public boolean isKindOf(long rObject, long rClass) {
        rObject = this.recreatedObject(rObject);
        return this.delegate.isKindOf(rObject, rClass);
    }

    @Override
    public long createAttribute(long rClass, String name, long type) {
        if (this.delegate != null) {
            long r = this.findAttribute(rClass, name);
            if (r != 0L) {
                this.freeReference(r);
                return 0L;
            }
            if (!this.classHasObjects(rClass)) {
                return this.delegate.createAttribute(rClass, name, type);
            }
            this.startUpdateObjects(rClass);
            long retVal = this.delegate.createAttribute(rClass, name, type);
            this.finishUpdateObjects();
            return retVal;
        }
        return 0L;
    }

    @Override
    public boolean deleteAttribute(long rAttr) {
        if (this.delegate != null && rAttr != 0L) {
            long rClass = this.delegate.getAttributeDomain(rAttr);
            if (!this.classHasObjects(rClass)) {
                this.delegate.freeReference(rClass);
                return this.delegate.deleteAttribute(rAttr);
            }
            this.startUpdateObjects(rClass);
            boolean retVal = this.delegate.deleteAttribute(rAttr);
            this.finishUpdateObjects();
            this.delegate.freeReference(rClass);
            return retVal;
        }
        return false;
    }

    @Override
    public boolean isAttribute(long param0) {
        param0 = this.recreatedObject(param0);
        return this.delegate.isAttribute(param0);
    }

    @Override
    public boolean setAttributeValue(long rObject, long rAttribute, String value) {
        rObject = this.recreatedObject(rObject);
        if (this.delegate != null && rObject != 0L && rAttribute != 0L) {
            if (value == null) {
                return this.delegate.deleteAttributeValue(rObject, rAttribute);
            }
            boolean retVal = this.delegate.setAttributeValue(rObject, rAttribute, value);
            return retVal;
        }
        return false;
    }

    @Override
    public String getAttributeValue(long rObject, long rAttribute) {
        rObject = this.recreatedObject(rObject);
        if (this.delegate != null && rObject != 0L && rAttribute != 0L) {
            return this.delegate.getAttributeValue(rObject, rAttribute);
        }
        return null;
    }

    @Override
    public boolean deleteAttributeValue(long rObject, long rAttribute) {
        rObject = this.recreatedObject(rObject);
        if (this.delegate != null && rObject != 0L && rAttribute != 0L) {
            return this.delegate.deleteAttributeValue(rObject, rAttribute);
        }
        return false;
    }

    @Override
    public long getIteratorForObjectsByAttributeValue(long param0, String param1) {
        if (this.delegate != null) {
            return this.peculiarize(this.delegate.getIteratorForObjectsByAttributeValue(param0, param1), true);
        }
        return 0L;
    }

    @Override
    public long createAssociation(long rSourceClass, long rTargetClass, String sourceRoleName, String targetRoleName, boolean isComposition) {
        if (this.delegate != null && rSourceClass != 0L && rTargetClass != 0L) {
            long r = this.findAssociationEnd(rSourceClass, targetRoleName);
            if (r != 0L) {
                this.freeReference(r);
                return 0L;
            }
            r = this.findAssociationEnd(rTargetClass, sourceRoleName);
            if (r != 0L) {
                this.freeReference(r);
                return 0L;
            }
            if (!this.classHasObjects(rSourceClass) && !this.classHasObjects(rTargetClass)) {
                return this.delegate.createAssociation(rSourceClass, rTargetClass, sourceRoleName, targetRoleName, isComposition);
            }
            this.startUpdateObjects(rSourceClass);
            this.startUpdateObjects(rTargetClass);
            long retVal = this.delegate.createAssociation(rSourceClass, rTargetClass, sourceRoleName, targetRoleName, isComposition);
            this.finishUpdateObjects();
            return retVal;
        }
        return 0L;
    }

    @Override
    public long createDirectedAssociation(long rSourceClass, long rTargetClass, String targetRoleName, boolean isComposition) {
        if (this.delegate != null && rSourceClass != 0L && rTargetClass != 0L) {
            long r = this.findAssociationEnd(rSourceClass, targetRoleName);
            if (r != 0L) {
                this.freeReference(r);
                return 0L;
            }
            if (!this.classHasObjects(rSourceClass) && !this.classHasObjects(rTargetClass)) {
                return this.delegate.createDirectedAssociation(rSourceClass, rTargetClass, targetRoleName, isComposition);
            }
            this.startUpdateObjects(rSourceClass);
            this.startUpdateObjects(rTargetClass);
            long retVal = this.delegate.createDirectedAssociation(rSourceClass, rTargetClass, targetRoleName, isComposition);
            this.finishUpdateObjects();
            return retVal;
        }
        return 0L;
    }

    @Override
    public boolean deleteAssociation(long rAssoc) {
        if (this.delegate != null && rAssoc != 0L) {
            long rSrcCls = this.delegate.getSourceClass(rAssoc);
            long rTgtCls = this.delegate.getTargetClass(rAssoc);
            if (!this.classHasObjects(rSrcCls) && !this.classHasObjects(rTgtCls)) {
                this.delegate.freeReference(rSrcCls);
                this.delegate.freeReference(rTgtCls);
                return this.delegate.deleteAssociation(rAssoc);
            }
            this.startUpdateObjects(rSrcCls);
            this.startUpdateObjects(rTgtCls);
            boolean retVal = this.delegate.deleteAssociation(rAssoc);
            this.finishUpdateObjects();
            this.delegate.freeReference(rSrcCls);
            this.delegate.freeReference(rTgtCls);
            return retVal;
        }
        return false;
    }

    @Override
    public boolean createLink(long rSourceObject, long rTargetObject, long rAssociation) {
        rSourceObject = this.recreatedObject(rSourceObject);
        rTargetObject = this.recreatedObject(rTargetObject);
        if (this.delegate != null && rSourceObject != 0L && rTargetObject != 0L && rAssociation != 0L) {
            return this.delegate.createLink(rSourceObject, rTargetObject, rAssociation);
        }
        return false;
    }

    @Override
    public boolean createOrderedLink(long rSourceObject, long rTargetObject, long rAssociation, int targetPosition) {
        if (this.delegate == null || rSourceObject == 0L || rTargetObject == 0L || rAssociation == 0L) {
            return false;
        }
        rSourceObject = this.recreatedObject(rSourceObject);
        rTargetObject = this.recreatedObject(rTargetObject);
        return this.delegate.createOrderedLink(rSourceObject, rTargetObject, rAssociation, targetPosition);
    }

    @Override
    public boolean deleteLink(long rSourceObject, long rTargetObject, long rAssociation) {
        rSourceObject = this.recreatedObject(rSourceObject);
        rTargetObject = this.recreatedObject(rTargetObject);
        if (this.delegate != null && rSourceObject != 0L && rTargetObject != 0L && rAssociation != 0L) {
            return this.delegate.deleteLink(rSourceObject, rTargetObject, rAssociation);
        }
        return false;
    }

    @Override
    public boolean linkExists(long rSourceObject, long rTargetObject, long rAssociationEnd) {
        rSourceObject = this.recreatedObject(rSourceObject);
        rTargetObject = this.recreatedObject(rTargetObject);
        if (rSourceObject == 0L || rTargetObject == 0L || rAssociationEnd == 0L) {
            return false;
        }
        return this.delegate.linkExists(rSourceObject, rTargetObject, rAssociationEnd);
    }

    @Override
    public long getIteratorForLinkedObjects(long rObject, long rAssociationEnd) {
        rObject = this.recreatedObject(rObject);
        if (this.delegate != null) {
            return this.peculiarize(this.delegate.getIteratorForLinkedObjects(rObject, rAssociationEnd), true);
        }
        return 0L;
    }

    @Override
    public int getLinkedObjectPosition(long rSourceObject, long rTargetObject, long rAssociation) {
        if (this.delegate == null || rSourceObject == 0L || rTargetObject == 0L || rAssociation == 0L) {
            return -1;
        }
        rSourceObject = this.recreatedObject(rSourceObject);
        rTargetObject = this.recreatedObject(rTargetObject);
        return this.delegate.getLinkedObjectPosition(rSourceObject, rTargetObject, rAssociation);
    }

    @Override
    public long resolveIteratorFirst(long it) {
        if (this.delegate != null && it != 0L) {
            PeculiarIterator pi = this.peculiarIterators.get(it);
            if (pi == null) {
                return this.delegate.resolveIteratorFirst(it);
            }
            return pi.resolveFirst();
        }
        return 0L;
    }

    @Override
    public long resolveIteratorNext(long it) {
        if (this.delegate != null && it != 0L) {
            PeculiarIterator pi = this.peculiarIterators.get(it);
            if (pi == null) {
                return this.delegate.resolveIteratorNext(it);
            }
            return pi.resolveNext();
        }
        return 0L;
    }

    @Override
    public int getIteratorLength(long it) {
        if (this.delegate != null && it != 0L) {
            PeculiarIterator pi = this.peculiarIterators.get(it);
            if (pi == null) {
                try {
                    return this.delegate.getIteratorLength(it);
                }
                catch (UnsupportedOperationException e) {
                    this.peculiarize(it, false);
                    pi = this.peculiarIterators.get(it);
                    if (pi == null) {
                        return 0;
                    }
                    return pi.getLength();
                }
            }
            return pi.getLength();
        }
        return 0;
    }

    @Override
    public long resolveIterator(long it, int position) {
        if (this.delegate != null && it != 0L) {
            PeculiarIterator pi = this.peculiarIterators.get(it);
            if (pi == null) {
                try {
                    return this.delegate.resolveIterator(it, position);
                }
                catch (UnsupportedOperationException e) {
                    this.peculiarize(it, false);
                    pi = this.peculiarIterators.get(it);
                    if (pi == null) {
                        return 0L;
                    }
                    return pi.resolve(position);
                }
            }
            return pi.resolve(position);
        }
        return 0L;
    }

    @Override
    public void freeReference(long r) {
        if (this.delegate == null || r == 0L) {
            return;
        }
        this.delegate.freeReference(r);
    }

    @Override
    public void freeIterator(long it) {
        if (this.delegate != null && it != 0L) {
            PeculiarIterator pi = this.peculiarIterators.remove(it);
            if (pi == null) {
                this.delegate.freeIterator(it);
            } else {
                pi.free();
            }
        } else {
            return;
        }
    }

    @Override
    public String serializeReference(long r) {
        if (this.delegate != null && r != 0L) {
            try {
                return this.delegate.serializeReference(r);
            }
            catch (UnsupportedOperationException e) {
                return new Long(r).toString();
            }
        }
        return null;
    }

    @Override
    public long deserializeReference(String s) {
        if (this.delegate != null) {
            try {
                return this.delegate.deserializeReference(s);
            }
            catch (UnsupportedOperationException e) {
                try {
                    return Long.parseLong(s);
                }
                catch (Throwable t) {
                    return 0L;
                }
            }
        }
        return 0L;
    }

    @Override
    public long getIteratorForLinguisticClasses() {
        if (this.delegate != null) {
            return this.delegate.getIteratorForLinguisticClasses();
        }
        return 0L;
    }

    @Override
    public long getIteratorForDirectLinguisticInstances(long r) {
        if (this.delegate != null && r != 0L) {
            return this.delegate.getIteratorForDirectLinguisticInstances(r);
        }
        return 0L;
    }

    @Override
    public long getIteratorForAllLinguisticInstances(long r) {
        if (this.delegate != null && r != 0L) {
            return this.delegate.getIteratorForAllLinguisticInstances(r);
        }
        return 0L;
    }

    @Override
    public long getLinguisticClassFor(long r) {
        if (this.delegate != null && r != 0L) {
            return this.delegate.getLinguisticClassFor(r);
        }
        return 0L;
    }

    @Override
    public boolean isLinguistic(long r) {
        if (this.delegate != null && r != 0L) {
            return this.delegate.isLinguistic(r);
        }
        return false;
    }

    @Override
    public String callSpecificOperation(String operationName, String arguments) {
        if (this.delegate != null && operationName != null) {
            return this.delegate.callSpecificOperation(operationName, arguments);
        }
        return null;
    }

    private boolean classHasObjects(long rClass) {
        boolean hasObjects = false;
        long it = this.getIteratorForAllClassObjects(rClass);
        if (it != 0L) {
            long r = this.resolveIteratorFirst(it);
            if (r != 0L) {
                hasObjects = true;
                this.freeReference(r);
            }
            this.freeIterator(it);
        }
        return hasObjects;
    }

    private boolean startUpdateObjects(long rClass) {
        if (this.t == null) {
            this.t = new RAAPITransaction(this, new IReferenceMapper(){

                @Override
                public long getStableReference(long r) {
                    return r;
                }

                @Override
                public long getUnstableReference(long rStableReference) {
                    return rStableReference;
                }

                @Override
                public boolean redirectStableReference(long rOldStableReference, long rNewUnstableReference) {
                    DelegatorToRepositoryWithObjectRecreation.this.registerRecreatedObject(rOldStableReference, rNewUnstableReference);
                    return true;
                }

                @Override
                public void releaseStableReference(long rStableReference) {
                }
            });
        }
        return this.startUpdateObjects(this.t, rClass);
    }

    private boolean startUpdateObjects(RAAPITransaction raapi, long rClass) {
        boolean ok = true;
        long it = raapi.getIteratorForDirectSubClasses(rClass);
        long rSubCls = raapi.resolveIteratorFirst(it);
        while (rSubCls != 0L) {
            if (!this.startUpdateObjects(raapi, rSubCls)) {
                ok = false;
            }
            raapi.freeReference(rSubCls);
            rSubCls = raapi.resolveIteratorNext(it);
        }
        this.freeIterator(it);
        it = raapi.getIteratorForDirectClassObjects(rClass);
        long rObj = raapi.resolveIteratorFirst(it);
        while (rObj != 0L) {
            if (!DelegatorToRepositoryWithCascadeDelete.cascadeDeleteObject(rObj, raapi, false, true)) {
                ok = false;
            }
            rObj = raapi.resolveIteratorNext(it);
        }
        raapi.freeIterator(it);
        return ok;
    }

    private void finishUpdateObjects() {
        this.t.undo();
        this.t.clear();
        this.t = null;
    }

    @Override
    public boolean open(String location) {
        if (this.delegate instanceof IRepository) {
            if (this.objectsIndexer == null) {
                this.objectsIndexer = new ReverseObjectsIndexer();
                this.objectsIndexer.set(0L, 0L);
            }
            return this.delegate.open(location);
        }
        return false;
    }

    @Override
    public void close() {
        if (this.delegate instanceof IRepository) {
            this.delegate.close();
        }
        this.objectsIndexer = null;
    }

    class PeculiarIterator {
        private ArrayList<Long> list = new ArrayList();
        private int i = 0;
        private long it;
        private boolean forObjects;

        PeculiarIterator(long _it, boolean _forObjects) {
            this.it = _it;
            this.forObjects = _forObjects;
        }

        void add(long r) {
            String name;
            if (DelegatorToRepositoryWithObjectRecreation.this.isClass(r) && (name = DelegatorToRepositoryWithObjectRecreation.this.delegate.getClassName(r)) != null && (name.startsWith(".") || name.contains("::."))) {
                DelegatorToRepositoryWithObjectRecreation.this.delegate.freeReference(r);
                return;
            }
            if (DelegatorToRepositoryWithObjectRecreation.this.isAssociationEnd(r) && (name = DelegatorToRepositoryWithObjectRecreation.this.delegate.getRoleName(r)) != null && name.startsWith(".")) {
                DelegatorToRepositoryWithObjectRecreation.this.delegate.freeReference(r);
                return;
            }
            if (DelegatorToRepositoryWithObjectRecreation.this.isAttribute(r) && (name = DelegatorToRepositoryWithObjectRecreation.this.delegate.getAttributeName(r)) != null && name.startsWith(".")) {
                DelegatorToRepositoryWithObjectRecreation.this.delegate.freeReference(r);
                return;
            }
            if (this.forObjects) {
                this.list.add(DelegatorToRepositoryWithObjectRecreation.this.initialReference(r));
            } else {
                this.list.add(r);
            }
        }

        long resolveFirst() {
            this.i = 0;
            return this.resolveNext();
        }

        long resolveNext() {
            if (this.i < this.list.size()) {
                return this.list.get(this.i++);
            }
            return 0L;
        }

        long resolve(int _i) {
            if (_i >= this.list.size()) {
                return 0L;
            }
            Long retVal = this.list.get(_i);
            this.i = _i + 1;
            return retVal == null ? 0L : retVal;
        }

        int getLength() {
            return this.list.size();
        }

        void free() {
            for (Long l : this.list) {
                DelegatorToRepositoryWithObjectRecreation.this.delegate.freeReference(l);
            }
            DelegatorToRepositoryWithObjectRecreation.this.delegate.freeIterator(this.it);
        }
    }
}

