/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.kernel;

import java.util.ArrayList;
import java.util.LinkedList;
import lv.lumii.tda.kernel.DelegatorToRepositoryBase;
import lv.lumii.tda.kernel.IReferenceMapper;
import lv.lumii.tda.kernel.RAAPITransaction;
import lv.lumii.tda.raapi.IRepository;
import lv.lumii.tda.raapi.RAAPI;

public class DelegatorToRepositoryWithCascadeDelete
extends DelegatorToRepositoryBase {
    public DelegatorToRepositoryWithCascadeDelete(IRepository _delegate) {
        this.setDelegate(_delegate);
    }

    @Override
    public synchronized boolean deleteGeneralization(long rSubClass, long rSuperClass) {
        long itAttr = this.getIteratorForAllAttributes(rSuperClass);
        long rAttr = this.resolveIteratorFirst(itAttr);
        while (rAttr != 0L) {
            long it = this.getIteratorForAllClassObjects(rSubClass);
            long r = this.resolveIteratorFirst(it);
            while (r != 0L) {
                this.deleteAttributeValue(r, rAttr);
                this.freeReference(r);
                r = this.resolveIteratorNext(it);
            }
            this.freeIterator(it);
            this.freeReference(rAttr);
            rAttr = this.resolveIteratorNext(itAttr);
        }
        this.freeIterator(itAttr);
        long itAssoc = this.getIteratorForAllOutgoingAssociationEnds(rSuperClass);
        long rAssoc = this.resolveIteratorFirst(itAssoc);
        while (rAssoc != 0L) {
            long it = this.getIteratorForAllClassObjects(rSubClass);
            long r = this.resolveIteratorFirst(it);
            while (r != 0L) {
                long itLinked = this.getIteratorForLinkedObjects(r, rAssoc);
                LinkedList<Long> linkedObjs = new LinkedList<Long>();
                long rLinked = this.resolveIteratorFirst(itLinked);
                while (rLinked != 0L) {
                    linkedObjs.add(rLinked);
                    rLinked = this.resolveIteratorNext(itLinked);
                }
                this.freeIterator(itLinked);
                for (Long rLinked2 : linkedObjs) {
                    this.deleteLink(r, rLinked2, rAssoc);
                    if (this.isComposition(rAssoc)) {
                        this.deleteObject(rLinked2);
                        continue;
                    }
                    this.freeReference(rLinked2);
                }
                this.freeReference(r);
                r = this.resolveIteratorNext(it);
            }
            this.freeIterator(it);
            this.freeReference(rAssoc);
            rAssoc = this.resolveIteratorNext(itAssoc);
        }
        this.freeIterator(itAssoc);
        itAssoc = this.getIteratorForAllIngoingAssociationEnds(rSuperClass);
        rAssoc = this.resolveIteratorFirst(itAssoc);
        while (rAssoc != 0L) {
            long rSourceClass = this.getSourceClass(rAssoc);
            long it = this.getIteratorForAllClassObjects(rSourceClass);
            long r = this.resolveIteratorFirst(it);
            while (r != 0L) {
                long itLinked = this.getIteratorForLinkedObjects(r, rAssoc);
                long rLinked = this.resolveIteratorFirst(itLinked);
                while (rLinked != 0L) {
                    if (this.isKindOf(rLinked, rSubClass)) {
                        this.deleteLink(r, rLinked, rAssoc);
                        if (this.isComposition(rAssoc)) {
                            this.deleteObject(rLinked);
                        } else {
                            this.freeReference(rLinked);
                        }
                    } else {
                        this.freeReference(rLinked);
                    }
                    rLinked = this.resolveIteratorNext(itLinked);
                }
                this.freeIterator(itLinked);
                this.freeReference(r);
                r = this.resolveIteratorNext(it);
            }
            this.freeIterator(it);
            this.freeReference(rAssoc);
            rAssoc = this.resolveIteratorNext(itAssoc);
        }
        this.freeIterator(itAssoc);
        return super.deleteGeneralization(rSubClass, rSuperClass);
    }

    @Override
    public synchronized boolean deleteAttribute(long rAttr) {
        long rClass = this.getAttributeDomain(rAttr);
        long it = this.getIteratorForAllClassObjects(rClass);
        long r = this.resolveIteratorFirst(it);
        while (r != 0L) {
            this.deleteAttributeValue(r, rAttr);
            this.freeReference(r);
            r = this.resolveIteratorNext(it);
        }
        this.freeIterator(it);
        this.freeReference(rClass);
        return super.deleteAttribute(rAttr);
    }

    @Override
    public synchronized boolean deleteAssociation(long rAssoc) {
        long rClass = this.getSourceClass(rAssoc);
        long it = this.getIteratorForAllClassObjects(rClass);
        long r = this.resolveIteratorFirst(it);
        while (r != 0L) {
            long itLinked = this.getIteratorForLinkedObjects(r, rAssoc);
            long rLinked = this.resolveIteratorFirst(itLinked);
            while (rLinked != 0L) {
                this.deleteLink(r, rLinked, rAssoc);
                if (this.isComposition(rAssoc)) {
                    this.deleteObject(rLinked);
                } else {
                    this.freeReference(rLinked);
                }
                rLinked = this.resolveIteratorNext(itLinked);
            }
            this.freeIterator(itLinked);
            this.freeReference(r);
            r = this.resolveIteratorNext(it);
        }
        this.freeIterator(it);
        this.freeReference(rClass);
        boolean retVal = super.deleteAssociation(rAssoc);
        return retVal;
    }

    @Override
    public synchronized boolean deleteClass(long rClass) {
        block9: {
            long r;
            long it;
            while ((it = this.getIteratorForDirectSubClasses(rClass)) != 0L) {
                r = this.resolveIteratorFirst(it);
                this.freeIterator(it);
                if (r != 0L) {
                    boolean ok = this.deleteGeneralization(r, rClass);
                    if (!this.deleteClass(r)) {
                        ok = false;
                    }
                    if (!ok) {
                        return false;
                    }
                }
                if (r != 0L) continue;
            }
            while ((it = this.getIteratorForDirectAttributes(rClass)) != 0L) {
                r = this.resolveIteratorFirst(it);
                this.freeIterator(it);
                if (r == 0L) break;
                if (this.deleteAttribute(r)) continue;
                return false;
            }
            it = this.getIteratorForDirectOutgoingAssociationEnds(rClass);
            r = this.resolveIteratorFirst(it);
            while (r != 0L) {
                this.deleteAssociation(r);
                r = this.resolveIteratorNext(it);
            }
            this.freeIterator(it);
            it = this.getIteratorForDirectIngoingAssociationEnds(rClass);
            r = this.resolveIteratorFirst(it);
            while (r != 0L) {
                this.deleteAssociation(r);
                r = this.resolveIteratorNext(it);
            }
            this.freeIterator(it);
            it = this.getIteratorForDirectSuperClasses(rClass);
            r = this.resolveIteratorFirst(it);
            while (r != 0L) {
                this.deleteGeneralization(rClass, r);
                this.freeReference(r);
                r = this.resolveIteratorNext(it);
            }
            this.freeIterator(it);
            do {
                it = this.getIteratorForDirectClassObjects(rClass);
                r = this.resolveIteratorFirst(it);
                this.freeIterator(it);
                if (r == 0L) break block9;
            } while (this.deleteObject(r));
            this.freeReference(r);
        }
        boolean retVal = super.deleteClass(rClass);
        return retVal;
    }

    @Override
    public synchronized boolean deleteObject(long rObject) {
        DelegatorToRepositoryWithCascadeDelete.cascadeDeleteObject(rObject, this, true, false);
        boolean retVal = super.deleteObject(rObject);
        return retVal;
    }

    public static synchronized boolean cascadeDeleteObject(long rObject, RAAPI raapi, boolean keepObject, boolean keepContainments) {
        long itCls = raapi.getIteratorForDirectObjectClasses(rObject);
        long rCls = raapi.resolveIteratorFirst(itCls);
        while (rCls != 0L) {
            long itA = raapi.getIteratorForAllAttributes(rCls);
            long rA = raapi.resolveIteratorFirst(itA);
            while (rA != 0L) {
                raapi.deleteAttributeValue(rObject, rA);
                raapi.freeReference(rA);
                rA = raapi.resolveIteratorNext(itA);
            }
            raapi.freeIterator(itA);
            itA = raapi.getIteratorForAllOutgoingAssociationEnds(rCls);
            rA = raapi.resolveIteratorFirst(itA);
            while (rA != 0L) {
                int i;
                ArrayList<Long> l = new ArrayList<Long>();
                long itLinked = raapi.getIteratorForLinkedObjects(rObject, rA);
                if (itLinked == 0L) break;
                long rLinked = raapi.resolveIteratorFirst(itLinked);
                while (rLinked != 0L) {
                    if (rLinked == rObject) {
                        DelegatorToRepositoryWithCascadeDelete.deleteLinkRecursively(raapi, rObject, rObject, rA);
                        raapi.freeReference(rLinked);
                    } else {
                        l.add(rLinked);
                    }
                    rLinked = raapi.resolveIteratorNext(itLinked);
                }
                raapi.freeIterator(itLinked);
                if (!keepContainments && raapi.isComposition(rA)) {
                    i = l.size() - 1;
                    while (i >= 0) {
                        DelegatorToRepositoryWithCascadeDelete.deleteLinkRecursively(raapi, rObject, (Long)l.get(i), rA);
                        DelegatorToRepositoryWithCascadeDelete.cascadeDeleteObject((Long)l.get(i), raapi, false, false);
                        raapi.freeReference((Long)l.get(i));
                        --i;
                    }
                } else {
                    i = l.size() - 1;
                    while (i >= 0) {
                        DelegatorToRepositoryWithCascadeDelete.deleteLinkRecursively(raapi, rObject, (Long)l.get(i), rA);
                        raapi.freeReference((Long)l.get(i));
                        --i;
                    }
                }
                raapi.freeReference(rA);
                rA = raapi.resolveIteratorNext(itA);
            }
            raapi.freeIterator(itA);
            itA = raapi.getIteratorForAllIngoingAssociationEnds(rCls);
            rA = raapi.resolveIteratorFirst(itA);
            while (rA != 0L) {
                long rAInv = raapi.getInverseAssociationEnd(rA);
                if (rAInv == 0L) {
                    long rSrcCls = raapi.getSourceClass(rA);
                    long itSrcObj = raapi.getIteratorForAllClassObjects(rSrcCls);
                    long rSrcObj = raapi.resolveIteratorFirst(itSrcObj);
                    while (rSrcObj != 0L) {
                        if (raapi.linkExists(rSrcObj, rObject, rA)) {
                            DelegatorToRepositoryWithCascadeDelete.deleteLinkRecursively(raapi, rSrcObj, rObject, rA);
                        }
                        rSrcObj = raapi.resolveIteratorNext(itSrcObj);
                    }
                    raapi.freeIterator(itSrcObj);
                    raapi.freeReference(rA);
                } else {
                    raapi.freeReference(rAInv);
                    raapi.freeReference(rA);
                }
                rA = raapi.resolveIteratorNext(itA);
            }
            raapi.freeIterator(itA);
            raapi.freeReference(rCls);
            rCls = raapi.resolveIteratorNext(itCls);
        }
        raapi.freeIterator(itCls);
        if (keepObject) {
            return true;
        }
        itCls = raapi.getIteratorForDirectObjectClasses(rObject);
        if (itCls != 0L) {
            rCls = raapi.resolveIteratorFirst(itCls);
            if (rCls != 0L) {
                raapi.freeReference(rCls);
                rCls = raapi.resolveIteratorNext(itCls);
                while (rCls != 0L) {
                    raapi.excludeObjectFromClass(rObject, rCls);
                    raapi.freeReference(rCls);
                    rCls = raapi.resolveIteratorNext(itCls);
                }
            }
            raapi.freeIterator(itCls);
        }
        if (keepObject) {
            return true;
        }
        return raapi.deleteObject(rObject);
    }

    public static synchronized boolean deleteLinkRecursively(RAAPI raapi, long rSourceObject, long rTargetObject, long rAssociationEnd) {
        RAAPITransaction t = new RAAPITransaction(raapi, new IReferenceMapper(){

            @Override
            public long getStableReference(long r) {
                return r;
            }

            @Override
            public long getUnstableReference(long rStableReference) {
                return rStableReference;
            }

            @Override
            public boolean redirectStableReference(long rOldStableReference, long rNewUnstableReference) {
                return false;
            }

            @Override
            public void releaseStableReference(long rStableReference) {
            }
        });
        boolean retVal = DelegatorToRepositoryWithCascadeDelete.deleteLinkRecursively(t, rSourceObject, rTargetObject, rAssociationEnd, false, true);
        retVal = retVal && raapi.deleteLink(rSourceObject, rTargetObject, rAssociationEnd);
        t.undo();
        return retVal;
    }

    static synchronized String getObjectClassName(RAAPI raapi, long rObject) {
        long it = raapi.getIteratorForDirectObjectClasses(rObject);
        if (it == 0L) {
            return null;
        }
        long rCls = raapi.resolveIteratorFirst(it);
        raapi.freeIterator(it);
        if (rCls == 0L) {
            return null;
        }
        String clsName = raapi.getClassName(rCls);
        raapi.freeReference(rCls);
        return clsName;
    }

    private static boolean deleteLinkRecursively(RAAPI raapi, long rSourceObject, long rTargetObject, long rAssociationEnd, boolean lastLink, boolean keepLink) {
        ArrayList<Long> furtherTargetObjects = new ArrayList<Long>();
        if (!lastLink) {
            long it = raapi.getIteratorForLinkedObjects(rSourceObject, rAssociationEnd);
            if (it == 0L) {
                return false;
            }
            long r = raapi.resolveIteratorFirst(it);
            boolean targetReached = false;
            while (r != 0L) {
                if (r == rTargetObject) {
                    targetReached = true;
                    raapi.freeReference(r);
                } else if (targetReached) {
                    furtherTargetObjects.add(r);
                } else {
                    raapi.freeReference(r);
                }
                r = raapi.resolveIteratorNext(it);
            }
            raapi.freeIterator(it);
            int i = furtherTargetObjects.size() - 1;
            while (i >= 0) {
                DelegatorToRepositoryWithCascadeDelete.deleteLinkRecursively(raapi, rSourceObject, (Long)furtherTargetObjects.get(i), rAssociationEnd, true, false);
                --i;
            }
            for (Long l : furtherTargetObjects) {
                raapi.freeReference(l);
            }
        }
        ArrayList<Long> furtherSourceObjects = new ArrayList<Long>();
        long rInverseAssociationEnd = raapi.getInverseAssociationEnd(rAssociationEnd);
        if (rInverseAssociationEnd != 0L) {
            long it = raapi.getIteratorForLinkedObjects(rTargetObject, rInverseAssociationEnd);
            if (it != 0L) {
                long r = raapi.resolveIteratorFirst(it);
                boolean sourceReached = false;
                while (r != 0L) {
                    if (r == rSourceObject) {
                        sourceReached = true;
                        raapi.freeReference(r);
                    } else if (sourceReached) {
                        furtherSourceObjects.add(r);
                    } else {
                        raapi.freeReference(r);
                    }
                    r = raapi.resolveIteratorNext(it);
                }
                raapi.freeIterator(it);
            }
            int i = furtherSourceObjects.size() - 1;
            while (i >= 0) {
                DelegatorToRepositoryWithCascadeDelete.deleteLinkRecursively(raapi, rTargetObject, (Long)furtherSourceObjects.get(i), rInverseAssociationEnd, true, false);
                --i;
            }
            for (Long l : furtherSourceObjects) {
                raapi.freeReference(l);
            }
            raapi.freeReference(rInverseAssociationEnd);
        }
        if (keepLink) {
            return true;
        }
        return raapi.deleteLink(rSourceObject, rTargetObject, rAssociationEnd);
    }

    @Override
    public synchronized boolean deleteLink(long rSourceObject, long rTargetObject, long rAssociationEnd) {
        return DelegatorToRepositoryWithCascadeDelete.deleteLinkRecursively(this.getDelegate(), rSourceObject, rTargetObject, rAssociationEnd);
    }
}

