/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.ee.mm;

import java.util.ArrayList;
import lv.lumii.tda.ee.mm.Command;
import lv.lumii.tda.ee.mm.EnvironmentEngineMetamodelFactory;
import lv.lumii.tda.ee.mm.Event;
import lv.lumii.tda.ee.mm.RAAPIReferenceWrapper;
import lv.lumii.tda.raapi.RAAPI;

public class Submitter
implements RAAPIReferenceWrapper {
    protected EnvironmentEngineMetamodelFactory factory;
    protected long rObject = 0L;
    protected boolean takeReference;

    @Override
    public RAAPI getRAAPI() {
        return this.factory.raapi;
    }

    @Override
    public long getRAAPIReference() {
        return this.rObject;
    }

    @Override
    public boolean delete() {
        if (this.rObject != 0L) {
            if (!this.takeReference) {
                System.err.println("Unable to delete the object " + this.rObject + " of type TDAKernel::Submitter since the RAAPI wrapper does not take care of this reference.");
                return false;
            }
            this.factory.wrappers.remove(this.rObject);
            boolean retVal = this.factory.raapi.deleteObject(this.rObject);
            if (retVal) {
                this.rObject = 0L;
            } else {
                this.factory.wrappers.put(this.rObject, this);
            }
            return retVal;
        }
        return false;
    }

    public void finalize() {
        if (this.rObject != 0L) {
            if (this.takeReference) {
                this.factory.wrappers.remove(this.rObject);
                this.factory.raapi.freeReference(this.rObject);
            }
            this.rObject = 0L;
        }
    }

    Submitter(EnvironmentEngineMetamodelFactory _factory) {
        this.factory = _factory;
        this.rObject = this.factory.raapi.createObject(this.factory.SUBMITTER);
        this.takeReference = true;
        this.factory.wrappers.put(this.rObject, this);
    }

    public Submitter(EnvironmentEngineMetamodelFactory _factory, long _rObject, boolean _takeReference) {
        this.factory = _factory;
        this.rObject = _rObject;
        this.takeReference = _takeReference;
        if (this.takeReference) {
            this.factory.wrappers.put(this.rObject, this);
        }
    }

    public static Iterable<? extends Submitter> allObjects() {
        return Submitter.allObjects(EnvironmentEngineMetamodelFactory.eINSTANCE);
    }

    public static Iterable<? extends Submitter> allObjects(EnvironmentEngineMetamodelFactory factory) {
        ArrayList<Submitter> retVal = new ArrayList<Submitter>();
        long it = factory.raapi.getIteratorForAllClassObjects(factory.SUBMITTER);
        if (it == 0L) {
            return retVal;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        while (r != 0L) {
            Submitter o = (Submitter)factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (o == null) {
                o = (Submitter)factory.findOrCreateRAAPIReferenceWrapper(Submitter.class, r, true);
            }
            if (o != null) {
                retVal.add(o);
            }
            r = factory.raapi.resolveIteratorNext(it);
        }
        factory.raapi.freeIterator(it);
        return retVal;
    }

    public static boolean deleteAllObjects() {
        return Submitter.deleteAllObjects(EnvironmentEngineMetamodelFactory.eINSTANCE);
    }

    public static boolean deleteAllObjects(EnvironmentEngineMetamodelFactory factory) {
        for (Submitter submitter : Submitter.allObjects(factory)) {
            submitter.delete();
        }
        return Submitter.firstObject(factory) == null;
    }

    public static Submitter firstObject() {
        return Submitter.firstObject(EnvironmentEngineMetamodelFactory.eINSTANCE);
    }

    public static Submitter firstObject(EnvironmentEngineMetamodelFactory factory) {
        long it = factory.raapi.getIteratorForAllClassObjects(factory.SUBMITTER);
        if (it == 0L) {
            return null;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        factory.raapi.freeIterator(it);
        if (r == 0L) {
            return null;
        }
        Submitter retVal = (Submitter)factory.findOrCreateRAAPIReferenceWrapper(r, true);
        if (retVal == null) {
            retVal = (Submitter)factory.findOrCreateRAAPIReferenceWrapper(Submitter.class, r, true);
        }
        return retVal;
    }

    public Event getEvent() {
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.SUBMITTER_EVENT);
        if (it == 0L) {
            return null;
        }
        long r = this.factory.raapi.resolveIteratorFirst(it);
        this.factory.raapi.freeIterator(it);
        if (r != 0L) {
            Event retVal = (Event)this.factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (retVal == null) {
                retVal = (Event)this.factory.findOrCreateRAAPIReferenceWrapper(Event.class, r, true);
            }
            return retVal;
        }
        return null;
    }

    public boolean setEvent(Event value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.SUBMITTER_EVENT);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.SUBMITTER_EVENT)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.SUBMITTER_EVENT)) {
            ok = false;
        }
        return ok;
    }

    public Command getCommand() {
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.SUBMITTER_COMMAND);
        if (it == 0L) {
            return null;
        }
        long r = this.factory.raapi.resolveIteratorFirst(it);
        this.factory.raapi.freeIterator(it);
        if (r != 0L) {
            Command retVal = (Command)this.factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (retVal == null) {
                retVal = (Command)this.factory.findOrCreateRAAPIReferenceWrapper(Command.class, r, true);
            }
            return retVal;
        }
        return null;
    }

    public boolean setCommand(Command value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.SUBMITTER_COMMAND);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.SUBMITTER_COMMAND)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.SUBMITTER_COMMAND)) {
            ok = false;
        }
        return ok;
    }
}

