/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.ee.mm;

import java.util.ArrayList;
import java.util.List;
import lv.lumii.tda.ee.mm.Command;
import lv.lumii.tda.ee.mm.EnvironmentEngine;
import lv.lumii.tda.ee.mm.EnvironmentEngineMetamodelFactory;
import lv.lumii.tda.ee.mm.EnvironmentEngineMetamodel_RAAPILinkedObjectsList;
import lv.lumii.tda.ee.mm.RAAPIReferenceWrapper;
import lv.lumii.tda.raapi.RAAPI;

public class RefreshOptionsCommand
extends Command
implements RAAPIReferenceWrapper {
    @Override
    public RAAPI getRAAPI() {
        return this.factory.raapi;
    }

    @Override
    public long getRAAPIReference() {
        return this.rObject;
    }

    @Override
    public boolean delete() {
        if (this.rObject != 0L) {
            if (!this.takeReference) {
                System.err.println("Unable to delete the object " + this.rObject + " of type RefreshOptionsCommand since the RAAPI wrapper does not take care of this reference.");
                return false;
            }
            this.factory.wrappers.remove(this.rObject);
            boolean retVal = this.factory.raapi.deleteObject(this.rObject);
            if (retVal) {
                this.rObject = 0L;
            } else {
                this.factory.wrappers.put(this.rObject, this);
            }
            return retVal;
        }
        return false;
    }

    @Override
    public void finalize() {
        if (this.rObject != 0L) {
            if (this.takeReference) {
                this.factory.wrappers.remove(this.rObject);
                this.factory.raapi.freeReference(this.rObject);
            }
            this.rObject = 0L;
        }
    }

    RefreshOptionsCommand(EnvironmentEngineMetamodelFactory _factory) {
        super(_factory, _factory.raapi.createObject(_factory.REFRESHOPTIONSCOMMAND), true);
        this.factory = _factory;
        this.rObject = this.rObject;
        this.takeReference = true;
        this.factory.wrappers.put(this.rObject, this);
    }

    public RefreshOptionsCommand(EnvironmentEngineMetamodelFactory _factory, long _rObject, boolean _takeReference) {
        super(_factory, _rObject, _takeReference);
    }

    public static Iterable<? extends RefreshOptionsCommand> allObjects() {
        return RefreshOptionsCommand.allObjects(EnvironmentEngineMetamodelFactory.eINSTANCE);
    }

    public static Iterable<? extends RefreshOptionsCommand> allObjects(EnvironmentEngineMetamodelFactory factory) {
        ArrayList<RefreshOptionsCommand> retVal = new ArrayList<RefreshOptionsCommand>();
        long it = factory.raapi.getIteratorForAllClassObjects(factory.REFRESHOPTIONSCOMMAND);
        if (it == 0L) {
            return retVal;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        while (r != 0L) {
            RefreshOptionsCommand o = (RefreshOptionsCommand)factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (o == null) {
                o = (RefreshOptionsCommand)factory.findOrCreateRAAPIReferenceWrapper(RefreshOptionsCommand.class, r, true);
            }
            if (o != null) {
                retVal.add(o);
            }
            r = factory.raapi.resolveIteratorNext(it);
        }
        factory.raapi.freeIterator(it);
        return retVal;
    }

    public static boolean deleteAllObjects() {
        return RefreshOptionsCommand.deleteAllObjects(EnvironmentEngineMetamodelFactory.eINSTANCE);
    }

    public static boolean deleteAllObjects(EnvironmentEngineMetamodelFactory factory) {
        for (RefreshOptionsCommand refreshOptionsCommand : RefreshOptionsCommand.allObjects(factory)) {
            refreshOptionsCommand.delete();
        }
        return RefreshOptionsCommand.firstObject(factory) == null;
    }

    public static RefreshOptionsCommand firstObject() {
        return RefreshOptionsCommand.firstObject(EnvironmentEngineMetamodelFactory.eINSTANCE);
    }

    public static RefreshOptionsCommand firstObject(EnvironmentEngineMetamodelFactory factory) {
        long it = factory.raapi.getIteratorForAllClassObjects(factory.REFRESHOPTIONSCOMMAND);
        if (it == 0L) {
            return null;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        factory.raapi.freeIterator(it);
        if (r == 0L) {
            return null;
        }
        RefreshOptionsCommand retVal = (RefreshOptionsCommand)factory.findOrCreateRAAPIReferenceWrapper(r, true);
        if (retVal == null) {
            retVal = (RefreshOptionsCommand)factory.findOrCreateRAAPIReferenceWrapper(RefreshOptionsCommand.class, r, true);
        }
        return retVal;
    }

    public List<EnvironmentEngine> getEnvironmentEngine() {
        return new EnvironmentEngineMetamodel_RAAPILinkedObjectsList<EnvironmentEngine>(this.factory, this.rObject, this.factory.REFRESHOPTIONSCOMMAND_ENVIRONMENTENGINE);
    }

    public boolean setEnvironmentEngine(EnvironmentEngine value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.REFRESHOPTIONSCOMMAND_ENVIRONMENTENGINE);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.REFRESHOPTIONSCOMMAND_ENVIRONMENTENGINE)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.REFRESHOPTIONSCOMMAND_ENVIRONMENTENGINE)) {
            ok = false;
        }
        return ok;
    }
}

