/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.ee.mm;

import java.util.ArrayList;
import java.util.List;
import lv.lumii.tda.ee.mm.Engine;
import lv.lumii.tda.ee.mm.EnvironmentEngineMetamodelFactory;
import lv.lumii.tda.ee.mm.EnvironmentEngineMetamodel_RAAPILinkedObjectsList;
import lv.lumii.tda.ee.mm.Frame;
import lv.lumii.tda.ee.mm.Option;
import lv.lumii.tda.ee.mm.RAAPIReferenceWrapper;
import lv.lumii.tda.ee.mm.RefreshOptionsCommand;
import lv.lumii.tda.raapi.RAAPI;

public class EnvironmentEngine
extends Engine
implements RAAPIReferenceWrapper {
    @Override
    public RAAPI getRAAPI() {
        return this.factory.raapi;
    }

    @Override
    public long getRAAPIReference() {
        return this.rObject;
    }

    @Override
    public boolean delete() {
        if (this.rObject != 0L) {
            if (!this.takeReference) {
                System.err.println("Unable to delete the object " + this.rObject + " of type EnvironmentEngine since the RAAPI wrapper does not take care of this reference.");
                return false;
            }
            this.factory.wrappers.remove(this.rObject);
            boolean retVal = this.factory.raapi.deleteObject(this.rObject);
            if (retVal) {
                this.rObject = 0L;
            } else {
                this.factory.wrappers.put(this.rObject, this);
            }
            return retVal;
        }
        return false;
    }

    @Override
    public void finalize() {
        if (this.rObject != 0L) {
            if (this.takeReference) {
                this.factory.wrappers.remove(this.rObject);
                this.factory.raapi.freeReference(this.rObject);
            }
            this.rObject = 0L;
        }
    }

    EnvironmentEngine(EnvironmentEngineMetamodelFactory _factory) {
        super(_factory, _factory.raapi.createObject(_factory.ENVIRONMENTENGINE), true);
        this.factory = _factory;
        this.rObject = this.rObject;
        this.takeReference = true;
        this.factory.wrappers.put(this.rObject, this);
    }

    public EnvironmentEngine(EnvironmentEngineMetamodelFactory _factory, long _rObject, boolean _takeReference) {
        super(_factory, _rObject, _takeReference);
    }

    public static Iterable<? extends EnvironmentEngine> allObjects() {
        return EnvironmentEngine.allObjects(EnvironmentEngineMetamodelFactory.eINSTANCE);
    }

    public static Iterable<? extends EnvironmentEngine> allObjects(EnvironmentEngineMetamodelFactory factory) {
        ArrayList<EnvironmentEngine> retVal = new ArrayList<EnvironmentEngine>();
        long it = factory.raapi.getIteratorForAllClassObjects(factory.ENVIRONMENTENGINE);
        if (it == 0L) {
            return retVal;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        while (r != 0L) {
            EnvironmentEngine o = (EnvironmentEngine)factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (o == null) {
                o = (EnvironmentEngine)factory.findOrCreateRAAPIReferenceWrapper(EnvironmentEngine.class, r, true);
            }
            if (o != null) {
                retVal.add(o);
            }
            r = factory.raapi.resolveIteratorNext(it);
        }
        factory.raapi.freeIterator(it);
        return retVal;
    }

    public static boolean deleteAllObjects() {
        return EnvironmentEngine.deleteAllObjects(EnvironmentEngineMetamodelFactory.eINSTANCE);
    }

    public static boolean deleteAllObjects(EnvironmentEngineMetamodelFactory factory) {
        for (EnvironmentEngine environmentEngine : EnvironmentEngine.allObjects(factory)) {
            environmentEngine.delete();
        }
        return EnvironmentEngine.firstObject(factory) == null;
    }

    public static EnvironmentEngine firstObject() {
        return EnvironmentEngine.firstObject(EnvironmentEngineMetamodelFactory.eINSTANCE);
    }

    public static EnvironmentEngine firstObject(EnvironmentEngineMetamodelFactory factory) {
        long it = factory.raapi.getIteratorForAllClassObjects(factory.ENVIRONMENTENGINE);
        if (it == 0L) {
            return null;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        factory.raapi.freeIterator(it);
        if (r == 0L) {
            return null;
        }
        EnvironmentEngine retVal = (EnvironmentEngine)factory.findOrCreateRAAPIReferenceWrapper(r, true);
        if (retVal == null) {
            retVal = (EnvironmentEngine)factory.findOrCreateRAAPIReferenceWrapper(EnvironmentEngine.class, r, true);
        }
        return retVal;
    }

    public String getLanguage() {
        return this.factory.raapi.getAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_LANGUAGE);
    }

    public boolean setLanguage(String value) {
        if (value == null) {
            return this.factory.raapi.deleteAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_LANGUAGE);
        }
        return this.factory.raapi.setAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_LANGUAGE, value.toString());
    }

    public String getCountry() {
        return this.factory.raapi.getAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_COUNTRY);
    }

    public boolean setCountry(String value) {
        if (value == null) {
            return this.factory.raapi.deleteAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_COUNTRY);
        }
        return this.factory.raapi.setAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_COUNTRY, value.toString());
    }

    public Boolean getAnyUnsavedChanges() {
        try {
            String value = this.factory.raapi.getAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_ANYUNSAVEDCHANGES);
            if (value == null) {
            }
            return Boolean.parseBoolean(value);
        }
        finally {
            return null;
        }
    }

    public boolean setAnyUnsavedChanges(Boolean value) {
        if (value == null) {
            return this.factory.raapi.deleteAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_ANYUNSAVEDCHANGES);
        }
        return this.factory.raapi.setAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_ANYUNSAVEDCHANGES, value.toString());
    }

    public String getCommonBinDirectory() {
        return this.factory.raapi.getAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_COMMONBINDIRECTORY);
    }

    public boolean setCommonBinDirectory(String value) {
        if (value == null) {
            return this.factory.raapi.deleteAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_COMMONBINDIRECTORY);
        }
        return this.factory.raapi.setAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_COMMONBINDIRECTORY, value.toString());
    }

    public String getSpecificBinDirectory() {
        return this.factory.raapi.getAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_SPECIFICBINDIRECTORY);
    }

    public boolean setSpecificBinDirectory(String value) {
        if (value == null) {
            return this.factory.raapi.deleteAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_SPECIFICBINDIRECTORY);
        }
        return this.factory.raapi.setAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_SPECIFICBINDIRECTORY, value.toString());
    }

    public String getProjectDirectory() {
        return this.factory.raapi.getAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_PROJECTDIRECTORY);
    }

    public boolean setProjectDirectory(String value) {
        if (value == null) {
            return this.factory.raapi.deleteAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_PROJECTDIRECTORY);
        }
        return this.factory.raapi.setAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_PROJECTDIRECTORY, value.toString());
    }

    public String getOnProjectOpenedEvent() {
        return this.factory.raapi.getAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_ONPROJECTOPENEDEVENT);
    }

    public boolean setOnProjectOpenedEvent(String value) {
        if (value == null) {
            return this.factory.raapi.deleteAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_ONPROJECTOPENEDEVENT);
        }
        return this.factory.raapi.setAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_ONPROJECTOPENEDEVENT, value.toString());
    }

    public String getOnProjectClosingEvent() {
        return this.factory.raapi.getAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_ONPROJECTCLOSINGEVENT);
    }

    public boolean setOnProjectClosingEvent(String value) {
        if (value == null) {
            return this.factory.raapi.deleteAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_ONPROJECTCLOSINGEVENT);
        }
        return this.factory.raapi.setAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_ONPROJECTCLOSINGEVENT, value.toString());
    }

    public List<Option> getOption() {
        return new EnvironmentEngineMetamodel_RAAPILinkedObjectsList<Option>(this.factory, this.rObject, this.factory.ENVIRONMENTENGINE_OPTION);
    }

    public boolean setOption(Option value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.ENVIRONMENTENGINE_OPTION);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.ENVIRONMENTENGINE_OPTION)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.ENVIRONMENTENGINE_OPTION)) {
            ok = false;
        }
        return ok;
    }

    public List<Frame> getFrame() {
        return new EnvironmentEngineMetamodel_RAAPILinkedObjectsList<Frame>(this.factory, this.rObject, this.factory.ENVIRONMENTENGINE_FRAME);
    }

    public boolean setFrame(Frame value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.ENVIRONMENTENGINE_FRAME);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.ENVIRONMENTENGINE_FRAME)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.ENVIRONMENTENGINE_FRAME)) {
            ok = false;
        }
        return ok;
    }

    public List<RefreshOptionsCommand> getRefreshOptionsCommand() {
        return new EnvironmentEngineMetamodel_RAAPILinkedObjectsList<RefreshOptionsCommand>(this.factory, this.rObject, this.factory.ENVIRONMENTENGINE_REFRESHOPTIONSCOMMAND);
    }

    public boolean setRefreshOptionsCommand(RefreshOptionsCommand value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.ENVIRONMENTENGINE_REFRESHOPTIONSCOMMAND);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.ENVIRONMENTENGINE_REFRESHOPTIONSCOMMAND)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.ENVIRONMENTENGINE_REFRESHOPTIONSCOMMAND)) {
            ok = false;
        }
        return ok;
    }

    public String getDefaultSaveDirectory() {
        return this.factory.raapi.getAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_DEFAULTSAVEDIRECTORY);
    }

    public boolean setDefaultSaveDirectory(String value) {
        if (value == null) {
            return this.factory.raapi.deleteAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_DEFAULTSAVEDIRECTORY);
        }
        return this.factory.raapi.setAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_DEFAULTSAVEDIRECTORY, value.toString());
    }

    public String getStatus() {
        return this.factory.raapi.getAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_STATUS);
    }

    public boolean setStatus(String value) {
        if (value == null) {
            return this.factory.raapi.deleteAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_STATUS);
        }
        return this.factory.raapi.setAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_STATUS, value.toString());
    }

    public String getCloudLocation() {
        return this.factory.raapi.getAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_CLOUDLOCATION);
    }

    public boolean setCloudLocation(String value) {
        if (value == null) {
            return this.factory.raapi.deleteAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_CLOUDLOCATION);
        }
        return this.factory.raapi.setAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_CLOUDLOCATION, value.toString());
    }

    public String getClientSessionId() {
        return this.factory.raapi.getAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_CLIENTSESSIONID);
    }

    public boolean setClientSessionId(String value) {
        if (value == null) {
            return this.factory.raapi.deleteAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_CLIENTSESSIONID);
        }
        return this.factory.raapi.setAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_CLIENTSESSIONID, value.toString());
    }

    public Integer getClientActionIndex() {
        try {
            String value = this.factory.raapi.getAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_CLIENTACTIONINDEX);
            if (value == null) {
            }
            return Integer.parseInt(value);
        }
        finally {
            return null;
        }
    }

    public boolean setClientActionIndex(Integer value) {
        if (value == null) {
            return this.factory.raapi.deleteAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_CLIENTACTIONINDEX);
        }
        return this.factory.raapi.setAttributeValue(this.rObject, this.factory.ENVIRONMENTENGINE_CLIENTACTIONINDEX, value.toString());
    }
}

