/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.ee.mm;

import java.util.ArrayList;
import lv.lumii.tda.ee.mm.EnvironmentEngineMetamodelFactory;
import lv.lumii.tda.ee.mm.RAAPIReferenceWrapper;
import lv.lumii.tda.ee.mm.Submitter;
import lv.lumii.tda.raapi.RAAPI;

public class Command
implements RAAPIReferenceWrapper {
    protected EnvironmentEngineMetamodelFactory factory;
    protected long rObject = 0L;
    protected boolean takeReference;

    @Override
    public RAAPI getRAAPI() {
        return this.factory.raapi;
    }

    @Override
    public long getRAAPIReference() {
        return this.rObject;
    }

    @Override
    public boolean delete() {
        if (this.rObject != 0L) {
            if (!this.takeReference) {
                System.err.println("Unable to delete the object " + this.rObject + " of type TDAKernel::Command since the RAAPI wrapper does not take care of this reference.");
                return false;
            }
            this.factory.wrappers.remove(this.rObject);
            boolean retVal = this.factory.raapi.deleteObject(this.rObject);
            if (retVal) {
                this.rObject = 0L;
            } else {
                this.factory.wrappers.put(this.rObject, this);
            }
            return retVal;
        }
        return false;
    }

    public void finalize() {
        if (this.rObject != 0L) {
            if (this.takeReference) {
                this.factory.wrappers.remove(this.rObject);
                this.factory.raapi.freeReference(this.rObject);
            }
            this.rObject = 0L;
        }
    }

    public boolean submit() {
        long SUBMITTER_ROLE = this.factory.raapi.findAssociationEnd(this.factory.COMMAND, "submitter");
        boolean retVal = this.factory.raapi.createLink(this.rObject, Submitter.firstObject((EnvironmentEngineMetamodelFactory)this.factory).rObject, SUBMITTER_ROLE);
        this.factory.raapi.freeReference(SUBMITTER_ROLE);
        return retVal;
    }

    Command(EnvironmentEngineMetamodelFactory _factory) {
        this.factory = _factory;
        this.rObject = this.factory.raapi.createObject(this.factory.COMMAND);
        this.takeReference = true;
        this.factory.wrappers.put(this.rObject, this);
    }

    public Command(EnvironmentEngineMetamodelFactory _factory, long _rObject, boolean _takeReference) {
        this.factory = _factory;
        this.rObject = _rObject;
        this.takeReference = _takeReference;
        if (this.takeReference) {
            this.factory.wrappers.put(this.rObject, this);
        }
    }

    public static Iterable<? extends Command> allObjects() {
        return Command.allObjects(EnvironmentEngineMetamodelFactory.eINSTANCE);
    }

    public static Iterable<? extends Command> allObjects(EnvironmentEngineMetamodelFactory factory) {
        ArrayList<Command> retVal = new ArrayList<Command>();
        long it = factory.raapi.getIteratorForAllClassObjects(factory.COMMAND);
        if (it == 0L) {
            return retVal;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        while (r != 0L) {
            Command o = (Command)factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (o == null) {
                o = (Command)factory.findOrCreateRAAPIReferenceWrapper(Command.class, r, true);
            }
            if (o != null) {
                retVal.add(o);
            }
            r = factory.raapi.resolveIteratorNext(it);
        }
        factory.raapi.freeIterator(it);
        return retVal;
    }

    public static boolean deleteAllObjects() {
        return Command.deleteAllObjects(EnvironmentEngineMetamodelFactory.eINSTANCE);
    }

    public static boolean deleteAllObjects(EnvironmentEngineMetamodelFactory factory) {
        for (Command command : Command.allObjects(factory)) {
            command.delete();
        }
        return Command.firstObject(factory) == null;
    }

    public static Command firstObject() {
        return Command.firstObject(EnvironmentEngineMetamodelFactory.eINSTANCE);
    }

    public static Command firstObject(EnvironmentEngineMetamodelFactory factory) {
        long it = factory.raapi.getIteratorForAllClassObjects(factory.COMMAND);
        if (it == 0L) {
            return null;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        factory.raapi.freeIterator(it);
        if (r == 0L) {
            return null;
        }
        Command retVal = (Command)factory.findOrCreateRAAPIReferenceWrapper(r, true);
        if (retVal == null) {
            retVal = (Command)factory.findOrCreateRAAPIReferenceWrapper(Command.class, r, true);
        }
        return retVal;
    }

    public Submitter getSubmitter() {
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.COMMAND_SUBMITTER);
        if (it == 0L) {
            return null;
        }
        long r = this.factory.raapi.resolveIteratorFirst(it);
        this.factory.raapi.freeIterator(it);
        if (r != 0L) {
            Submitter retVal = (Submitter)this.factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (retVal == null) {
                retVal = (Submitter)this.factory.findOrCreateRAAPIReferenceWrapper(Submitter.class, r, true);
            }
            return retVal;
        }
        return null;
    }

    public boolean setSubmitter(Submitter value) {
        boolean ok = true;
        long it = this.factory.raapi.getIteratorForLinkedObjects(this.rObject, this.factory.COMMAND_SUBMITTER);
        if (it != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            long r = this.factory.raapi.resolveIteratorFirst(it);
            while (r != 0L) {
                list.add(r);
                r = this.factory.raapi.resolveIteratorNext(it);
            }
            this.factory.raapi.freeIterator(it);
            for (Long rLinked : list) {
                if (this.factory.raapi.deleteLink(this.rObject, rLinked, this.factory.COMMAND_SUBMITTER)) continue;
                ok = false;
            }
        }
        if (value != null && !this.factory.raapi.createLink(this.rObject, value.rObject, this.factory.COMMAND_SUBMITTER)) {
            ok = false;
        }
        return ok;
    }
}

