/*
 * Decompiled with CFR 0.152.
 */
package lv.lumii.tda.ee.mm;

import java.util.ArrayList;
import lv.lumii.tda.ee.mm.Command;
import lv.lumii.tda.ee.mm.EnvironmentEngineMetamodelFactory;
import lv.lumii.tda.ee.mm.RAAPIReferenceWrapper;
import lv.lumii.tda.ee.mm.Submitter;
import lv.lumii.tda.raapi.RAAPI;

public class AsyncCommand
extends Command
implements RAAPIReferenceWrapper {
    @Override
    public RAAPI getRAAPI() {
        return this.factory.raapi;
    }

    @Override
    public long getRAAPIReference() {
        return this.rObject;
    }

    @Override
    public boolean delete() {
        if (this.rObject != 0L) {
            if (!this.takeReference) {
                System.err.println("Unable to delete the object " + this.rObject + " of type TDAKernel::AsyncCommand since the RAAPI wrapper does not take care of this reference.");
                return false;
            }
            this.factory.wrappers.remove(this.rObject);
            boolean retVal = this.factory.raapi.deleteObject(this.rObject);
            if (retVal) {
                this.rObject = 0L;
            } else {
                this.factory.wrappers.put(this.rObject, this);
            }
            return retVal;
        }
        return false;
    }

    @Override
    public void finalize() {
        if (this.rObject != 0L) {
            if (this.takeReference) {
                this.factory.wrappers.remove(this.rObject);
                this.factory.raapi.freeReference(this.rObject);
            }
            this.rObject = 0L;
        }
    }

    @Override
    public boolean submit() {
        long SUBMITTER_ROLE = this.factory.raapi.findAssociationEnd(this.factory.ASYNCCOMMAND, "submitter");
        boolean retVal = this.factory.raapi.createLink(this.rObject, Submitter.firstObject((EnvironmentEngineMetamodelFactory)this.factory).rObject, SUBMITTER_ROLE);
        this.factory.raapi.freeReference(SUBMITTER_ROLE);
        return retVal;
    }

    AsyncCommand(EnvironmentEngineMetamodelFactory _factory) {
        super(_factory, _factory.raapi.createObject(_factory.ASYNCCOMMAND), true);
        this.factory = _factory;
        this.rObject = this.rObject;
        this.takeReference = true;
        this.factory.wrappers.put(this.rObject, this);
    }

    public AsyncCommand(EnvironmentEngineMetamodelFactory _factory, long _rObject, boolean _takeReference) {
        super(_factory, _rObject, _takeReference);
    }

    public static Iterable<? extends AsyncCommand> allObjects() {
        return AsyncCommand.allObjects(EnvironmentEngineMetamodelFactory.eINSTANCE);
    }

    public static Iterable<? extends AsyncCommand> allObjects(EnvironmentEngineMetamodelFactory factory) {
        ArrayList<AsyncCommand> retVal = new ArrayList<AsyncCommand>();
        long it = factory.raapi.getIteratorForAllClassObjects(factory.ASYNCCOMMAND);
        if (it == 0L) {
            return retVal;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        while (r != 0L) {
            AsyncCommand o = (AsyncCommand)factory.findOrCreateRAAPIReferenceWrapper(r, true);
            if (o == null) {
                o = (AsyncCommand)factory.findOrCreateRAAPIReferenceWrapper(AsyncCommand.class, r, true);
            }
            if (o != null) {
                retVal.add(o);
            }
            r = factory.raapi.resolveIteratorNext(it);
        }
        factory.raapi.freeIterator(it);
        return retVal;
    }

    public static boolean deleteAllObjects() {
        return AsyncCommand.deleteAllObjects(EnvironmentEngineMetamodelFactory.eINSTANCE);
    }

    public static boolean deleteAllObjects(EnvironmentEngineMetamodelFactory factory) {
        for (AsyncCommand asyncCommand : AsyncCommand.allObjects(factory)) {
            asyncCommand.delete();
        }
        return AsyncCommand.firstObject(factory) == null;
    }

    public static AsyncCommand firstObject() {
        return AsyncCommand.firstObject(EnvironmentEngineMetamodelFactory.eINSTANCE);
    }

    public static AsyncCommand firstObject(EnvironmentEngineMetamodelFactory factory) {
        long it = factory.raapi.getIteratorForAllClassObjects(factory.ASYNCCOMMAND);
        if (it == 0L) {
            return null;
        }
        long r = factory.raapi.resolveIteratorFirst(it);
        factory.raapi.freeIterator(it);
        if (r == 0L) {
            return null;
        }
        AsyncCommand retVal = (AsyncCommand)factory.findOrCreateRAAPIReferenceWrapper(r, true);
        if (retVal == null) {
            retVal = (AsyncCommand)factory.findOrCreateRAAPIReferenceWrapper(AsyncCommand.class, r, true);
        }
        return retVal;
    }
}

